/*
 * xdemineur 1.1 - X11 minefield game
 *
 * Author: Marc Baudoin (baudoin@ensta.fr)
 *
 *            |\
 *          |\| \
 *          |//  )
 *        |\ /  /        /\/\_
 *        |//  /        /. . /
 *      |\ /  /     ___/    |_
 *      |//  /     (____/    /_/\_
 *       |__|      (_____/ __     >
 *     /| ___  ________ _< \ \__  >
 *     \|| __\| _|_   _/ \\ \___\/
 *       | __\____ | |/ _ \\    >
 *     /||___\_____|___/ \_\\  _>
 *     \|____           ____ \|
 *       \   \_________/   /
 *        \   _    _      /
 *         \_//   //_____/
 *           (_   \ (_  _\
 *             |/\|   \/
 *
 * Ecole Nationale Superieure de Techniques Avancees (ENSTA)
 * 32, boulevard Victor - 75015 Paris - France
 *
 * Copyright (C) 1993 Marc Baudoin
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation.  The author makes no representations about
 * the suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 */



#include <X11/Xlib.h>

#include "demineur.h"
#include "xdemineur.h"

#include "bitmaps/numero_0.bm"
#include "bitmaps/numero_1.bm"
#include "bitmaps/numero_2.bm"
#include "bitmaps/numero_3.bm"
#include "bitmaps/numero_4.bm"
#include "bitmaps/numero_5.bm"
#include "bitmaps/numero_6.bm"
#include "bitmaps/numero_7.bm"
#include "bitmaps/numero_8.bm"
#include "bitmaps/numero_9.bm"

#include "bitmaps/num_case_0.bm"
#include "bitmaps/num_case_1.bm"
#include "bitmaps/num_case_2.bm"
#include "bitmaps/num_case_3.bm"
#include "bitmaps/num_case_4.bm"
#include "bitmaps/num_case_5.bm"
#include "bitmaps/num_case_6.bm"
#include "bitmaps/num_case_7.bm"
#include "bitmaps/num_case_8.bm"

#include "bitmaps/couleur/icone_blanc.bm"
#include "bitmaps/couleur/icone_gris.bm"
#include "bitmaps/couleur/select_blanc.bm"
#include "bitmaps/couleur/select_gris.bm"
#include "bitmaps/couleur/icone.bm"
#include "bitmaps/couleur/bof.bm"
#include "bitmaps/couleur/heureux.bm"
#include "bitmaps/couleur/triste.bm"
#include "bitmaps/couleur/joue.bm"

#include "bitmaps/couleur/relief_blanc.bm"
#include "bitmaps/couleur/relief_gris.bm"
#include "bitmaps/couleur/case.bm"
#include "bitmaps/couleur/pied.bm"
#include "bitmaps/couleur/drapeau.bm"
#include "bitmaps/couleur/interro.bm"

#include "bitmaps/couleur/mine.bm"
#include "bitmaps/couleur/reflet.bm"
#include "bitmaps/couleur/manquee.bm"
#include "bitmaps/couleur/croix.bm"
#include "bitmaps/couleur/reflet_manquee.bm"

#include "bitmaps/nb/nb_fond.bm"
#include "bitmaps/nb/nb_bof.bm"
#include "bitmaps/nb/nb_heureux.bm"
#include "bitmaps/nb/nb_triste.bm"
#include "bitmaps/nb/nb_joue.bm"
#include "bitmaps/nb/nb_icone_select.bm"
#include "bitmaps/nb/nb_case.bm"
#include "bitmaps/nb/nb_drapeau.bm"
#include "bitmaps/nb/nb_interro.bm"
#include "bitmaps/nb/nb_mine.bm"
#include "bitmaps/nb/nb_mine_perdu.bm"
#include "bitmaps/nb/nb_manquee.bm"

extern struct jeu    **tableau ;
extern int             nb_lig , nb_col , mines ;
extern time_t          temps ;
extern BOOLEAN         perdu , gagne ;

extern Display        *display ;
extern int             screen ;
extern Window          window ;
extern GC              gc ;

static Bool     ecran_couleur ;

static Pixmap   fond , numero [ 10 ] ,
                bof , heureux , triste , joue , icone_select ,
                case_relief , marquee , interro ,
                num_case [ 9 ] , mine , mine_perdu , manquee ;
static char    *couleur [ ] = { "blue"   , "green" , "red" , "navy" ,
                                "orchid" , "seagreen" , "sienna" , "deeppink" } ;

static unsigned long noir , blanc , gris ;

typedef struct mon_pixmap
{
   char *bits ;
   unsigned long couleur ;
}
MON_PIXMAP ;

/* ~~~~~~~~~~~~~~~~~~~~~~~~~ Gestion de l'affichage ~~~~~~~~~~~~~~~~~~~~~~~~~ */

Pixmap copie ( pixmap , width , height , nb )
struct mon_pixmap pixmap [ ] ;
unsigned int width , height ;
int nb ;
{
   Pixmap result ;
   int i , x , y , n , m ;

   result = XCreatePixmapFromBitmapData ( display ,
                                          RootWindow ( display , screen ) ,
                                          pixmap [ 0 ] . bits ,
                                          width  , height ,
                                          pixmap [ 0 ] . couleur ,
                                          BlackPixel ( display , screen ) ,
                                          DefaultDepth ( display , screen ) ) ;

   for ( i = 1 ; i < nb ; i ++ )
   {
      XSetForeground ( display , gc , pixmap [ i ] . couleur ) ;
      n = m = 0 ;
      for ( y = 0 ; y < height ; y ++ )
      {
         if ( m != 0 )
         {
            n ++ ;
         }
         m = 0 ;
         for ( x = 0 ; x < width ; x ++ )
         {
            if ( pixmap [ i ] . bits [ n ] & ( 1 << m ) )
            {
               XDrawPoint ( display , result , gc , x , y ) ;
            }
            m ++ ;
            if ( m == 8 )
            {
               m = 0 ;
               n ++ ;
            }
         }
      }
   }
   return result ;
}

cree_pixmaps ( )
{
   Window          root_window ;
   Colormap        default_colormap ;
   XColor          color ;
   unsigned long   gris_clair , jaune , rouge , fore [ 10 ] ;
   int             i ;
   unsigned int    default_depth ;
   MON_PIXMAP      pixmap [ 4 ] ;

   if ( DefaultDepth ( display , screen ) == 1 )
   {
      ecran_couleur = False ;
   }
   else
   {
      ecran_couleur = True ;
   }

   root_window   = RootWindow   ( display , screen ) ;

   if ( ecran_couleur == True )
   {
      default_colormap = DefaultColormap ( display , screen ) ;
      XParseColor ( display , default_colormap , "black" , &color ) ;
      XAllocColor ( display , default_colormap , &color ) ;
      noir = color . pixel ;
      XParseColor ( display , default_colormap , "white" , &color ) ;
      XAllocColor ( display , default_colormap , &color ) ;
      blanc = color . pixel ;
      XParseColor ( display , default_colormap , "gray50" , &color ) ;
      XAllocColor ( display , default_colormap , &color ) ;
      gris = color . pixel ;
      XParseColor ( display , default_colormap , "gray70" , &color ) ;
      XAllocColor ( display , default_colormap , &color ) ;
      gris_clair = color . pixel ;
      XParseColor ( display , default_colormap , "yellow" , &color ) ;
      XAllocColor ( display , default_colormap , &color ) ;
      jaune = color . pixel ;
      fore [ 0 ] = gris_clair ;
      for ( i = 1 ; i <= 8 ; i ++ )
      {
         XParseColor ( display , default_colormap , couleur [ i - 1 ] , &color ) ;
         XAllocColor ( display , default_colormap , &color ) ;
         fore [ i ] = color . pixel ;
      }
      rouge = fore [ 3 ] ;

      XSetWindowBackground ( display , window , gris_clair ) ;

      default_depth = DefaultDepth ( display , screen ) ;

      numero [ 0 ] = XCreatePixmapFromBitmapData ( display , root_window ,
                                                   numero_0_bits ,
                                                   numero_0_width ,
                                                   numero_0_height ,
                                                   noir , rouge ,
                                                   default_depth ) ;
      numero [ 1 ] = XCreatePixmapFromBitmapData ( display , root_window ,
                                                   numero_1_bits ,
                                                   numero_1_width ,
                                                   numero_1_height ,
                                                   noir , rouge ,
                                                   default_depth ) ;
      numero [ 2 ] = XCreatePixmapFromBitmapData ( display , root_window ,
                                                   numero_2_bits ,
                                                   numero_2_width ,
                                                   numero_2_height ,
                                                   noir , rouge ,
                                                   default_depth ) ;
      numero [ 3 ] = XCreatePixmapFromBitmapData ( display , root_window ,
                                                   numero_3_bits ,
                                                   numero_3_width ,
                                                   numero_3_height ,
                                                   noir , rouge ,
                                                   default_depth ) ;
      numero [ 4 ] = XCreatePixmapFromBitmapData ( display , root_window ,
                                                   numero_4_bits ,
                                                   numero_4_width ,
                                                   numero_4_height ,
                                                   noir , rouge ,
                                                   default_depth ) ;
      numero [ 5 ] = XCreatePixmapFromBitmapData ( display , root_window ,
                                                   numero_5_bits ,
                                                   numero_5_width ,
                                                   numero_5_height ,
                                                   noir , rouge ,
                                                   default_depth ) ;
      numero [ 6 ] = XCreatePixmapFromBitmapData ( display , root_window ,
                                                   numero_6_bits ,
                                                   numero_6_width ,
                                                   numero_6_height ,
                                                   noir , rouge ,
                                                   default_depth ) ;
      numero [ 7 ] = XCreatePixmapFromBitmapData ( display , root_window ,
                                                   numero_7_bits ,
                                                   numero_7_width ,
                                                   numero_7_height ,
                                                   noir , rouge ,
                                                   default_depth ) ;
      numero [ 8 ] = XCreatePixmapFromBitmapData ( display , root_window ,
                                                   numero_8_bits ,
                                                   numero_8_width ,
                                                   numero_8_height ,
                                                   noir , rouge ,
                                                   default_depth ) ;
      numero [ 9 ] = XCreatePixmapFromBitmapData ( display , root_window ,
                                                   numero_9_bits ,
                                                   numero_9_width ,
                                                   numero_9_height ,
                                                   noir , rouge ,
                                                   default_depth ) ;

      pixmap [ 0 ] . bits    = icone_blanc_bits ;
      pixmap [ 0 ] . couleur = blanc ;
      pixmap [ 1 ] . bits    = icone_gris_bits ;
      pixmap [ 1 ] . couleur = gris ;
      pixmap [ 2 ] . bits    = icone_bits ;
      pixmap [ 2 ] . couleur = gris_clair ;
      pixmap [ 3 ] . bits    = bof_bits ;
      pixmap [ 3 ] . couleur = jaune ;
      bof = copie ( pixmap , bof_width , bof_height , 4 ) ;

      pixmap [ 3 ] . bits = heureux_bits ;
      heureux = copie ( pixmap , heureux_width , heureux_height , 4 ) ;

      pixmap [ 3 ] . bits = triste_bits ;
      triste = copie ( pixmap , triste_width , triste_height , 4 ) ;

      pixmap [ 3 ] . bits = joue_bits ;
      joue = copie ( pixmap , joue_width , joue_height , 4 ) ;

      pixmap [ 0 ] . bits    = select_gris_bits ;
      pixmap [ 0 ] . couleur = gris ;
      pixmap [ 1 ] . bits    = select_blanc_bits ;
      pixmap [ 1 ] . couleur = blanc ;
      pixmap [ 2 ] . bits    = icone_bits ;
      pixmap [ 2 ] . couleur = gris_clair ;
      pixmap [ 3 ] . bits    = bof_bits ;
      pixmap [ 3 ] . couleur = jaune ;
      icone_select = copie ( pixmap , bof_width , bof_height , 4 ) ;

      pixmap [ 0 ] . bits    = relief_blanc_bits ;
      pixmap [ 0 ] . couleur = blanc ;
      pixmap [ 1 ] . bits    = relief_gris_bits ;
      pixmap [ 1 ] . couleur = gris ;
      pixmap [ 2 ] . bits    = case_bits ;
      pixmap [ 2 ] . couleur = gris_clair ;
      case_relief = copie ( pixmap , case_width , case_height , 3 ) ;

      pixmap [ 2 ] . bits    = pied_bits ;
      pixmap [ 3 ] . bits    = drapeau_bits ;
      pixmap [ 3 ] . couleur = rouge ;
      marquee = copie ( pixmap , drapeau_width , drapeau_height , 4 ) ;

      pixmap [ 2 ] . bits = interro_bits ;
      interro = copie ( pixmap , interro_width , interro_height , 3 ) ;

      num_case [ 0 ] = XCreatePixmapFromBitmapData ( display , root_window ,
                                                     num_case_0_bits ,
                                                     num_case_0_width ,
                                                     num_case_0_height ,
                                                     fore [ 0 ] , gris_clair ,
                                                     default_depth ) ;
      num_case [ 1 ] = XCreatePixmapFromBitmapData ( display , root_window ,
                                                     num_case_1_bits ,
                                                     num_case_1_width ,
                                                     num_case_1_height ,
                                                     fore [ 1 ] , gris_clair ,
                                                     default_depth ) ;
      num_case [ 2 ] = XCreatePixmapFromBitmapData ( display , root_window ,
                                                     num_case_2_bits ,
                                                     num_case_2_width ,
                                                     num_case_2_height ,
                                                     fore [ 2 ] , gris_clair ,
                                                     default_depth ) ;
      num_case [ 3 ] = XCreatePixmapFromBitmapData ( display , root_window ,
                                                     num_case_3_bits ,
                                                     num_case_3_width ,
                                                     num_case_3_height ,
                                                     fore [ 3 ] , gris_clair ,
                                                     default_depth ) ;
      num_case [ 4 ] = XCreatePixmapFromBitmapData ( display , root_window ,
                                                     num_case_4_bits ,
                                                     num_case_4_width ,
                                                     num_case_4_height ,
                                                     fore [ 4 ] , gris_clair ,
                                                     default_depth ) ;
      num_case [ 5 ] = XCreatePixmapFromBitmapData ( display , root_window ,
                                                     num_case_5_bits ,
                                                     num_case_5_width ,
                                                     num_case_5_height ,
                                                     fore [ 5 ] , gris_clair ,
                                                     default_depth ) ;
      num_case [ 6 ] = XCreatePixmapFromBitmapData ( display , root_window ,
                                                     num_case_6_bits ,
                                                     num_case_6_width ,
                                                     num_case_6_height ,
                                                     fore [ 6 ] , gris_clair ,
                                                     default_depth ) ;
      num_case [ 7 ] = XCreatePixmapFromBitmapData ( display , root_window ,
                                                     num_case_7_bits ,
                                                     num_case_7_width ,
                                                     num_case_7_height ,
                                                     fore [ 7 ] , gris_clair ,
                                                     default_depth ) ;
      num_case [ 8 ] = XCreatePixmapFromBitmapData ( display , root_window ,
                                                     num_case_8_bits ,
                                                     num_case_8_width ,
                                                     num_case_8_height ,
                                                     fore [ 8 ] , gris_clair ,
                                                     default_depth ) ;

      pixmap [ 0 ] . bits    = mine_bits ;
      pixmap [ 0 ] . couleur = gris_clair ;
      pixmap [ 1 ] . bits    = reflet_bits ;
      pixmap [ 1 ] . couleur = blanc ;
      mine = copie ( pixmap , mine_width , mine_height , 2 ) ;

      pixmap [ 0 ] . bits    = mine_bits ;
      pixmap [ 0 ] . couleur = rouge ;
      pixmap [ 1 ] . bits    = reflet_bits ;
      pixmap [ 1 ] . couleur = blanc ;
      mine_perdu = copie ( pixmap , mine_width , mine_height , 2 ) ;

      pixmap [ 0 ] . bits    = manquee_bits ;
      pixmap [ 0 ] . couleur = gris_clair ;
      pixmap [ 1 ] . bits    = croix_bits ;
      pixmap [ 1 ] . couleur = rouge ;
      pixmap [ 2 ] . bits    = reflet_manquee_bits ;
      pixmap [ 2 ] . couleur = blanc ;
      manquee = copie ( pixmap , manquee_width , manquee_height , 3 ) ;
   }
   else
   {
      noir = gris = BlackPixel ( display , screen ) ;
      blanc       = WhitePixel ( display , screen ) ;

      fond = XCreatePixmapFromBitmapData ( display , root_window ,
                                                     nb_fond_bits ,
                                                     nb_fond_width ,
                                                     nb_fond_height ,
                                                     blanc , noir ,
                                                     1 ) ;
      XSetWindowBackgroundPixmap ( display , window , fond ) ;

      numero [ 0 ]   = XCreateBitmapFromData ( display , root_window ,
                                               numero_0_bits ,
                                               numero_0_width ,
                                               numero_0_height ) ;
      numero [ 1 ]   = XCreateBitmapFromData ( display , root_window ,
                                               numero_1_bits ,
                                               numero_1_width ,
                                               numero_1_height ) ;
      numero [ 2 ]   = XCreateBitmapFromData ( display , root_window ,
                                               numero_2_bits ,
                                               numero_2_width ,
                                               numero_2_height ) ;
      numero [ 3 ]   = XCreateBitmapFromData ( display , root_window ,
                                               numero_3_bits ,
                                               numero_3_width ,
                                               numero_3_height ) ;
      numero [ 4 ]   = XCreateBitmapFromData ( display , root_window ,
                                               numero_4_bits ,
                                               numero_4_width ,
                                               numero_4_height ) ;
      numero [ 5 ]   = XCreateBitmapFromData ( display , root_window ,
                                               numero_5_bits ,
                                               numero_5_width ,
                                               numero_5_height ) ;
      numero [ 6 ]   = XCreateBitmapFromData ( display , root_window ,
                                               numero_6_bits ,
                                               numero_6_width ,
                                               numero_6_height ) ;
      numero [ 7 ]   = XCreateBitmapFromData ( display , root_window ,
                                               numero_7_bits ,
                                               numero_7_width ,
                                               numero_7_height ) ;
      numero [ 8 ]   = XCreateBitmapFromData ( display , root_window ,
                                               numero_8_bits ,
                                               numero_8_width ,
                                               numero_8_height ) ;
      numero [ 9 ]   = XCreateBitmapFromData ( display , root_window ,
                                               numero_9_bits ,
                                               numero_9_width ,
                                               numero_9_height ) ;
      bof            = XCreateBitmapFromData ( display , root_window ,
                                               nb_bof_bits ,
                                               nb_bof_width ,
                                               nb_bof_height ) ;
      heureux        = XCreateBitmapFromData ( display , root_window ,
                                               nb_heureux_bits ,
                                               nb_heureux_width ,
                                               nb_heureux_height ) ;
      triste         = XCreateBitmapFromData ( display , root_window ,
                                               nb_triste_bits ,
                                               nb_triste_width ,
                                               nb_triste_height ) ;
      joue           = XCreateBitmapFromData ( display , root_window ,
                                               nb_joue_bits ,
                                               nb_joue_width ,
                                               nb_joue_height ) ;
      icone_select   = XCreateBitmapFromData ( display , root_window ,
                                               nb_icone_select_bits ,
                                               nb_icone_select_width ,
                                               nb_icone_select_height ) ;
      case_relief    = XCreateBitmapFromData ( display , root_window ,
                                               nb_case_bits ,
                                               nb_case_width ,
                                               nb_case_height ) ;
      marquee        = XCreateBitmapFromData ( display , root_window ,
                                               nb_drapeau_bits ,
                                               nb_drapeau_width ,
                                               nb_drapeau_height ) ;
      interro        = XCreateBitmapFromData ( display , root_window ,
                                               nb_interro_bits ,
                                               nb_interro_width ,
                                               nb_interro_height ) ;
      num_case [ 0 ] = XCreateBitmapFromData ( display , root_window ,
                                               num_case_0_bits ,
                                               num_case_0_width ,
                                               num_case_0_height ) ;
      num_case [ 1 ] = XCreateBitmapFromData ( display , root_window ,
                                               num_case_1_bits ,
                                               num_case_1_width ,
                                               num_case_1_height ) ;
      num_case [ 2 ] = XCreateBitmapFromData ( display , root_window ,
                                               num_case_2_bits ,
                                               num_case_2_width ,
                                               num_case_2_height ) ;
      num_case [ 3 ] = XCreateBitmapFromData ( display , root_window ,
                                               num_case_3_bits ,
                                               num_case_3_width ,
                                               num_case_3_height ) ;
      num_case [ 4 ] = XCreateBitmapFromData ( display , root_window ,
                                               num_case_4_bits ,
                                               num_case_4_width ,
                                               num_case_4_height ) ;
      num_case [ 5 ] = XCreateBitmapFromData ( display , root_window ,
                                               num_case_5_bits ,
                                               num_case_5_width ,
                                               num_case_5_height ) ;
      num_case [ 6 ] = XCreateBitmapFromData ( display , root_window ,
                                               num_case_6_bits ,
                                               num_case_6_width ,
                                               num_case_6_height ) ;
      num_case [ 7 ] = XCreateBitmapFromData ( display , root_window ,
                                               num_case_7_bits ,
                                               num_case_7_width ,
                                               num_case_7_height ) ;
      num_case [ 8 ] = XCreateBitmapFromData ( display , root_window ,
                                               num_case_8_bits ,
                                               num_case_8_width ,
                                               num_case_8_height ) ;
      mine           = XCreateBitmapFromData ( display , root_window ,
                                               nb_mine_bits ,
                                               nb_mine_width ,
                                               nb_mine_height ) ;
      mine_perdu     = XCreateBitmapFromData ( display , root_window ,
                                               nb_mine_perdu_bits ,
                                               nb_mine_perdu_width ,
                                               nb_mine_perdu_height ) ;
      manquee        = XCreateBitmapFromData ( display , root_window ,
                                               nb_manquee_bits ,
                                               nb_manquee_width ,
                                               nb_manquee_height ) ;
   }
}

affiche_jeu ( )
{
   int l , c ;

   bord ( ) ;
   nombre_de_mines ( ) ;
   icone_perdu_gagne ( ) ;
   chronometre ( ) ;
   grille ( ) ;
   for ( l = 1 ; l <= nb_lig ; l ++ )
   {
      for ( c = 1 ; c <= nb_col ; c ++ )
      {
         affiche_case ( l , c  ) ;
      }
   }
}

bord ( )
{
   int coord ;

   XSetForeground ( display , gc , blanc ) ;

   for ( coord = 0 ; coord < LARG_BORD ; coord ++ )
   {
      XDrawLine ( display , window , gc ,
                  0 , coord , LARGEUR_FEN - 2 - coord , coord ) ;
      XDrawLine ( display , window , gc ,
                  coord , 0 , coord , HAUTEUR_FEN - 2 - coord ) ;
      XDrawLine ( display , window , gc ,
                  BORD - LARG_BORD + coord + 1               ,
                  MARGE_HAUT  - BORD - 1 - coord + LARG_BORD ,
                  LARGEUR_FEN - BORD + LARG_BORD - 1         ,
                  MARGE_HAUT  - BORD - 1 - coord + LARG_BORD ) ;
      XDrawLine ( display , window , gc ,
                  LARGEUR_FEN - BORD + LARG_BORD - coord - 1 ,
                  BORD - LARG_BORD + coord + 1               ,
                  LARGEUR_FEN - BORD + LARG_BORD - coord - 1 ,
                  MARGE_HAUT - BORD - 1 + LARG_BORD ) ;
      XDrawLine ( display , window , gc ,
                  BORD - 1 - coord       , HAUTEUR_FEN - BORD + coord ,
                  LARGEUR_FEN - BORD - 1 , HAUTEUR_FEN - BORD + coord ) ;
      XDrawLine ( display , window , gc ,
                  LARGEUR_FEN - BORD + coord ,
                  MARGE_HAUT - coord         ,
                  LARGEUR_FEN - BORD + coord ,
                  HAUTEUR_FEN - BORD + LARG_BORD - 1 ) ;
   }

   XSetForeground ( display , gc , gris ) ;

   for ( coord = 0 ; coord < LARG_BORD ; coord ++ )
   {
      XDrawLine ( display , window , gc ,
                  coord           , HAUTEUR_FEN - 1 - coord ,
                  LARGEUR_FEN - 1 , HAUTEUR_FEN - 1 - coord ) ;
      XDrawLine ( display , window , gc ,
                  LARGEUR_FEN - 1 - coord , coord ,
                  LARGEUR_FEN - 1 - coord , HAUTEUR_FEN - 1 ) ;
      XDrawLine ( display , window , gc ,
                  BORD - 1                    , BORD - 1 - coord ,
                  LARGEUR_FEN - BORD  + coord , BORD - 1 - coord ) ;
      XDrawLine ( display , window , gc ,
                  BORD - 1 - coord , BORD - LARG_BORD ,
                  BORD - 1 - coord , MARGE_HAUT - BORD  + coord ) ;
      XDrawLine ( display , window , gc ,
                  BORD - 1                   , MARGE_HAUT - 1 - coord ,
                  LARGEUR_FEN - BORD + coord , MARGE_HAUT - 1 - coord  ) ;
      XDrawLine ( display , window , gc ,
                  BORD - 1 - coord , MARGE_HAUT - LARG_BORD ,
                  BORD - 1 - coord , HAUTEUR_FEN - BORD + coord ) ;
   }
}

nombre_de_mines ( )
{
   int n [ 3 ] ;

   n [ 0 ] = mines / 100 ;
   n [ 1 ] = ( mines % 100 ) / 10 ;
   n [ 2 ] = mines - ( n [ 0 ] * 100 ) - ( n [ 1 ] * 10 ) ;

   XCopyArea ( display , numero [ n [ 0 ] ] , window , gc ,
               0 , 0 , LARG_NUMERO , HAUT_NUMERO ,
               X_NB_MINES , Y_NB_MINES ) ;
   XCopyArea ( display , numero [ n [ 1 ] ] , window , gc ,
               0 , 0 , LARG_NUMERO , HAUT_NUMERO ,
               X_NB_MINES + LARG_NUMERO , Y_NB_MINES ) ;
   XCopyArea ( display , numero [ n [ 2 ] ] , window , gc ,
               0 , 0 , LARG_NUMERO , HAUT_NUMERO ,
               X_NB_MINES + 2 * LARG_NUMERO , Y_NB_MINES ) ;

   XSetForeground ( display , gc , blanc ) ;

   XDrawLine ( display , window , gc ,
               X_NB_MINES                   , Y_NB_MINES + HAUT_NUMERO ,
               X_NB_MINES + 3 * LARG_NUMERO , Y_NB_MINES + HAUT_NUMERO ) ;
   XDrawLine ( display , window , gc ,
               X_NB_MINES + 3 * LARG_NUMERO , Y_NB_MINES ,
               X_NB_MINES + 3 * LARG_NUMERO , Y_NB_MINES + HAUT_NUMERO) ;

   XSetForeground ( display , gc , gris ) ;

   XDrawLine ( display , window , gc ,
               X_NB_MINES - 1               , Y_NB_MINES - 1 ,
               X_NB_MINES + 3 * LARG_NUMERO , Y_NB_MINES - 1 ) ;
   XDrawLine ( display , window , gc ,
               X_NB_MINES - 1 , Y_NB_MINES - 1 ,
               X_NB_MINES - 1 , Y_NB_MINES + HAUT_NUMERO ) ;
}

icone_perdu_gagne ( )
{
   if ( perdu )
   {
      XCopyArea ( display , triste , window , gc ,
                  0 , 0 , LARG_ICONE , HAUT_ICONE , X_ICONE , Y_ICONE ) ;
   }
   else if ( gagne )
   {
      XCopyArea ( display , heureux , window , gc ,
                  0 , 0 , LARG_ICONE , HAUT_ICONE , X_ICONE , Y_ICONE ) ;
   }
   else
   {
      XCopyArea ( display , bof , window , gc ,
                  0 , 0 , LARG_ICONE , HAUT_ICONE , X_ICONE , Y_ICONE ) ;
   }
}

chronometre ( )
{
   int n [ 3 ] ;

   n [ 0 ] = ( int ) ( temps / 100 ) ;
   n [ 1 ] = ( int ) ( ( temps % 100 ) / 10 ) ;
   n [ 2 ] = ( int ) ( temps - ( n [ 0 ] * 100 ) - ( n [ 1 ] * 10 ) ) ;

   XCopyArea ( display , numero [ n [ 0 ] ] , window , gc ,
               0 , 0 , LARG_NUMERO , HAUT_NUMERO ,
               X_CHRONO , Y_CHRONO ) ;
   XCopyArea ( display , numero [ n [ 1 ] ] , window , gc ,
               0 , 0 , LARG_NUMERO , HAUT_NUMERO ,
               X_CHRONO + LARG_NUMERO , Y_CHRONO ) ;
   XCopyArea ( display , numero [ n [ 2 ] ] , window , gc ,
               0 , 0 , LARG_NUMERO , HAUT_NUMERO ,
               X_CHRONO + 2 * LARG_NUMERO , Y_CHRONO ) ;

   XSetForeground ( display , gc , blanc ) ;

   XDrawLine ( display , window , gc ,
               X_CHRONO                   , Y_CHRONO + HAUT_NUMERO ,
               X_CHRONO + 3 * LARG_NUMERO , Y_CHRONO + HAUT_NUMERO ) ;
   XDrawLine ( display , window , gc ,
               X_CHRONO + 3 * LARG_NUMERO , Y_CHRONO ,
               X_CHRONO + 3 * LARG_NUMERO , Y_CHRONO + HAUT_NUMERO) ;

   XSetForeground ( display , gc , gris ) ;

   XDrawLine ( display , window , gc ,
               X_CHRONO - 1               , Y_CHRONO - 1 ,
               X_CHRONO + 3 * LARG_NUMERO , Y_CHRONO - 1 ) ;
   XDrawLine ( display , window , gc ,
               X_CHRONO - 1 , Y_CHRONO - 1 ,
               X_CHRONO - 1 , Y_CHRONO + HAUT_NUMERO ) ;
}

grille ( )
{
   int coord ;

   XSetForeground ( display , gc , noir ) ;

   for ( coord = X_JEU ; coord < X_JEU + LARG_JEU ; coord += LARG_CASE + 1 )
   {
      XDrawLine ( display , window , gc ,
                  coord , Y_JEU , coord , Y_JEU + HAUT_JEU - 1 ) ;
   }

   for ( coord = Y_JEU ; coord < Y_JEU + HAUT_JEU ; coord += HAUT_CASE + 1 )
   {
      XDrawLine ( display , window , gc ,
                  X_JEU , coord , X_JEU + LARG_JEU - 1 , coord ) ;
   }
}

affiche_case ( lig , col )
int lig , col ;
{
   int x , y ;

   if ( lig < 1 || lig > nb_lig || col < 1 || col > nb_col )
   {
      return ;
   }

   x = X_JEU + 1 + ( col - 1 ) * ( LARG_CASE + 1 ) ;
   y = Y_JEU + 1 + ( lig - 1 ) * ( HAUT_CASE + 1 ) ;

   switch ( tableau [ lig ] [ col ] . etat )
   {
   case COUVERTE :
      if ( perdu && tableau [ lig ] [ col ] . mine )
      {
         XCopyArea ( display , mine , window , gc ,
                     0 , 0 , mine_width , mine_height , x , y ) ;
      }
      else
      {
         XCopyArea ( display , case_relief , window , gc ,
                     0 , 0 , relief_blanc_width , relief_blanc_height , x , y ) ;
      }
      break ;
   case DECOUVERTE :
      if ( ! tableau [ lig ] [ col ] . mine )
      {
         XCopyArea ( display , num_case [ tableau [ lig ] [ col ] . nombre ] ,
                     window , gc ,
                     0 , 0 , num_case_0_width , num_case_0_height , x , y ) ;
      }
      else
      {
         XCopyArea ( display , mine_perdu , window , gc ,
                     0 , 0 , mine_width , mine_height , x , y ) ;
      }
      break ;
   case MARQUEE :
      if ( perdu && ! tableau [ lig ] [ col ] . mine )
      {
         XCopyArea ( display , manquee , window , gc ,
                     0 , 0 , manquee_width , manquee_height , x , y ) ;
      }
      else
      {
         XCopyArea ( display , marquee , window , gc ,
                     0 , 0 , drapeau_width , drapeau_height , x , y ) ;
      }
      break ;
   case INTERRO :
      if ( perdu && tableau [ lig ] [ col ] . mine )
      {
         XCopyArea ( display , mine , window , gc ,
                     0 , 0 , mine_width , mine_height , x , y ) ;
      }
      else
      {
         XCopyArea ( display , interro , window , gc ,
                     0 , 0 , interro_width , interro_height , x , y ) ;
      }
      break ;
   }
}

icone_joue ( )
{
   XCopyArea ( display , joue , window , gc ,
               0 , 0 , LARG_ICONE , HAUT_ICONE , X_ICONE , Y_ICONE ) ;
}

icone_activee ( )
{
   XCopyArea ( display , icone_select , window , gc ,
               0 , 0 , LARG_ICONE , HAUT_ICONE , X_ICONE , Y_ICONE ) ;
}

case_vide ( lig , col )
int lig , col ;
{
   int x , y ;

   if ( lig < 1 || lig > nb_lig || col < 1 || col > nb_col )
   {
      return ;
   }

   x = X_JEU + 1 + ( col - 1 ) * ( LARG_CASE + 1 ) ;
   y = Y_JEU + 1 + ( lig - 1 ) * ( HAUT_CASE + 1 ) ;

   XCopyArea ( display , num_case [ 0 ] , window , gc ,
               0 , 0 , num_case_0_width , num_case_0_height , x , y ) ;
}

cases_vides ( lig , col )
int lig , col ;
{
   int l , c ;

   for ( l = lig - 1 ; l <= lig + 1 ; l ++ )
   {
      for ( c = col - 1 ; c <= col + 1 ; c ++ )
      {
         if ( tableau [ l ] [ c ] . etat == COUVERTE ||
              tableau [ l ] [ c ] . etat == INTERRO )
         {
            case_vide ( l , c ) ;
         }
      }
   }
}

affiche_bloc ( lig , col )
int lig , col ;
{
   int l , c ;

   for ( l = lig - 1 ; l <= lig + 1 ; l ++ )
   {
      for ( c = col - 1 ; c <= col + 1 ; c ++ )
      {
         affiche_case ( l , c ) ;
      }
   }
}

detruit_pixmaps ( )
{
   register int i ;

   for ( i = 0 ; i <= 9 ; i ++ )
   {
      XFreePixmap ( display , numero [ i ] ) ;
   }
   XFreePixmap ( display , bof          ) ;
   XFreePixmap ( display , heureux      ) ;
   XFreePixmap ( display , triste       ) ;
   XFreePixmap ( display , joue         ) ;
   XFreePixmap ( display , icone_select ) ;
   XFreePixmap ( display , case_relief  ) ;
   XFreePixmap ( display , marquee      ) ;
   XFreePixmap ( display , interro      ) ;
   for ( i = 0 ; i <= 8 ; i ++ )
   {
      XFreePixmap ( display , num_case [ i ] ) ;
   }
   XFreePixmap ( display , mine       ) ;
   XFreePixmap ( display , mine_perdu ) ;
   XFreePixmap ( display , manquee    ) ;
}
