/* XQF - Quake server browser and launcher
 * Copyright (C) 1998 Roman Pozlevich <roma@botik.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <gtk/gtk.h>

#include "xqf.h"
#include "pref.h"
#include "filter.h"
#include "psearch.h"


static inline int builtin_filter (struct server *s);
static inline int builtin_filter_inv (struct server *s);
static inline int find_player_filter (struct server *s);


struct filter filters[] = {
  { "All Servers",	NULL, -1, NULL,			NULL },
  { "Filtered",		NULL, -1, builtin_filter,	NULL },
  { "Filtered Out", 	NULL, -1, builtin_filter_inv,	NULL },
  { "Find Player", 	NULL, -1, find_player_filter, 	NULL },
  { NULL, 		NULL, -1, NULL,			NULL }
};


struct filter 	 *cur_filter = &filters[0];


static inline int builtin_filter (struct server *s) {
  if (s->ping == -1)	/* no information */
    return TRUE;

  if (s->retries < filter_retries && 
      s->ping < filter_ping && 
      (!filter_not_full || s->curplayers != s->maxplayers) && 
      (!filter_not_empty || s->curplayers != 0) &&
      (!filter_no_cheats || (s->flags & SERVER_CHEATS) == 0) &&
      (!filter_no_password || (s->flags & SERVER_PASSWORD) == 0))
    return TRUE;

  return FALSE;
}


static inline int builtin_filter_inv (struct server *s) {
  return TRUE - builtin_filter (s);
}


static inline int find_player_filter (struct server *s) {
  int i;

  for (i = 0; i < s->curplayers; i++) {
    if (test_player (s->players[i]))
      return TRUE;
  }
  return FALSE;
}


static void attach_list_to_filter (GSList *list, int len, struct filter *f) {
  GSList *ptr;
  int n;

  f->num = len;
  f->servers = NULL;

  if (len) {
    f->servers = g_malloc (sizeof (gpointer) * len);
    for (ptr = list, n = 0; ptr && n < len; ptr = ptr->next, n++) {
      f->servers[n] = (struct server *) ptr->data;
    }
  }
}


void build_filtered_list (struct filter *filter, struct master *master) {
  GSList *l = NULL;
  GSList *nbl = NULL;
  struct filter *nb = NULL;	/* "neighbour" filter */
  GSList *ptr;
  int num = 0;
  int nbnum = 0;

  if (!master || !master->servers)
    return;

  if (!filter->func) {
    attach_list_to_filter (master->servers, g_slist_length (master->servers), 
                                                                       filter);
  }
  else {
    if (filter == &filters[1] || filter == &filters[2]) {
      nb = &filters[&filters[2] - filter + 1];
    }

    for (ptr = master->servers; ptr; ptr = ptr->next) {
      if ((*filter->func) ((struct server *)ptr->data)) {
	l = g_slist_prepend (l, ptr->data);
	num++;
      }
      else {
	if (nb) {
	  nbl = g_slist_prepend (nbl, ptr->data);
	  nbnum++;
	}
      }
    }

    l = g_slist_reverse (l);
    attach_list_to_filter (l, num, filter);
    g_slist_free (l);
    if (nb) {
      nbl = g_slist_reverse (nbl);
      attach_list_to_filter (nbl, nbnum, nb);
      g_slist_free (nbl);
    }
  }
}


void free_filter_data (struct filter *f) {
  if (f->num > 0)
    g_free (f->servers);
  f->servers = NULL;
  f->num = -1;
}


void free_filters_data (void) {
  struct filter *f;

  for (f = filters; f->name; f++) {
    free_filter_data (f);
  }
}


void init_filters (void) {

  /*TODO*/

}

