/* XQF - Quake server browser and launcher
 * Copyright (C) 1998 Roman Pozlevich <roma@botik.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef __SKIN_H__
#define __SKIN_H__

#include <gtk/gtk.h>


#define	PCOL_WIDTH	24
#define PCOL_HEIGHT	16

struct cached_pixmap {
  int	top;
  int 	bottom;
  GdkPixmap *pixmap;
};

extern	GdkPixmap *create_pm (GtkWidget *window, int top, int bottom, 
                                                            GSList **pm_cache);
extern	void clear_pm_cache (GSList *pm_cache);

extern	GdkBitmap *create_dummy_mask (GtkWidget *window);

extern	GList *build_skin_list (char *dirname);

extern	void draw_skin (GtkWidget *preview, guchar *data);

extern	guchar *get_skin (char *filename);

extern	void allocate_quake_player_colors (GdkWindow *window);

extern	void set_bg_color (GtkWidget *widget, int color);

extern	GtkWidget *create_color_menu (void (*callback) (GtkWidget*, int));


#endif /* __SKIN_H__ */

