#ifdef _HAVE_STRING_H
#include <string.h>
#elif _HAVE_STRINGS_H
#include <strings.h>
#endif

#ifndef CONVERT_PATH
#  define CONVERT_PATH "/usr/local/bin"
#endif

#ifndef NETPBM_PATH
#  define NETPBM_PATH  "/usr/local/bin"
#endif

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <math.h>
#include <ctype.h>
#include <time.h>                                                            
#include <netinet/in.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/time.h>
#include <sys/types.h>

#ifdef _HAVE_STRING_H
#include <string.h>
#elif _HAVE_STRINGS_H
#include <strings.h>
#endif

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/Xos.h>
#include <X11/extensions/XShm.h>
#include <X11/extensions/shape.h>
#include <X11/cursorfont.h>
#include <gdk/gdkprivate.h>

#ifdef HAVE_LIBJPEG
#include <jpeglib.h>
#endif
#ifdef HAVE_LIBPNG
#include <png.h>
#endif
#ifdef HAVE_LIBTIFF
#include <tiffio.h>
#endif
#ifdef HAVE_LIBGIF
#include <gif_lib.h>
#endif

#define BYTE_ORD_24_RGB 0
#define BYTE_ORD_24_RBG 1
#define BYTE_ORD_24_BRG 2
#define BYTE_ORD_24_BGR 3
#define BYTE_ORD_24_GRB 4
#define BYTE_ORD_24_GBR 5


struct image_cache
{
   gchar              *file;
   GdkImlibImage      *im;
   gint               refnum;
   gchar              dirty;
   struct image_cache *prev;
   struct image_cache *next;
};

struct pixmap_cache
{
   GdkImlibImage       *im;
   gchar               *file;
   gchar               dirty;
   gint                width,height;
   GdkPixmap           *pmap;
   GdkBitmap           *shape_mask;
   XImage              *xim,*sxim;
   gint                refnum;
   struct pixmap_cache *prev;
   struct pixmap_cache *next;
};

typedef struct _xdata
{
   Display         *disp; 
   gint            screen; 
   Window          root; 
   Visual          *visual; 
   gint            depth;
   gint            render_depth;
   Colormap        root_cmap; 
   gchar           shm; 
   gchar           shmp; 
   gint            shm_event; 
   XImage          *last_xim;
   XImage          *last_sxim;
   XShmSegmentInfo last_shminfo;
   XShmSegmentInfo last_sshminfo;
   Window          base_window;
   GdkWindow       *gdk_win;
   GdkColormap     *gdk_cmap;
} Xdata;

typedef struct _imlibdata
{
   gint          num_colors; 
   GdkImlibColor *palette; 
   GdkImlibColor *palette_orig; 
   gint          *fast_rgb;
   gint          *fast_err;
   gint          *fast_erg;
   gint          *fast_erb;
   gint          render_type; 
   gint          max_shm;
   Xdata         x; 
   gint          byte_order;
   struct _cache 
     {
	gchar    on_image;
	gint     size_image;
	gint     num_image;
	gint     used_image;
	struct   image_cache *image;
	gchar    on_pixmap;
	gint     size_pixmap;
	gint     num_pixmap;
	gint     used_pixmap;
	struct   pixmap_cache *pixmap;
     } cache;
   gchar                 fastrend; 
   gchar                 hiq; 
   GdkImlibColorModifier mod,rmod,gmod,bmod;
   unsigned char         rmap[256],gmap[256],bmap[256];
   gchar                 fallback;
} ImlibData;

extern ImlibData *id;

void dirty_pixmaps(GdkImlibImage *im);
void dirty_images(GdkImlibImage *im);
void find_pixmap(GdkImlibImage *im, int width, int height, GdkPixmap **pmap, GdkBitmap **mask);
GdkImlibImage *find_image(char *file);
void free_pixmappmap(GdkPixmap *pmap);
void free_image(GdkImlibImage *im);
void flush_image(GdkImlibImage *im);
void add_image(GdkImlibImage *im, char *file);
void add_pixmap(GdkImlibImage *im, int width, int height, XImage *xim, XImage *sxim);
void clean_caches();
void nullify_image(GdkImlibImage *im);

void _SplitID(char *file, char *id);
void _GetExtension(char *file, char *ext);
#ifdef HAVE_LIBJPEG
unsigned char *_LoadJPEG(FILE *f, int *w, int *h);
#endif /* HAVE_LIBJPEG */
#ifdef HAVE_LIBPNG
unsigned char *_LoadPNG(FILE *f, int *w, int *h, int *t);
#endif /* HAVE_LIBPNG */
#ifdef HAVE_LIBTIFF
unsigned char *_LoadTIFF(char *f, int *w, int *h, int *t);
#endif /* HAVE_LIBTIFF */
#ifdef HAVE_LIBGIF
unsigned char *_LoadGIF(char *f, int *w, int *h, int *t);
#endif /* HAVE_LIBGIF */
unsigned char *_LoadXPM(char *f, int *w, int *h, int *t);
unsigned char *_LoadPPM(FILE *f, int *w, int *h);
int ispnm(char *file);
int isjpeg(char *file);
int ispng(char *file);
int istiff(char *file);
int iseim(char *file);
int isgif(char *file);
int isxpm(char *file);

GdkPixmap *gdk_imlib_pixmap_foreign_new(gint width, gint height, gint depth, Pixmap pmap);

void calc_map_tables(GdkImlibImage *im);

void _PaletteAlloc(int num, int *cols);

#define FAST_RGB(r,g,b) fast_rgb[(r<<10)+(g<<5)+(b)]
#define FAST_ERR(r,g,b) fast_err[(r<<10)+(g<<5)+(b)]
#define FAST_ERG(r,g,b) fast_erg[(r<<10)+(g<<5)+(b)]
#define FAST_ERB(r,g,b) fast_erb[(r<<10)+(g<<5)+(b)]
