/* Create icon pixmaps
 *
 * gsumi version 0.5
 *
 * Copyright 1997 Owen Taylor <owt1@cornell.edu>
*/

#include <X11/Xlib.h>
#include <X11/xpm.h>

#include "gdk/gdk.h"
#include "gdk/gdkprivate.h"

#include "gsumi.h"

static char *pen_icon[] = {
/* width height ncolors chars_per_pixel */
"40 40 51 2",
/* colors */
"af c #FBFBFB s g62",
"ag c #F7F7F7 s g61",
"ah c #F3F3F3 s g60",
"ai c #EFEFEF s g59",
"ak c #EBEBEB s g58",
"am c #E7E7E7 s g57",
"an c #E3E3E3 s g56",
"ao c #DFDFDF s g55",
"ap c #DBDBDB s g54",
"aq c #D7D7D7 s g53",
"ar c #D3D3D3 s g52",
"as c #CFCFCF s g51",
"at c #CBCBCB s g50",
"au c #C7C7C7 s g49",
"av c #C3C3C3 s g48",
"`q c #BEBEBE s g47",
"`r c #BABABA s g46",
"`s c #B6B6B6 s g45",
"`t c #B2B2B2 s g44",
"`u c #AEAEAE s g43",
"`v c #AAAAAA s g42",
"`w c #A6A6A6 s g41",
"`x c #A2A2A2 s g40",
"`y c #9E9E9E s g39",
"`z c #9A9A9A s g38",
"a` c #969696 s g37",
"aa c #929292 s g36",
"ab c #8E8E8E s g35",
"ac c #8A8A8A s g34",
"ad c #868686 s g33",
"ae c #828282 s g32",
"`` c #7D7D7D s g31",
"`a c #797979 s g30",
"`b c #757575 s g29",
"`c c #717171 s g28",
"`d c #6D6D6D s g27",
"`e c #696969 s g26",
"`f c #656565 s g25",
"`g c #616161 s g24",
"`h c #5D5D5D s g23",
"`i c #595959 s g22",
"`j c #555555 s g21",
"`k c #515151 s g20",
"`l c #4D4D4D s g19",
"`m c #494949 s g18",
"`n c #454545 s g17",
"`o c #414141 s g16",
"aj c #3C3C3C s g15",
"al c #383838 s g14",
"ba c #000000 s g0",
"`p c #7F0000",
/* pixels */
"`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`pae`tatanahafahaoat`s`wa`ad`h",
"`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`pab`rasaoaiafahanas`r`v`zac`f`p",
"`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`v`satapakafaiaoar`q`u`yac`c`p`p",
"`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`e`sauaqamafahanarav`t`yab```m`p`p",
"`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`tavaqamagagamarav`t`xaaae`k`p`p`p",
"`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`t`qaranahafamaqau`s`wa`ad`g`p`p`p`p",
"`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`u`qasaoaiafakapat`r`v`zac`d`m`p`p`p`p",
"`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`v`ratapakafaiaoas`q`u`yac`a`g`p`p`p`p`p",
"`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`sauaqamafahanarav`t`yab```d`l`p`p`p`p`p",
"`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`tavaqamagagamarav`s`xaaae`c`g`o`p`p`p`p`p",
"`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`paaavaranahafakaqau`s`wa`ad`b`f`k`p`p`p`p`p`p",
"`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`vataoaiafaiaoat`r`v`zac`a`e`i`p`p`p`p`p`p`p",
"`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`j`raqakafahamar`r`v`zac```e`i`o`p`p`p`p`p`p`p",
"`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`garamafagakap`q`u`yab```d`h`n`p`p`p`p`p`p`p`p",
"`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`m`ragagakaoav`u`yabae`c`g`l`p`p`p`p`p`p`p`p`p",
"`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`j`vaoakaoav`u`yabae`b`f`k`p`p`p`p`p`p`p`p`p`p",
"`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`o`v`t`qarav`v`zac`a`c`f`i`p`p`p`p`p`p`p`p`p`p`p",
"`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`w`t`rauau`s`zad`a`e`g`jaj`p`p`p`p`p`p`p`p`p`p`p",
"`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`y`u`ravat`q`s`w`d`g`j`m`p`p`p`p`p`p`p`p`p`p`p`p`p",
"`p`p`p`p`p`p`p`p`p`p`p`p`pa`aa`u`savatav`r`uaa`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p",
"`p`p`p`p`p`p`p`p`p`p`p`hae`y`v`s`qatav`r`t`w`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p",
"`p`p`p`p`p`p`p`p`p`ha``z`z`v`t`qauau`q`t`w`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p",
"`p`p`p`p`p`p`p`p``ada``x`w`t`rauau`q`s`w`l`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p",
"`p`p`p`p`p`p`p`eadab`z`x`u`r`tav`q`s`vad`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p",
"`p`p`p`p`p`p`eaeab`z`x`u`s`sae`u`r`u`xad`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p",
"`p`p`p`p`p`eaeaba``x`v`t`raa`x`r`t`wa``n`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p",
"`p`p`p`p`p``aca``y`w`u`sad`b`s`t`v`yad`k`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p",
"`p`p`p`p`dadaa`y`w`v`wae`m`x`t`v`xa`ae`o`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p",
"`p`p`p`p`dab`z`x`w`ya``m`u`t`v`xa`ab`a`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p",
"`p`p`p`p`ba``x`v`zad`g`f`y`v`x`zaaad`d`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p",
"`p`p`p`p`c`z`v`u`z`halac`v`w`zaaad```p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p",
"`p`p`p`p`f`y`t`s`z`jab`w`w`ya`acae`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p",
"`p`p`p`p`a`w`saa`i`z`v`w`ya`abae`j`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p",
"`p`p`p`p`c`t`v`m`t`t`v`x`zabae`g`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p",
"`p`p`p`p`x`s`nab`s`u`x`zac```e`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p",
"`p`p`p`p`r```x`r`u`xaaad`e`g`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p",
"`p`p`pacab`f`r`u`c`b`g`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p",
"`p`p`p`j```v`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p",
"`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p",
"`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p"
};

static char *eraser_icon[] = {
/* width height ncolors chars_per_pixel */
"40 40 51 2",
/* colors */
"af c #FBFBFB s g62",
"ag c #F7F7F7 s g61",
"ah c #F3F3F3 s g60",
"ai c #EFEFEF s g59",
"aj c #EBEBEB s g58",
"ak c #E7E7E7 s g57",
"al c #E3E3E3 s g56",
"am c #DFDFDF s g55",
"an c #DBDBDB s g54",
"ao c #D7D7D7 s g53",
"ap c #D3D3D3 s g52",
"aq c #CFCFCF s g51",
"ar c #CBCBCB s g50",
"as c #C7C7C7 s g49",
"at c #C3C3C3 s g48",
"`q c #BEBEBE s g47",
"`r c #BABABA s g46",
"`s c #B6B6B6 s g45",
"`t c #B2B2B2 s g44",
"`u c #AEAEAE s g43",
"`v c #AAAAAA s g42",
"`w c #A6A6A6 s g41",
"`x c #A2A2A2 s g40",
"`y c #9E9E9E s g39",
"`z c #9A9A9A s g38",
"a` c #969696 s g37",
"aa c #929292 s g36",
"ab c #8E8E8E s g35",
"ac c #8A8A8A s g34",
"ad c #868686 s g33",
"ae c #828282 s g32",
"`a c #7D7D7D s g31",
"`b c #797979 s g30",
"`c c #757575 s g29",
"`d c #717171 s g28",
"`e c #6D6D6D s g27",
"`f c #696969 s g26",
"`g c #656565 s g25",
"`h c #616161 s g24",
"`i c #5D5D5D s g23",
"`j c #595959 s g22",
"`k c #555555 s g21",
"`l c #515151 s g20",
"`m c #4D4D4D s g19",
"`n c #494949 s g18",
"b` c #454545 s g17",
"`o c #414141 s g16",
"ba c #3C3C3C s g15",
"bb c #383838 s g14",
"`` c #000000 s g0",
"`p c #7F0000",
/* pixels */
"`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`pac`qasajajajajajaj`q`v`v`v`v",
"`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`c`qatalajajajajajas`v`v`v`vad",
"`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`i`q`qanajajajajajap`v`v`v`vaa`k",
"`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`r`qaoajajajajajan`v`v`v`v`y`i`k",
"`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`x`qaqajajajajajak`t`v`v`v`v`f`k`n",
"`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`pac`qasajajajajajaj`q`v`v`v`v`b`k`m`p",
"`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`c`qatalajajajajajas`v`v`v`vad`k`k`p`p",
"`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`i`q`qanajajajajajap`v`v`v`vaa`k`k`p`p`p",
"`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`r`qaoajajajajajan`v`v`v`v`y`i`k`o`p`p`p",
"`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`y`qaqakajajajajak`t`v`v`v`v`f`k`n`p`p`p`p",
"`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`a`satanakajajajaj`q`v`v`v`v`b`k`m`p`p`p`p`p",
"`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`e`t`qaqalahagajajas`v`v`v`vad`k`k`p`p`p`p`p`p",
"`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`j`tasaqamaiagajanaq`v`v`v`vaa`k`k`p`p`p`p`p`p`p",
"`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`y`u`qapalafahamaq`q`u`v`v`y`i`k`o`p`p`p`p`p`p`p",
"`p`p`p`p`p`p`p`p`p`p`p`p`p`p`paa`sasaqanaoanakaoat`t`x`y`w`f`k`n`p`p`p`p`p`p`p`p",
"`p`p`p`p`p`p`p`p`p`p`p`p`p`p`a`tatapalahagar`qar`q`waaab`d`k`m`p`p`p`p`p`p`p`p`p",
"`p`p`p`p`p`p`p`p`p`p`p`p`p`f`u`qaqalahafajan`r`w`t`xad`c`h`k`p`p`p`p`p`p`p`p`p`p",
"`p`p`p`p`p`p`p`p`p`p`p`p`j`u`qaqamaiagaianar`r`wa`a``a`f`j`p`p`p`p`p`p`p`p`p`p`p",
"`p`p`p`p`p`p`p`p`p`p`p`p`uataranajafaiamaq`q`u`yabac`a`i`o`p`p`p`p`p`p`p`p`p`p`p",
"`p`p`p`p`p`p`p`p`p`p`pac`u`qapalafahalapat`t`xaa`a`c`c`l`p`p`p`p`p`p`p`p`p`p`p`p",
"`p`p`p`p`p`p`p`p`p`p`a`u`q`qaqaqakajaoas`s`waaae`d`f`g`p`p`p`p`p`p`p`p`p`p`p`p`p",
"`p`p`p`p`p`p`p`p`p`e`u`qaqalajaiasarap`q`wa`ad`c`g`j`p`p`p`p`p`p`p`p`p`p`p`p`p`p",
"`p`p`p`p`p`p`p`p`j`s`qaranaiagajan`s`u`r`xac`b`f`j`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p",
"`p`p`p`p`p`p`p`p`t`qasapanaiaiamaq`q`w`z`zae`e`i`o`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p",
"`p`p`p`p`p`p`p`y`qasaqaoalamanapat`t`yabab`a`i`n`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p",
"`p`p`p`p`p`pad`qasaqaoamamaoaqas`s`waaae`a`b`k`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p",
"`p`p`p`p`p`d`ratarapamalanaqas`q`s`yad`c`e`d`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p",
"`p`p`p`p`j`ratarapanalanaparat`s`u`y`a`f`h`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p",
"`p`p`p`p`t`rataranalamaparat`r`t`v`y`a`i`o`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p",
"`p`p`p`e`t`t`s`raqamaoaqat`r`t`v`x`zae`l`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p",
"`p`p`p`h`t`t`t`t`tataqas`q`s`v`x`zaa`b`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p",
"`p`p`p`pac`t`t`t`t`t`r`q`s`u`w`zaaac`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p",
"`p`p`p`p`e`v`t`t`t`t`t`t`u`w`ya`ac`m`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p",
"`p`p`p`p`p`b`t`t`t`t`t`t`u`xa`ab`i`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p",
"`p`p`p`p`p`p`g`t`t`t`t`t`t`yab`e`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p",
"`p`p`p`p`p`p`p`p`w`t`t`t`t`vae`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p",
"`p`p`p`p`p`p`p`p`padab`t`v`u`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p",
"`p`p`p`p`p`p`p`p`p`p`p`p`k`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p",
"`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p",
"`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p`p"
};

/* Returns a GdkPixmap for the specified tool. 
      window: window for visual, colormap (NULL => root window)
      tool: specifies which icon to return
      gray_pixels: for conversion to reduced palette (length must be 256)
*/

GdkPixmap*
create_icon_pixmap (GdkWindow *window,
		    ToolType tool, int32 *gray_pixels)
{
  GdkPixmap *pixmap;
  GdkWindowPrivate *private;
  GdkWindowPrivate *window_private;
  GdkColormap *colormap;
  GdkVisual *visual;
  Pixmap shapemask;
  XpmAttributes attributes;
  int depth;
  int status;
  XpmColorSymbol color_syms[64];
  char sym_names[64][4];
  char **pixmap_data;
  int i;
 
  if (!window)
    window = (GdkWindow*) &gdk_root_parent;

  private = g_new (GdkWindowPrivate, 1);
  pixmap = (GdkPixmap*) private;

  window_private = (GdkWindowPrivate*) window;

  private->xdisplay = window_private->xdisplay;
  private->window_type = GDK_WINDOW_PIXMAP;

  colormap = gdk_window_get_colormap (window);
  visual = gdk_window_get_visual (window);
  gdk_window_get_geometry (window, NULL, NULL, NULL, NULL, &depth);

  if (tool == PEN_TOOL)
    pixmap_data = pen_icon;
  else if (tool == ERASER_TOOL)
    pixmap_data = eraser_icon;
  else
    {
      g_error("Unknown tool type\n");
      return NULL;		/* not reached */
    }
  
  for (i=0;i<64;i++)
    {
      color_syms[i].name = sym_names[i];
      sprintf(sym_names[i],"g%d",i);
      color_syms[i].value = NULL;
      color_syms[i].pixel = gray_pixels[(255*i)/63];
    }

  attributes.valuemask = (XpmSize |
			  XpmColormap |
			  XpmDepth |
			  XpmVisual |
			  XpmCloseness |
			  XpmColorSymbols);

  attributes.colormap = ((GdkColormapPrivate*) colormap)->xcolormap;
  attributes.visual = ((GdkVisualPrivate*) visual)->xvisual;
  attributes.depth = depth;
  attributes.closeness = 65535;
  attributes.colorsymbols = color_syms;
  attributes.numsymbols = 64;

  status = XpmCreatePixmapFromData(private->xdisplay,
				   window_private->xwindow,
				   pixmap_data,
				   &private->xwindow,
				   &shapemask,
				   &attributes);

  if (status != XpmSuccess)
    {
      g_free (private);
      return NULL;
    }

  private->x = 0;
  private->y = 0;
  private->width = attributes.width;
  private->height = attributes.height;

  gdk_xid_table_insert (&private->xwindow, pixmap);

  return pixmap;
}
