#include "Imlib.h"
#include "Imlib_private.h"

int Imlib_get_render_type(ImlibData *id)
{
   if (id) return id->render_type;
   else
     {    
	fprintf(stderr,"IMLIB ERROR: Imlib not initialised\n");
	return -1;
     }
}

void Imlib_set_render_type(ImlibData *id, int rend_type)
{
   if (id)
     {
	if (id->x.depth>8) id->render_type=rend_type;
	else
	  {
	     if ((rend_type==RT_PLAIN_TRUECOL)||
		 (rend_type==RT_DITHER_TRUECOL))
	       id->render_type=RT_DITHER_PALETTE_FAST;
	     else
	       id->render_type=rend_type;
	  }
	return;
     }
   else
     {
	fprintf(stderr,"IMLIB ERROR: Imlib not initialised\n");
	return;
     }
}

ImlibData *Imlib_init(Display *disp)
{
   ImlibData *id;
   XWindowAttributes xwa;
   XVisualInfo xvi,*xvir;
   char *homedir;
   char file[4096];
   char s[4096],s1[1024],s2[1024];
   FILE *f;
   int override=0;
   int dither=0;
   int remap=1;
   int num;
   int i,max,maxn;
   int clas;
   char palfile[1024];
   int loadpal;
   int vis;
   int newcm;
   
   if (!disp) 
     {
	fprintf(stderr,"IMLIB ERROR: no display\n");
	return NULL;
     }
   vis=-1;
   loadpal=0;
   id=(ImlibData *)malloc(sizeof(ImlibData));
   if (!id)
     {
	fprintf(stderr,"IMLIB ERROR: Cannot alloc RAM for Initial data struct\n");
	return NULL;
     }
   id->palette=NULL;
   id->palette_orig=NULL;
   id->fast_rgb=NULL;
   id->fast_err=NULL;
   id->fast_erg=NULL;
   id->fast_erb=NULL;
   id->x.disp=disp;
   id->x.screen=DefaultScreen(disp); /* the screen number */
   id->x.root=DefaultRootWindow(disp); /* the root window id */
   id->x.visual=DefaultVisual(disp,id->x.screen); /* the visual type */
   id->x.depth=DefaultDepth(disp,id->x.screen); /* the depth of the screen in bpp */
   if (XShmQueryExtension(id->x.disp)) 
     {
	id->x.shm=1;
	id->x.shm_event=XShmGetEventBase(id->x.disp)+ShmCompletion;
	id->x.last_xim=NULL;
	id->x.last_sxim=NULL;
	id->max_shm=0x7fffffff;
	if (XShmPixmapFormat(id->x.disp)==ZPixmap) id->x.shmp=1;
     }
   else 
     {
	id->x.shm=0;
	id->x.shmp=0;
     }
   id->cache.on_image=0;
   id->cache.size_image=0;
   id->cache.num_image=0;
   id->cache.used_image=0;
   id->cache.image=NULL;
   id->cache.on_pixmap=0;
   id->cache.size_pixmap=0;
   id->cache.num_pixmap=0;
   id->cache.used_pixmap=0;
   id->cache.pixmap=NULL;
   id->byte_order=0;
   id->fastrend=0;
   id->hiq=0;
   id->fallback=1;
   id->mod.gamma=256;
   id->mod.brightness=256;
   id->mod.contrast=256;
   id->rmod.gamma=256;
   id->rmod.brightness=256;
   id->rmod.contrast=256;
   id->gmod.gamma=256;
   id->gmod.brightness=256;
   id->gmod.contrast=256;
   id->bmod.gamma=256;
   id->bmod.brightness=256;
   id->bmod.contrast=256;
   
   if (XGetWindowAttributes(disp,id->x.root,&xwa))
     {
	if (xwa.colormap) id->x.root_cmap=xwa.colormap;
	else id->x.root_cmap=0;
     }
   else id->x.root_cmap=0;
   id->num_colors=0;
   homedir=getenv("HOME");
   sprintf(file,"%s/.imrc",homedir);
   f=fopen(file,"r");
   if (!f) f=fopen(SYSTEM_IMRC,"r");
   if (f)
     {
	while (fgets(s,4096,f))
	  {
	     if (s[0]=='#') continue;
	     sscanf(s,"%s %s\n",s1,s2);
	     if (!strcasecmp("PaletteFile",s1))
	       {
		  strcpy(palfile,s2);
	       }
	     if (!strcasecmp("PaletteOverride",s1))
	       {
		  if (!strcasecmp("yes",s2)) override=1;
		  else override=0;
	       }
	     if (!strcasecmp("Dither",s1))
	       {
		  if (!strcasecmp("yes",s2)) dither=1;
		  else dither=0;
	       }
	     if (!strcasecmp("Remap",s1))
	       {
		  if (!strcasecmp("fast",s2)) 
		    remap=1;
		  else 
		    remap=0;
	       }
	     if (!strcasecmp("Mit-Shm",s1))
	       {
		  if (!strcasecmp("off",s2)) 
		    {
		       id->x.shm=0;
		       id->x.shmp=0;
		    }
	       }
	     if (!strcasecmp("SharedPixmaps",s1))
	       {
		  if (!strcasecmp("off",s2)) id->x.shmp=0;
	       }
	     if (!strcasecmp("FastRender",s1))
	       {
		  if (!strcasecmp("on",s2)) id->fastrend=1;
	       }
	     if (!strcasecmp("HighQuality",s1))
	       {
		  if (!strcasecmp("on",s2)) id->hiq=1;
	       }
	     if (!strcasecmp("Shm_Max_Size",s1))
	       {
		  num=atoi(s2);
		  id->max_shm=num;
	       }
	     if (!strcasecmp("Image_Cache_Size",s1))
	       {
		  num=atoi(s2);
		  id->cache.size_image=num;
	       }
	     if (!strcasecmp("Pixmap_Cache_Size",s1))
	       {
		  num=atoi(s2);
		  id->cache.size_pixmap=num;
	       }
	     if (!strcasecmp("Image_Cache",s1))
	       {
		  if (!strcasecmp("on",s2)) id->cache.on_image=1;
	       }
	     if (!strcasecmp("Pixmap_Cache",s1))
	       {
		  if (!strcasecmp("on",s2)) id->cache.on_pixmap=1;
	       }
	     if (!strcasecmp("ForceVisualID",s1))
	       {
		  sscanf(s,"%s %x",s1,&num);
		  vis=num;
	       }
	     if (!strcasecmp("Fallback",s1))
	       {
		  if (!strcasecmp("off",s2)) id->fallback=0;
		  else id->fallback=1;
	       }
	     if (!strcasecmp("Gamma",s1))
	       {
		  id->mod.gamma=(int)(256.0*atof(s2));
	       }
	     if (!strcasecmp("Brightness",s1))
	       {
		  id->mod.brightness=(int)(256.0*atof(s2));
	       }
	     if (!strcasecmp("Contrast",s1))
	       {
		  id->mod.contrast=(int)(256.0*atof(s2));
	       }
	     if (!strcasecmp("Red_Gamma",s1))
	       {
		  id->rmod.gamma=(int)(256.0*atof(s2));
	       }
	     if (!strcasecmp("Red_Brightness",s1))
	       {
		  id->rmod.brightness=(int)(256.0*atof(s2));
	       }
	     if (!strcasecmp("Red_Contrast",s1))
	       {
		  id->rmod.contrast=(int)(256.0*atof(s2));
	       }
	     if (!strcasecmp("Green_Gamma",s1))
	       {
		  id->gmod.gamma=(int)(256.0*atof(s2));
	       }
	     if (!strcasecmp("Green_Brightness",s1))
	       {
		  id->gmod.brightness=(int)(256.0*atof(s2));
	       }
	     if (!strcasecmp("Green_Contrast",s1))
	       {
		  id->gmod.contrast=(int)(256.0*atof(s2));
	       }
	     if (!strcasecmp("Blue_Gamma",s1))
	       {
		  id->bmod.gamma=(int)(256.0*atof(s2));
	       }
	     if (!strcasecmp("Blue_Brightness",s1))
	       {
		  id->bmod.brightness=(int)(256.0*atof(s2));
	       }
	     if (!strcasecmp("Blue_Contrast",s1))
	       {
		  id->bmod.contrast=(int)(256.0*atof(s2));
	       }
	  }
	fclose(f);
     }
   /* list all visuals for the default screen */
   xvi.screen=id->x.screen;
   xvir=XGetVisualInfo(disp,VisualScreenMask,&xvi,&num);
   if (vis>=0)
     {
	/* use the forced visual id */
	maxn=0;
	for(i=0;i<num;i++)
	  {
	     if (xvir[i].visualid==(VisualID)vis) maxn=i;
	  }
	if (maxn>=0) 
	  {
	     unsigned long rmsk,gmsk,bmsk;
	     
	     id->x.depth=xvir[maxn].depth;
	     id->x.visual=xvir[maxn].visual;
	     rmsk=xvir[maxn].red_mask;
	     gmsk=xvir[maxn].green_mask;
	     bmsk=xvir[maxn].blue_mask;
	     
	     if ((rmsk>gmsk)&&(gmsk>bmsk))      id->byte_order=BYTE_ORD_24_RGB;
	     else if ((rmsk>bmsk)&&(bmsk>gmsk)) id->byte_order=BYTE_ORD_24_RBG;
	     else if ((bmsk>rmsk)&&(rmsk>gmsk)) id->byte_order=BYTE_ORD_24_BRG;
	     else if ((bmsk>gmsk)&&(gmsk>rmsk)) id->byte_order=BYTE_ORD_24_BGR;
	     else if ((gmsk>rmsk)&&(rmsk>bmsk)) id->byte_order=BYTE_ORD_24_GRB;
	     else if ((gmsk>bmsk)&&(bmsk>rmsk)) id->byte_order=BYTE_ORD_24_GBR;
	     else id->byte_order=0;
	  }
	else
	  fprintf(stderr,"IMLIB ERROR: Visual Id no 0x%x specified in the imrc file is invalid on this display.\nUsing Default Visual.\n",vis);
     }
   else
     {
	if (xvir) 
	  {
	     /* find the highest bit-depth supported by visuals */
	     max=0;
	     for(i=0;i<num;i++)
	       {
		  if (xvir[i].depth>max) max=xvir[i].depth;
	       }
	     if (max>8)
	       {
		  id->x.depth=max;
		  clas=-1;maxn=-1;
		  for(i=0;i<num;i++)
		    {
		       if (xvir[i].depth==id->x.depth)
			 {
			    if ((xvir[i].class>clas)&&(xvir[i].class!=DirectColor))
			      {
				 maxn=i;clas=xvir[i].class;
			      }
			 }
		    }
		  if (maxn>=0) 
		    {
		       unsigned long rmsk,gmsk,bmsk;
		       
		       id->x.visual=xvir[maxn].visual;
		       rmsk=xvir[maxn].red_mask;
		       gmsk=xvir[maxn].green_mask;
		       bmsk=xvir[maxn].blue_mask;
		       
		       if ((rmsk>gmsk)&&(gmsk>bmsk))      id->byte_order=BYTE_ORD_24_RGB;
		       else if ((rmsk>bmsk)&&(bmsk>gmsk)) id->byte_order=BYTE_ORD_24_RBG;
		       else if ((bmsk>rmsk)&&(rmsk>gmsk)) id->byte_order=BYTE_ORD_24_BRG;
		       else if ((bmsk>gmsk)&&(gmsk>rmsk)) id->byte_order=BYTE_ORD_24_BGR;
		       else if ((gmsk>rmsk)&&(rmsk>bmsk)) id->byte_order=BYTE_ORD_24_GRB;
		       else if ((gmsk>bmsk)&&(bmsk>rmsk)) id->byte_order=BYTE_ORD_24_GBR;
		       else id->byte_order=0;
		    }
	       }
	  }
     }
   id->x.render_depth=id->x.depth;
   XFree(xvir);
   if (id->x.depth==16)
     {
	xvi.visual=id->x.visual;
	xvi.visualid=XVisualIDFromVisual(id->x.visual);
	xvir=XGetVisualInfo(disp,VisualIDMask,&xvi,&num);
	if (xvir) 
	  {
	     if (xvir->red_mask!=0xf800) id->x.render_depth=15;
	     XFree(xvir);
	  }
     }
   if ((id->x.depth<=8)||(override==1)) loadpal=1;
   if (loadpal) 
     {
	if (dither==1)
	  {
	     if (remap==1) id->render_type=RT_DITHER_PALETTE_FAST;
	     else id->render_type=RT_DITHER_PALETTE;
	  }
	else
	  {
	     if (remap==1) id->render_type=RT_PLAIN_PALETTE_FAST;
	     else id->render_type=RT_PLAIN_PALETTE;
	  }
	Imlib_load_colors(id,palfile);
	if (id->num_colors==0)
	  {
	     fprintf(stderr,"IMLIB ERROR: Cannot Find Palette. A Palette is required for this mode\n");
	     free(id);
	     return NULL;
	  }
     }
   else 
     {
	if (id->hiq==1)
	  id->render_type=RT_DITHER_TRUECOL;
	else
	  id->render_type=RT_PLAIN_TRUECOL;
     }
     {
	XSetWindowAttributes at;
	unsigned long mask;
	
	at.border_pixel=0;
	at.backing_store=NotUseful;
	at.background_pixel=0;
	at.save_under=False;
	at.override_redirect=True;
	mask=CWOverrideRedirect|CWBackPixel|CWBorderPixel|
	  CWBackingStore|CWSaveUnder;
	newcm=0;
	if (id->x.visual!=DefaultVisual(disp,id->x.screen))
	  {
	     Colormap cm;
	     
	     cm=XCreateColormap(id->x.disp,id->x.root,
				 id->x.visual,AllocNone);
	     if (cm)
	       {
		  mask|=CWColormap;
		  id->x.root_cmap=cm;
		  at.colormap=cm;
		  newcm=1;
	       }
	  }
	id->x.base_window=XCreateWindow(id->x.disp,id->x.root,
					-100,-100,10,10,0,
					id->x.depth,InputOutput,
					id->x.visual,mask,&at);
     }
     {
	/* Turn off fastrender if there is an endianess diff between */
	/* client and Xserver */
	int byt,bit;
	
	byt=ImageByteOrder(id->x.disp); /* LSBFirst | MSBFirst */
	bit=BitmapBitOrder(id->x.disp); /* LSBFirst | MSBFirst */
	/* if little endian && server big */
	if ((htonl(1)!=1)&&(byt==MSBFirst)) id->fastrend=0;
	/* if big endian && server little */
	if ((htonl(1)==1)&&(byt==LSBFirst)) id->fastrend=0;
     }
   return id;
}

Pixmap Imlib_copy_image(ImlibData *id, ImlibImage *im)
{
   Pixmap p;
   GC tgc;
   XGCValues gcv;
   
   if (!im || !im->pixmap) return 0;
   p=XCreatePixmap(id->x.disp,id->x.base_window,im->width,im->height,id->x.depth);
   tgc=XCreateGC(id->x.disp,p,(unsigned long)0,&gcv);
   XCopyArea(id->x.disp,im->pixmap,p,tgc,0,0,im->width,im->height,0,0);
   XFreeGC(id->x.disp,tgc);
   return p;
}

Pixmap Imlib_move_image(ImlibData *id, ImlibImage *im)
{
   Pixmap p;

   if (!im) return 0;
   p=im->pixmap;
   im->pixmap=0;
   return p;
}

Pixmap Imlib_copy_mask(ImlibData *id, ImlibImage *im)
{
   Pixmap p;
   GC tgc;
   XGCValues gcv;
   
   if (!im || !im->shape_mask) return 0;
   p=XCreatePixmap(id->x.disp,id->x.base_window,im->width,im->height,1);
   tgc=XCreateGC(id->x.disp,p,(unsigned long)0,&gcv);
   XCopyArea(id->x.disp,im->shape_mask,p,tgc,0,0,im->width,im->height,0,0);
   XFreeGC(id->x.disp,tgc);
   return p;
}

Pixmap Imlib_move_mask(ImlibData *id, ImlibImage *im)
{
   Pixmap p;

   if (!im) return 0;
   p=im->shape_mask;
   im->shape_mask=0;
   return p;
}

void Imlib_destroy_image(ImlibData *id, ImlibImage *im)
{
   if (im)
     {
	if (id->cache.on_image)
	  {
	     free_image(id,im);
	     clean_caches(id);
	  }
	else
	  nullify_image(id,im);
     }
}

void Imlib_kill_image(ImlibData *id, ImlibImage *im)
{
   if (im)
     {
	if (id->cache.on_image)
	  {
	     free_image(id,im);
	     flush_image(id,im);
	     clean_caches(id);
	  }
	else
	  nullify_image(id,im);
     }
}


void Imlib_free_pixmap(ImlibData *id, Pixmap pmap)
{
   if (pmap)
     {
	free_pixmappmap(id,pmap);
	clean_caches(id);
     }
}

void Imlib_set_image_border(ImlibData *id, ImlibImage *im, ImlibBorder *border)
{
   if ((im)&&(border))
     {
	im->border.left=border->left;
	im->border.right=border->right;
	im->border.top=border->top;
	im->border.bottom=border->bottom;
     }
}

void Imlib_get_image_border(ImlibData *id, ImlibImage *im, ImlibBorder *border)
{
   if ((im)&&(border))
     {
	border->left=im->border.left;
	border->right=im->border.right;
	border->top=im->border.top;
	border->bottom=im->border.bottom;
     }
   dirty_pixmaps(id,im);
}

void Imlib_get_image_shape(ImlibData *id, ImlibImage *im, ImlibColor *color)
{
   if ((!im)||(!color)) return;
   
   color->r=im->shape_color.r;
   color->g=im->shape_color.g;
   color->b=im->shape_color.b;
}

void Imlib_set_image_shape(ImlibData *id, ImlibImage *im, ImlibColor *color)
{
   if ((!im)||(!color)) return;
   
   im->shape_color.r=color->r;
   im->shape_color.g=color->g;
   im->shape_color.b=color->b;
   dirty_pixmaps(id,im);
}

int Imlib_get_fallback(ImlibData *id)
{
   if (!id) return 0;
   return id->fallback;
}

void Imlib_set_fallback(ImlibData *id, int fallback)
{
   if (!id) return;
   id->fallback=fallback;
}

Visual *Imlib_get_visual(ImlibData *id)
{
   if (!id) return NULL;
   return id->x.visual;
}

Colormap Imlib_get_colormap(ImlibData *id)
{
   if (!id) return 0;
   return id->x.root_cmap;
}

char *Imlib_get_sysconfig(ImlibData *id)
{
   return strdup(SYSTEM_IMRC);
}
