/*
	Copyright (c) 1997,1998 Eugene G. Crosser
	Copyright (c) 1998 Bruce D. Lightner (DOS/Windows support)

	You may do virtually what you wish with this software, as long
	as the explicit reference to its original author is retained.

	THIS SOFTWARE IS PROVIDED AS IS AND COME WITH NO WARRANTY OF ANY
	KIND, EITHER EXPRESSED OR IMPLIED.  IN NO EVENT WILL THE
	COPYRIGHT HOLDER BE LIABLE FOR ANY DAMAGES RESULTING FROM THE
	USE OF THIS SOFTWARE.
*/

#ifndef _EPH_PRIV_H
#define _EPH_PRIV_H

#include <sys/types.h>

#define RETRIES              3

#ifdef USE_VMIN_AND_VTIME
#define INITTIMEOUT    1100000L
#define DATATIMEOUT    1100000L
#define BIGDATATIMEOUT 1500000L
#define ACKTIMEOUT     1100000L
#define BIGACKTIMEOUT  1100000L
#define EODTIMEOUT     1100000L
#define CMDTIMEOUT    15000000L
#else
#define INITTIMEOUT    1000000L
#define DATATIMEOUT     200000L
#define BIGDATATIMEOUT 1500000L
#define ACKTIMEOUT      400000L
#define BIGACKTIMEOUT   800000L
#define EODTIMEOUT      400000L
#define CMDTIMEOUT    15000000L
#endif

#define WRTPKTDELAY        250L
#define WRTCMDDELAY        250L
#define WRTPRMDELAY        500L
#define WRTDELAY          1000L
#define SPEEDCHGDELAY   100000L

#define SKIPNULS           200

#define ACK 0x06
#define DC1 0x11
#define NAK 0x15
/*#define NAK 0x11*/

#define CMD_SETINT 0
#define CMD_GETINT 1
#define CMD_ACTION 2
#define CMD_SETVAR 3
#define CMD_GETVAR 4

#define PKT_CMD 0x1b
#define PKT_DATA 0x02
#define PKT_LAST 0x03

#define SEQ_INITCMD 0x53
#define SEQ_CMD 0x43

typedef struct _eph_pkthdr {
	unsigned char typ;
	unsigned char seq;
} eph_pkthdr;

size_t eph_readt(eph_iob *iob,char *buf,size_t length,long timeout_usec,int *rc);

void eph_error(eph_iob *iob,int err,char *fmt,...);
void eph_writeinit(eph_iob *iob);
void eph_writeack(eph_iob *iob);
void eph_writenak(eph_iob *iob);
int eph_waitack(eph_iob *iob,long timeout_usec);
int eph_waitcomplete(eph_iob *iob);
int eph_waitsig(eph_iob *iob);
int eph_waiteot(eph_iob *iob);

int eph_writepkt(eph_iob *iob,int typ,int seq,char *data,size_t length);
int eph_writecmd(eph_iob *iob,char *data,size_t length);
int eph_writeicmd(eph_iob *iob,char *data,size_t length);
int eph_readpkt(eph_iob *iob,eph_pkthdr *pkthdr,char *buf,size_t *length,long timeout_usec);

int eph_setispeed(eph_iob *iob,long val);

#endif
