/*
	Copyright (c) 1997,1998 Eugene G. Crosser
	Copyright (c) 1998 Bruce D. Lightner (DOS/Windows support)

	You may do virtually what you wish with this software, as long
	as the explicit reference to its original author is retained.

	THIS SOFTWARE IS PROVIDED AS IS AND COME WITH NO WARRANTY OF ANY
	KIND, EITHER EXPRESSED OR IMPLIED.  IN NO EVENT WILL THE
	COPYRIGHT HOLDER BE LIABLE FOR ANY DAMAGES RESULTING FROM THE
	USE OF THIS SOFTWARE.
*/

#include <sys/types.h>
#include <string.h>
#include "jscan.h"

int jscan(unsigned char **buf,size_t *bufsize) {
	unsigned char *p;
	size_t length=0;
	int i;

	p=*buf;
	while (p < ((*buf)+(*bufsize))) {
		while ((p < ((*buf)+(*bufsize))) && (*p != 0xff)) p++;
		while ((p < ((*buf)+(*bufsize))) && (*p == 0xff)) p++;
		if (*p == 0xD8) continue;
		length=(p[1]<<8)+p[2];
		if (*p == 0xec) {
			/* skip company name which is model-dependant */
#if 1
			/* assume no one else uses Marker 12 */
			for (i=0;i<length;i++)
				if (*(p+3+i) == '\0') break;
			if (i < length) {
				p+=i+4;
				length-=i+4;
				break;
			}
#else
			/* check if this is "right" Marker 12 */

			/*
			   we decided to skip this check because
			   different models (even from the same
			   manufacturer) seem to have slightly
			   different strings
			*/

			if (strcmp(p+3,"SanyoElectricDSC") == 0) {
				p+=4;
				p+=strlen("SanyoElectricDSC");
				length-=3;
				length-=strlen("SanyoElectricDSC");
				break;
			} else if (strcmp(p+3,"OLYMPUS OPTICAL CO.,LTD.   ") == 0) {
				p+=4;
				p+=strlen("OLYMPUS OPTICAL CO.,LTD.   ");
				length-=3;
				length-=strlen("OLYMPUS OPTICAL CO.,LTD.   ");
				break;
			}
			/* For D-600L string is not space-padded */
#endif
		}
		p+=length;
	}
	if (p >= ((*buf)+(*bufsize))) return -1;

	(*bufsize)=length;
	(*buf)=p;
	return 0;
}

unsigned char *jsearch(char *key,unsigned char *buf,size_t bufsize) {
	unsigned char *p;

	p=buf;
	while (p < (buf+bufsize)) {
		if (strncmp(p,key,strlen(key)) == 0) break;
		while ((p < (buf+bufsize)) && (*p != '\n')) p++;
		p++;
	}
	if (p >= (buf+bufsize)) return NULL;
	if (*(p+strlen(key)) != '=') return NULL;
	return p+strlen(key)+1;
}
