/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user or with the express written consent of
 * Sun Microsystems, Inc.
 *
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 *
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 *
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 *
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */

#ifndef _RPCSVC_NIS_H
#define _RPCSVC_NIS_H 1

#include <features.h>
#include <rpc/rpc.h>
#include <rpcsvc/nis_tags.h>

__BEGIN_DECLS

/*
 *	nis.h
 *
 *	This file is the main include file for NIS clients. It contains
 *	both the client library function defines and the various data
 * 	structures used by the NIS service. It includes the file nis_tags.h
 *	which defines the tag values. This allows the tags to change without
 *	having to change the nis.x file.
 *
 *	NOTE : THIS FILE IS NOT GENERATED WITH RPCGEN ! SO YOU HAVE TO
 *             ADD ALL THE CHANGES ON nis_*.x FILES HERE AGAIN !
 *
 *      I have removed all the Solaris internal structs and variables,
 *      because they are not supported, Sun changed them between various
 *      releases and they shouldn't be used in user programs.
 *                                              <kukuk@vt.uni-paderborn.de>
 */


#ifndef __nis_object_h
#define __nis_object_h

#define NIS_MAXSTRINGLEN 255
#define NIS_MAXNAMELEN 1024
#define NIS_MAXATTRNAME 32
#define NIS_MAXATTRVAL 2048
#define NIS_MAXCOLUMNS 64
#define NIS_MAXATTR 16
#define NIS_MAXPATH 1024
#define NIS_MAXREPLICAS 128
#define NIS_MAXLINKS 16
#define NIS_PK_NONE 0
#define NIS_PK_DH 1
#define NIS_PK_RSA 2
#define NIS_PK_KERB 3

struct nis_attr {
	char *zattr_ndx;
	struct {
		u_int zattr_val_len;
		char *zattr_val_val;
	} zattr_val;
};
typedef struct nis_attr nis_attr;
extern  bool_t xdr_nis_attr __P ((XDR *, nis_attr*));

typedef char *nis_name;
extern  bool_t xdr_nis_name __P ((XDR *, nis_name*));

enum zotypes {
	BOGUS_OBJ = 0,
	NO_OBJ = 1,
	DIRECTORY_OBJ = 2,
	GROUP_OBJ = 3,
	TABLE_OBJ = 4,
	ENTRY_OBJ = 5,
	LINK_OBJ = 6,
	PRIVATE_OBJ = 7,
	NIS_BOGUS_OBJ = 0,
	NIS_NO_OBJ = 1,
	NIS_DIRECTORY_OBJ = 2,
	NIS_GROUP_OBJ = 3,
	NIS_TABLE_OBJ = 4,
	NIS_ENTRY_OBJ = 5,
	NIS_LINK_OBJ = 6,
	NIS_PRIVATE_OBJ = 7
};
typedef enum zotypes zotypes;
extern  bool_t xdr_zotypes __P ((XDR *, zotypes*));

enum nstype {
	UNKNOWN = 0,
	NIS = 1,
	SUNYP = 2,
	IVY = 3,
	DNS = 4,
	X500 = 5,
	DNANS = 6,
	XCHS = 7,
	CDS = 8,
};
typedef enum nstype nstype;
extern  bool_t xdr_nstype __P ((XDR *, nstype*));

struct oar_mask {
	u_long oa_rights;
	zotypes oa_otype;
};
typedef struct oar_mask oar_mask;
extern  bool_t xdr_oar_mask __P ((XDR *, oar_mask*));

struct endpoint {
	char *uaddr;
	char *family;
	char *proto;
};
typedef struct endpoint endpoint;
extern  bool_t xdr_endpoint __P ((XDR *, endpoint*));

struct nis_server {
	nis_name name;
	struct {
		u_int ep_len;
		endpoint *ep_val;
	} ep;
	u_long key_type;
	netobj pkey;
};
typedef struct nis_server nis_server;
extern  bool_t xdr_nis_server __P ((XDR *, nis_server*));

struct directory_obj {
	nis_name do_name;
	nstype do_type;
	struct {
		u_int do_servers_len;
		nis_server *do_servers_val;
	} do_servers;
	u_long do_ttl;
	struct {
		u_int do_armask_len;
		oar_mask *do_armask_val;
	} do_armask;
};
typedef struct directory_obj directory_obj;
extern  bool_t xdr_directory_obj __P ((XDR *, directory_obj*));

#define EN_BINARY 1
#define EN_CRYPT 2
#define EN_XDR 4
#define EN_MODIFIED 8
#define EN_ASN1 64

struct entry_col {
	u_long ec_flags;
	struct {
		u_int ec_value_len;
		char *ec_value_val;
	} ec_value;
};
typedef struct entry_col entry_col;
extern  bool_t xdr_entry_col __P ((XDR *, entry_col*));

struct entry_obj {
	char *en_type;
	struct {
		u_int en_cols_len;
		entry_col *en_cols_val;
	} en_cols;
};
typedef struct entry_obj entry_obj;
extern  bool_t xdr_entry_obj __P ((XDR *, entry_obj*));

struct group_obj {
	u_long gr_flags;
	struct {
		u_int gr_members_len;
		nis_name *gr_members_val;
	} gr_members;
};
typedef struct group_obj group_obj;
extern  bool_t xdr_group_obj __P ((XDR *, group_obj*));

struct link_obj {
	zotypes li_rtype;
	struct {
		u_int li_attrs_len;
		nis_attr *li_attrs_val;
	} li_attrs;
	nis_name li_name;
};
typedef struct link_obj link_obj;
extern  bool_t xdr_link_obj __P ((XDR *, link_obj*));

#define TA_BINARY 1
#define TA_CRYPT 2
#define TA_XDR 4
#define TA_SEARCHABLE 8
#define TA_CASE 16
#define TA_MODIFIED 32
#define TA_ASN1 64

struct table_col {
	char *tc_name;
	u_long tc_flags;
	u_long tc_rights;
};
typedef struct table_col table_col;
extern  bool_t xdr_table_col __P ((XDR *, table_col*));

struct table_obj {
	char *ta_type;
	int ta_maxcol;
	u_char ta_sep;
	struct {
		u_int ta_cols_len;
		table_col *ta_cols_val;
	} ta_cols;
	char *ta_path;
};
typedef struct table_obj table_obj;
extern  bool_t xdr_table_obj __P ((XDR *, table_obj*));

struct objdata {
	zotypes zo_type;
	union {
		struct directory_obj di_data;
		struct group_obj gr_data;
		struct table_obj ta_data;
		struct entry_obj en_data;
		struct link_obj li_data;
		struct {
			u_int po_data_len;
			char *po_data_val;
		} po_data;
	} objdata_u;
};
typedef struct objdata objdata;
extern  bool_t xdr_objdata __P ((XDR *, objdata*));

struct nis_oid {
	u_long ctime;
	u_long mtime;
};
typedef struct nis_oid nis_oid;
extern  bool_t xdr_nis_oid __P ((XDR *, nis_oid*));

struct nis_object {
	nis_oid zo_oid;
	nis_name zo_name;
	nis_name zo_owner;
	nis_name zo_group;
	nis_name zo_domain;
	u_long zo_access;
	u_long zo_ttl;
	objdata zo_data;
};
typedef struct nis_object nis_object;
extern  bool_t xdr_nis_object __P ((XDR *, nis_object*));

#endif /* if __nis_object_h */

enum nis_error {
	NIS_SUCCESS = 0,
	NIS_S_SUCCESS = 1,
	NIS_NOTFOUND = 2,
	NIS_S_NOTFOUND = 3,
	NIS_CACHEEXPIRED = 4,
	NIS_NAMEUNREACHABLE = 5,
	NIS_UNKNOWNOBJ = 6,
	NIS_TRYAGAIN = 7,
	NIS_SYSTEMERROR = 8,
	NIS_CHAINBROKEN = 9,
	NIS_PERMISSION = 10,
	NIS_NOTOWNER = 11,
	NIS_NOT_ME = 12,
	NIS_NOMEMORY = 13,
	NIS_NAMEEXISTS = 14,
	NIS_NOTMASTER = 15,
	NIS_INVALIDOBJ = 16,
	NIS_BADNAME = 17,
	NIS_NOCALLBACK = 18,
	NIS_CBRESULTS = 19,
	NIS_NOSUCHNAME = 20,
	NIS_NOTUNIQUE = 21,
	NIS_IBMODERROR = 22,
	NIS_NOSUCHTABLE = 23,
	NIS_TYPEMISMATCH = 24,
	NIS_LINKNAMEERROR = 25,
	NIS_PARTIAL = 26,
	NIS_TOOMANYATTRS = 27,
	NIS_RPCERROR = 28,
	NIS_BADATTRIBUTE = 29,
	NIS_NOTSEARCHABLE = 30,
	NIS_CBERROR = 31,
	NIS_FOREIGNNS = 32,
	NIS_BADOBJECT = 33,
	NIS_NOTSAMEOBJ = 34,
	NIS_MODFAIL = 35,
	NIS_BADREQUEST = 36,
	NIS_NOTEMPTY = 37,
	NIS_COLDSTART_ERR = 38,
	NIS_RESYNC = 39,
	NIS_FAIL = 40,
	NIS_UNAVAIL = 41,
	NIS_RES2BIG = 42,
	NIS_SRVAUTH = 43,
	NIS_CLNTAUTH = 44,
	NIS_NOFILESPACE = 45,
	NIS_NOPROC = 46,
	NIS_DUMPLATER = 47,
};
typedef enum nis_error nis_error;
extern  bool_t xdr_nis_error __P ((XDR *, nis_error*));

struct nis_result {
	nis_error status;
	struct {
		u_int objects_len;
		nis_object *objects_val;
	} objects;
	netobj cookie;
	u_long zticks;
	u_long dticks;
	u_long aticks;
	u_long cticks;
};
typedef struct nis_result nis_result;
extern  bool_t xdr_nis_result __P ((XDR *, nis_result*));

struct ns_request {
	nis_name ns_name;
	struct {
		u_int ns_object_len;
		nis_object *ns_object_val;
	} ns_object;
};
typedef struct ns_request ns_request;
extern  bool_t xdr_ns_request __P ((XDR *, ns_request*));

struct ib_request {
	nis_name ibr_name;
	struct {
		u_int ibr_srch_len;
		nis_attr *ibr_srch_val;
	} ibr_srch;
	u_long ibr_flags;
	struct {
		u_int ibr_obj_len;
		nis_object *ibr_obj_val;
	} ibr_obj;
	struct {
		u_int ibr_cbhost_len;
		nis_server *ibr_cbhost_val;
	} ibr_cbhost;
	u_long ibr_bufsize;
	netobj ibr_cookie;
};
typedef struct ib_request ib_request;
extern  bool_t xdr_ib_request __P ((XDR *, ib_request*));

struct ping_args {
	nis_name dir;
	u_long stamp;
};
typedef struct ping_args ping_args;
extern  bool_t xdr_ping_args __P ((XDR *, ping_args*));

enum log_entry_t {
	LOG_NOP = 0,
	ADD_NAME = 1,
	REM_NAME = 2,
	MOD_NAME_OLD = 3,
	MOD_NAME_NEW = 4,
	ADD_IBASE = 5,
	REM_IBASE = 6,
	MOD_IBASE = 7,
	UPD_STAMP = 8,
};
typedef enum log_entry_t log_entry_t;
extern  bool_t xdr_log_entry_t __P ((XDR *, log_entry_t*));

struct log_entry {
	u_long le_time;
	log_entry_t le_type;
	nis_name le_princp;
	nis_name le_name;
	struct {
		u_int le_attrs_len;
		nis_attr *le_attrs_val;
	} le_attrs;
	nis_object le_object;
};
typedef struct log_entry log_entry;
extern  bool_t xdr_log_entry __P ((XDR *, log_entry*));

struct log_result {
	nis_error lr_status;
	netobj lr_cookie;
	struct {
		u_int lr_entries_len;
		log_entry *lr_entries_val;
	} lr_entries;
};
typedef struct log_result log_result;
extern  bool_t xdr_log_result __P ((XDR *, log_result*));

struct cp_result {
	nis_error cp_status;
	u_long cp_zticks;
	u_long cp_dticks;
};
typedef struct cp_result cp_result;
extern  bool_t xdr_cp_result __P ((XDR *, cp_result*));

struct nis_tag {
	u_long tag_type;
	char *tag_val;
};
typedef struct nis_tag nis_tag;
extern  bool_t xdr_nis_tag __P ((XDR *, nis_tag*));

struct nis_taglist {
	struct {
		u_int tags_len;
		nis_tag *tags_val;
	} tags;
};
typedef struct nis_taglist nis_taglist;
extern  bool_t xdr_nis_taglist __P ((XDR *, nis_taglist*));

struct dump_args {
	nis_name da_dir;
	u_long da_time;
	struct {
		u_int da_cbhost_len;
		nis_server *da_cbhost_val;
	} da_cbhost;
};
typedef struct dump_args dump_args;
extern  bool_t xdr_dump_args __P ((XDR *, dump_args*));

struct fd_args {
	nis_name dir_name;
	nis_name requester;
};
typedef struct fd_args fd_args;
extern  bool_t xdr_fd_args __P ((XDR *, fd_args*));

struct fd_result {
	nis_error status;
	nis_name source;
	struct {
		u_int dir_data_len;
		char *dir_data_val;
	} dir_data;
	struct {
		u_int signature_len;
		char *signature_val;
	} signature;
};
typedef struct fd_result fd_result;
extern  bool_t xdr_fd_result __P ((XDR *, fd_result*));

/* Generic client creating flags */
#define ZMH_VC		1
#define ZMH_DG		2
#define ZMH_AUTH	4

/* Testing Access rights for objects */

#define NIS_READ_ACC		1
#define NIS_MODIFY_ACC		2
#define NIS_CREATE_ACC		4
#define NIS_DESTROY_ACC	8
/* Test macros. a == access rights, m == desired rights. */
#define NIS_WORLD(a, m)        (((a) & (m)) != 0)
#define NIS_GROUP(a, m)        (((a) & ((m) << 8)) != 0)
#define NIS_OWNER(a, m)        (((a) & ((m) << 16)) != 0)
#define NIS_NOBODY(a, m)       (((a) & ((m) << 24)) != 0)
/*
 * EOL Alert - The following non-prefixed test macros are
 * here for backward compatability, and will be not be present
 * in future releases - use the NIS_*() macros above.
 */
#define WORLD(a, m)	(((a) & (m)) != 0)
#define GROUP(a, m)	(((a) & ((m) << 8)) != 0)
#define OWNER(a, m)	(((a) & ((m) << 16)) != 0)
#define NOBODY(a, m)	(((a) & ((m) << 24)) != 0)

#define OATYPE(d, n) (((d)->do_armask.do_armask_val+n)->oa_otype)
#define OARIGHTS(d, n) (((d)->do_armask.do_armask_val+n)->oa_rights)
#define WORLD_DEFAULT (NIS_READ_ACC)
#define GROUP_DEFAULT (NIS_READ_ACC << 8)
#define OWNER_DEFAULT ((NIS_READ_ACC + NIS_MODIFY_ACC + NIS_CREATE_ACC +\
			NIS_DESTROY_ACC) << 16)
#define DEFAULT_RIGHTS (WORLD_DEFAULT | GROUP_DEFAULT | OWNER_DEFAULT)

/* Result manipulation defines ... */
#define NIS_RES_NUMOBJ(x)	((x)->objects.objects_len)
#define NIS_RES_OBJECT(x)	((x)->objects.objects_val)
#define NIS_RES_COOKIE(x)	((x)->cookie)
#define NIS_RES_STATUS(x)	((x)->status)

/* These defines make getting at the variant part of the object easier. */
#define TA_data zo_data.objdata_u.ta_data
#define EN_data zo_data.objdata_u.en_data
#define DI_data zo_data.objdata_u.di_data
#define LI_data zo_data.objdata_u.li_data
#define GR_data zo_data.objdata_u.gr_data

#define __type_of(o) ((o)->zo_data.zo_type)

/* Declarations for the internal subroutines in nislib.c */
enum name_pos {SAME_NAME, HIGHER_NAME, LOWER_NAME, NOT_SEQUENTIAL, BAD_NAME};
typedef enum name_pos name_pos;

/*
 * Defines for getting at column data in entry objects. Because RPCGEN
 * generates some rather wordy structures, we create some defines that
 * collapse the needed keystrokes to access a particular value using
 * these definitions they take an nis_object *, and an int and return
 * a u_char * for Value, and an int for length.
 */
#define ENTRY_VAL(obj, col) (obj)->EN_data.en_cols.en_cols_val[col].ec_value.ec_value_val
#define ENTRY_LEN(obj, col) (obj)->EN_data.en_cols.en_cols_val[col].ec_value.ec_value_len


/* Prototypes, and extern declarations for the NIS library functions. */
#include <rpcsvc/nislib.h>
#endif

/*
 * nis_3.h
 *
 * This file contains definitions that are only of interest to the actual
 * service daemon and client stubs. Normal users of NIS will not include
 * this file.
 *
 * NOTE : This include file is automatically created by a combination
 * of rpcgen and sed. DO NOT EDIT IT, change the nis.x file instead
 * and then remake this file.
 */
#ifndef __nis_3_h
#define __nis_3_h

#define NIS_PROG ((u_long)100300)
#define NIS_VERSION ((u_long)3)

#define NIS_LOOKUP ((u_long)1)
extern  nis_result * nis_lookup_3 __P ((ns_request *, CLIENT *));
extern  nis_result * nis_lookup_3_svc __P ((ns_request *, struct svc_req *));
#define NIS_ADD ((u_long)2)
extern  nis_result * nis_add_3 __P ((ns_request *, CLIENT *));
extern  nis_result * nis_add_3_svc __P ((ns_request *, struct svc_req *));
#define NIS_MODIFY ((u_long)3)
extern  nis_result * nis_modify_3 __P ((ns_request *, CLIENT *));
extern  nis_result * nis_modify_3_svc __P ((ns_request *, struct svc_req *));
#define NIS_REMOVE ((u_long)4)
extern  nis_result * nis_remove_3 __P ((ns_request *, CLIENT *));
extern  nis_result * nis_remove_3_svc __P ((ns_request *, struct svc_req *));
#define NIS_IBLIST ((u_long)5)
extern  nis_result * nis_iblist_3 __P ((ib_request *, CLIENT *));
extern  nis_result * nis_iblist_3_svc __P ((ib_request *, struct svc_req *));
#define NIS_IBADD ((u_long)6)
extern  nis_result * nis_ibadd_3 __P ((ib_request *, CLIENT *));
extern  nis_result * nis_ibadd_3_svc __P ((ib_request *, struct svc_req *));
#define NIS_IBMODIFY ((u_long)7)
extern  nis_result * nis_ibmodify_3 __P ((ib_request *, CLIENT *));
extern  nis_result * nis_ibmodify_3_svc __P ((ib_request *, struct svc_req *));
#define NIS_IBREMOVE ((u_long)8)
extern  nis_result * nis_ibremove_3 __P ((ib_request *, CLIENT *));
extern  nis_result * nis_ibremove_3_svc __P ((ib_request *, struct svc_req *));
#define NIS_IBFIRST ((u_long)9)
extern  nis_result * nis_ibfirst_3 __P ((ib_request *, CLIENT *));
extern  nis_result * nis_ibfirst_3_svc __P ((ib_request *, struct svc_req *));
#define NIS_IBNEXT ((u_long)10)
extern  nis_result * nis_ibnext_3 __P ((ib_request *, CLIENT *));
extern  nis_result * nis_ibnext_3_svc __P ((ib_request *, struct svc_req *));
#define NIS_FINDDIRECTORY ((u_long)12)
extern  fd_result * nis_finddirectory_3 __P ((fd_args *, CLIENT *));
extern  fd_result * nis_finddirectory_3_svc __P ((fd_args *,
						  struct svc_req *));
#define NIS_STATUS ((u_long)14)
extern  nis_taglist * nis_status_3 __P ((nis_taglist *, CLIENT *));
extern  nis_taglist * nis_status_3_svc __P ((nis_taglist *, struct svc_req *));
#define NIS_DUMPLOG ((u_long)15)
extern  log_result * nis_dumplog_3 __P ((dump_args *, CLIENT *));
extern  log_result * nis_dumplog_3_svc __P ((dump_args *, struct svc_req *));
#define NIS_DUMP ((u_long)16)
extern  log_result * nis_dump_3 __P ((dump_args *, CLIENT *));
extern  log_result * nis_dump_3_svc __P ((dump_args *, struct svc_req *));
#define NIS_CALLBACK ((u_long)17)
extern  bool_t * nis_callback_3 __P ((netobj *, CLIENT *));
extern  bool_t * nis_callback_3_svc __P ((netobj *, struct svc_req *));
#define NIS_CPTIME ((u_long)18)
extern  u_long * nis_cptime_3 __P ((nis_name *, CLIENT *));
extern  u_long * nis_cptime_3_svc __P ((nis_name *, struct svc_req *));
#define NIS_CHECKPOINT ((u_long)19)
extern  cp_result * nis_checkpoint_3 __P ((nis_name *, CLIENT *));
extern  cp_result * nis_checkpoint_3_svc __P ((nis_name *, struct svc_req *));
#define NIS_PING ((u_long)20)
extern  void * nis_ping_3 __P ((ping_args *, CLIENT *));
extern  void * nis_ping_3_svc __P ((ping_args *, struct svc_req *));
#define NIS_SERVSTATE ((u_long)21)
extern  nis_taglist * nis_servstate_3 __P ((nis_taglist *, CLIENT *));
extern  nis_taglist * nis_servstate_3_svc __P ((nis_taglist *,
						struct svc_req *));
#define NIS_MKDIR ((u_long)22)
extern  nis_error * nis_mkdir_3 __P ((nis_name *, CLIENT *));
extern  nis_error * nis_mkdir_3_svc __P ((nis_name *, struct svc_req *));
#define NIS_RMDIR ((u_long)23)
extern  nis_error * nis_rmdir_3 __P ((nis_name *, CLIENT *));
extern  nis_error * nis_rmdir_3_svc __P ((nis_name *, struct svc_req *));
#define NIS_UPDKEYS ((u_long)24)
extern  nis_error * nis_updkeys_3 __P ((nis_name *, CLIENT *));
extern  nis_error * nis_updkeys_3_svc __P ((nis_name *, struct svc_req *));

__END_DECLS

#endif /* !_NIS_H_RPCGEN */
