/**
 *
 * $Id: LabelG.c,v 1.51 1998/03/03 21:58:51 rwscott Exp $
 *
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

static char rcsid[] = "$Id: LabelG.c,v 1.51 1998/03/03 21:58:51 rwscott Exp $";

#include <LTconfig.h>
#include <XmI/XmI.h>

#include <Xm/XmP.h>
#include <Xm/AtomMgr.h>
#include <Xm/LabelP.h>
#include <Xm/LabelGP.h>
#include <Xm/RowColumnP.h>
#include <Xm/DragDrop.h>
#include <Xm/MenuShellP.h>
#include <Xm/CacheP.h>
#include <Xm/XmosP.h>
#include <Xm/ScreenP.h>
#include <Xm/DragIconP.h>
#include <XmI/AtomMgrI.h>
#include <X11/Xfuncs.h>
#ifdef __STDC__
#include <stdarg.h>
#else
#include <varargs.h>
#endif

#include <XmI/DebugUtil.h>

#ifndef XmUNSPECIFIED
#define XmUNSPECIFIED (~0)
#endif

/* Forward Declarations */

static void class_initialize();

static void class_part_initialize(WidgetClass w_class);

static void initialize(Widget request, Widget new_w,
		       ArgList args, Cardinal *num_args);

static void destroy(Widget w);

static void resize(Widget w);

static void expose(Widget w, XEvent *event, Region region);

static XtGeometryResult query_geometry(Widget w,
				       XtWidgetGeometry *proposed,
				       XtWidgetGeometry *answer);

#if 0
static void get_values_hook(Widget w, ArgList args, Cardinal *num_args);
#endif

static void input_dispatch(Widget gadget, XEvent *event, Mask event_mask);

static Boolean set_values(Widget current, Widget request, Widget new_w,
			  ArgList args, Cardinal *num_args);

static void secondary_object_create(Widget request, Widget new_w,
				    ArgList args, Cardinal *num_args);

#if 0
static void initialize_prehook(Widget request, Widget new_w,
			       ArgList args, Cardinal *num_args);
#endif

static void initialize_posthook(Widget request, Widget new_w,
				ArgList args, Cardinal *num_args);

static Boolean set_values_prehook(Widget old, Widget request, Widget new_w,
				  ArgList args, Cardinal *num_args);

static Boolean set_values_posthook(Widget old, Widget request, Widget new_w,
				   ArgList args, Cardinal *num_args);

static void get_values_prehook(Widget new_w, ArgList args, Cardinal *num_args);

static void get_values_posthook(Widget new_w, ArgList args, Cardinal *num_args);

static Cardinal get_sec_res_data(WidgetClass wc,
				 XmSecondaryResourceData **data);

static void drag_drop_finish(Widget w,
			     XtPointer client_data,
			     XtPointer call_data);

static Boolean drag_convert_proc(Widget w, Atom *selection,
				 Atom *target, Atom *type_return,
				 XtPointer *value_return,
				 unsigned long *length_return,
				 int *format_return);

extern Boolean _XmLabelGetBaselines(Widget w,
				    Dimension **baselines,
				    int *nbaselines);

extern Boolean _XmLabelGetDisplayRect(Widget w, XRectangle *rect);

/*
 * resources
 */
#define Offset(field) XtOffsetOf(XmLabelGCacheObjRec, label_cache.field)
static XtResource cache_resources[] =
{
    {
	XmNlabelType, XmCLabelType, XmRLabelType,
	sizeof(unsigned char), Offset(label_type),
	XmRImmediate, (XtPointer)XmSTRING
    },
    {
	XmNalignment, XmCAlignment, XmRAlignment,
	sizeof(unsigned char), Offset(alignment),
	XmRImmediate, (XtPointer)XmALIGNMENT_CENTER
    },
    {
	XmNmarginWidth, XmCMarginWidth, XmRHorizontalDimension,
	sizeof(Dimension), Offset(margin_width),
	XmRImmediate, (XtPointer)2
    },
    {
	XmNmarginHeight, XmCMarginHeight, XmRVerticalDimension,
	sizeof(Dimension), Offset(margin_height),
	XmRImmediate, (XtPointer)2
    },
    {
	XmNmarginLeft, XmCMarginLeft, XmRHorizontalDimension,
	sizeof(Dimension), Offset(margin_left),
	XmRImmediate, (XtPointer)0
    },
    {
	XmNmarginRight, XmCMarginRight, XmRHorizontalDimension,
	sizeof(Dimension), Offset(margin_right),
	XmRImmediate, (XtPointer)0
    },
    {
	XmNmarginTop, XmCMarginTop, XmRVerticalDimension,
	sizeof(Dimension), Offset(margin_top),
	XmRImmediate, (XtPointer)0
    },
    {
	XmNmarginBottom, XmCMarginBottom, XmRVerticalDimension,
	sizeof(Dimension), Offset(margin_bottom),
	XmRImmediate, (XtPointer)0
    },
    {
	XmNrecomputeSize, XmCRecomputeSize, XmRBoolean,
	sizeof(Boolean), Offset(recompute_size),
	XmRImmediate, (XtPointer)True
    },
    {
	XmNstringDirection, XmCStringDirection, XmRStringDirection,
	sizeof(XmStringDirection), Offset(string_direction),
	XmRImmediate, (XtPointer)((XmStringDirection)XmUNSPECIFIED)
    }
};

static XmSyntheticResource cache_syn_resources[] =
{
    {
	XmNmarginWidth,
	sizeof(Dimension), Offset(margin_width),
	_XmFromHorizontalPixels, _XmToHorizontalPixels
    },
    {
	XmNmarginHeight,
	sizeof(Dimension), Offset(margin_height),
	_XmFromVerticalPixels, _XmToVerticalPixels
    },
    {
	XmNmarginLeft,
	sizeof(Dimension), Offset(margin_left),
	_XmFromHorizontalPixels, _XmToHorizontalPixels
    },
    {
	XmNmarginRight,
	sizeof(Dimension), Offset(margin_right),
	_XmFromHorizontalPixels, _XmToHorizontalPixels
    },
    {
	XmNmarginTop,
	sizeof(Dimension), Offset(margin_top),
	_XmFromVerticalPixels, _XmToVerticalPixels
    },
    {
	XmNmarginBottom,
	sizeof(Dimension), Offset(margin_bottom),
	_XmFromVerticalPixels, _XmToVerticalPixels
    },
};

XmLabelGCacheObjClassRec xmLabelGCacheObjClassRec =
{
    /* Object class part */
    {
	/* superclass            */ (WidgetClass)&xmExtClassRec,
	/* class_name            */ "XmLabelGCacheObjClass",
	/* widget_size           */ sizeof(XmLabelGCacheObjRec),
	/* class_initialize      */ NULL,
	/* class_part_initialize */ NULL,
	/* class_inited          */ False,
	/* initialize            */ NULL,
	/* initialize_hook       */ NULL,
	/* realize               */ NULL,
	/* actions               */ NULL,
	/* num_actions           */ 0,
	/* resources             */ cache_resources,
	/* num_resources         */ XtNumber(cache_resources),
	/* xrm_class             */ NULLQUARK,
	/* compress_motion       */ 0,
	/* compress_exposure     */ 0,
	/* compress_enterleave   */ 0,
	/* visible_interest      */ 0,
	/* destroy               */ NULL,
	/* resize                */ NULL,
	/* expose                */ NULL,
	/* set_values            */ NULL,
	/* set_values_hook       */ NULL,
	/* set_values_almost     */ NULL,
	/* get_values_hook       */ NULL,
	/* accept_focus          */ NULL,
	/* version               */ XtVersion,
	/* callback offsets      */ NULL,
	/* tm_table              */ NULL,
	/* query_geometry        */ NULL,
	/* display_accelerator   */ NULL,
	/* extension             */ NULL
    },
    /* XmExtObject part */
    {
	/* syn_resources      */ cache_syn_resources,
	/* num_syn_resources  */ XtNumber(cache_syn_resources),
	/* extension          */ NULL
    },
    /* LabelGCacheObj part */
    {
	/* foo                */ 0
    }
};

#undef Offset
#define Offset(field) XtOffsetOf(XmLabelGadgetRec, label.field)

/* Resources for the label class */
static XtResource resources[] =
{
    {
	XmNshadowThickness, XmCShadowThickness, XmRHorizontalDimension,
      sizeof(Dimension), XtOffsetOf(XmLabelGadgetRec, gadget.shadow_thickness),
	XmRImmediate, (XtPointer)0
    },
    {
	XmNlabelPixmap, XmCLabelPixmap, XmRGadgetPixmap,
	sizeof(Pixmap), Offset(pixmap),
	XmRImmediate, (XtPointer)XmUNSPECIFIED_PIXMAP
    },
    {
	XmNlabelInsensitivePixmap, XmCLabelInsensitivePixmap, XmRGadgetPixmap,
	sizeof(Pixmap), Offset(pixmap_insen),
	XmRImmediate, (XtPointer)XmUNSPECIFIED_PIXMAP
    },
    {
	XmNlabelString, XmCXmString, XmRXmString,
	sizeof(XmString), Offset(_label),
	XmRImmediate, (XtPointer)NULL
    },
    {
	XmNfontList, XmCFontList, XmRFontList,
	sizeof(XmFontList), Offset(font),
	XmRImmediate, (XtPointer)NULL
    },
    {
	XmNmnemonic, XmCMnemonic, XmRKeySym,
	sizeof(KeySym), Offset(mnemonic),
	XmRImmediate, (XtPointer)NULL
    },
    {
	XmNmnemonicCharSet, XmCMnemonicCharSet, XmRString,
	sizeof(String), Offset(mnemonicCharset),
	XmRImmediate, (XtPointer)XmFONTLIST_DEFAULT_TAG
    },
    {
	XmNaccelerator, XmCAccelerator, XmRString,
	sizeof(String), Offset(accelerator),
	XmRImmediate, (XtPointer)NULL
    },
    {
	XmNacceleratorText, XmCAcceleratorText, XmRXmString,
	sizeof(XmString), Offset(_acc_text),
	XmRImmediate, (XtPointer)NULL
    },
    /* Things we override from Gadget */
    {
	XmNtraversalOn, XmCTraversalOn, XmRBoolean,
	sizeof(Boolean), XtOffsetOf(XmLabelGadgetRec, gadget.traversal_on),
	XmRImmediate, (XtPointer)False
    },
    {
	XmNhighlightThickness, XmCHighlightThickness, XmRHorizontalDimension,
   sizeof(Dimension), XtOffsetOf(XmLabelGadgetRec, gadget.highlight_thickness),
	XmRImmediate, (XtPointer)0
    }
};

static XmSyntheticResource syn_resources[] =
{
    {
	XmNlabelString,
	sizeof(XmString), Offset(_label),
	_XmExportLabelString, NULL
    },
    {
	XmNaccelerator,
	sizeof(String), Offset(accelerator),
	_XmExportString, NULL
    },
    {
	XmNacceleratorText,
	sizeof(XmString), Offset(_acc_text),
	_XmExportLabelString, NULL
    },
    {
	XmNmnemonicCharSet,
	sizeof(String), Offset(mnemonicCharset),
	_XmExportString, NULL
    }
};

/* *INDENT-OFF* */
static XmBaseClassExtRec _XmLabelGRectClassExtRec = {
    /* next_extension            */ NULL,
    /* record_type               */ NULLQUARK,                             
    /* version                   */ XmBaseClassExtVersion,
    /* size                      */ sizeof(XmBaseClassExtRec),
    /* initialize_prehook        */ XmInheritInitializePrehook /*initialize_prehook*/,
    /* set_values_prehook        */ set_values_prehook,
    /* initialize_posthook       */ initialize_posthook,
    /* set_values_posthook       */ set_values_posthook,
    /* secondary_object_class    */ (WidgetClass)&xmLabelGCacheObjClassRec,
    /* secondary_object_create   */ secondary_object_create,
    /* get_secondary_resources   */ get_sec_res_data,
    /* fast_subclass             */ { 0 },
    /* get_values_prehook        */ get_values_prehook,
    /* get_values_posthook       */ get_values_posthook,
    /* class_part_init_prehook   */ NULL,
    /* class_part_init_posthook  */ NULL,
    /* ext_resources             */ NULL,
    /* compiled_ext_resources    */ NULL,
    /* num_ext_resources         */ 0,
    /* use_sub_resources         */ False,
    /* widget_navigable          */ XmInheritWidgetNavigable,
    /* focus_change              */ XmInheritFocusChange,
    /* wrapper_data              */ NULL
};

static XmCacheClassPart cache_part = {
    /* cache head part */
    {
	/* next		*/ NULL,
	/* prev		*/ NULL,
	/* ref_count	*/ 0
    },
    _XmCacheCopy,
    _XmCacheDelete,
    _XmLabelCacheCompare
};

static XmGadgetClassExtRec _XmLabelGadgetClassExtRec = {
    /* next_extension            */ NULL,
    /* record_type               */ NULLQUARK,
    /* version                   */ XmGadgetClassExtVersion,
    /* size                      */ sizeof(XmGadgetClassExtRec),
    /* widget_baseline           */ _XmLabelGetBaselines,
    /* widget_display_rect       */ _XmLabelGetDisplayRect,
};

XmLabelGadgetClassRec xmLabelGadgetClassRec = {
    /* RectObj class part */
    {
	/* superclass            */ (WidgetClass) &xmGadgetClassRec,
	/* class_name            */ "XmLabelGadget",
	/* widget_size           */ sizeof(XmLabelGadgetRec),
	/* class_initialize      */ class_initialize,
	/* class_part_initialize */ class_part_initialize,
	/* class_inited          */ False,
	/* initialize            */ initialize,
	/* initialize_hook       */ NULL,
	/* realize               */ NULL,
	/* actions               */ NULL,
	/* num_actions           */ 0,
	/* resources             */ resources,
	/* num_resources         */ XtNumber(resources),
	/* xrm_class             */ NULLQUARK,
	/* compress_motion       */ True /*False*/,
	/* compress_exposure     */ XtExposeCompressMaximal /*XtExposeNoCompress*/,
	/* compress_enterleave   */ True /*False*/,
	/* visible_interest      */ False,
	/* destroy               */ destroy,
	/* resize                */ resize,
	/* expose                */ expose,
	/* set_values            */ set_values,
	/* set_values_hook       */ NULL,
	/* set_values_almost     */ XtInheritSetValuesAlmost, /* FIX ME */
	/* get_values_hook       */ NULL /*get_values_hook*/,
	/* accept_focus          */ NULL,
	/* version               */ XtVersion,
	/* callback offsets      */ NULL,
	/* tm_table              */ NULL,
	/* query_geometry        */ query_geometry,
	/* display_accelerator   */ NULL,
	/* extension             */ (XtPointer)&_XmLabelGRectClassExtRec
    },
    /* XmGadget part */
    {
	/* border_highlight   */ XmInheritBorderHighlight, 
	/* border_unhighlight */ XmInheritBorderUnhighlight,
	/* arm_and_activate   */ NULL,
	/* input_dispatch     */ input_dispatch,
	/* visual_change      */ XmInheritVisualChange, /* FIX ME */
	/* syn_resources      */ syn_resources,
	/* num_syn_resources  */ XtNumber(syn_resources),
	/* cache_part         */ &cache_part,
	/* extension          */ (XtPointer)&_XmLabelGadgetClassExtRec
    },
    /* XmLabelGadget part */
    {
        /* setOverrideCallback */ NULL, /* FIX ME */
        /* menuProcs           */ NULL,
	/* extension           */ NULL
    },
};
/* *INDENT-ON* */


WidgetClass xmLabelGadgetClass = (WidgetClass)&xmLabelGadgetClassRec;

extern XmFontList _XmFontListCreateDefault(Display *);

/******************************** CACHE PART *********************************/
static void
secondary_object_create(Widget request,
			Widget new_w,
			ArgList args,
			Cardinal *num_args)
{
    XmBaseClassExt *bce;
    XtPointer nsec, rsec;
    XmWidgetExtData ed;
    int size;

    DEBUGOUT(XdbDebug(__FILE__, new_w,
		      "LabelGCacheRec %s being initialized.\n", XtName(new_w)));

    bce = _XmGetBaseClassExtPtr(XtClass(new_w), XmQmotif);

    size = (*bce)->secondaryObjectClass->core_class.widget_size;
    nsec = _XmExtObjAlloc(size);
    rsec = _XmExtObjAlloc(size);

    ((XmExtRec *)nsec)->object.self = (Widget)nsec;
    ((XmExtRec *)nsec)->object.widget_class = (*bce)->secondaryObjectClass;
    ((XmExtRec *)nsec)->object.parent = XtParent(new_w);
    ((XmExtRec *)nsec)->object.xrm_name = new_w->core.xrm_name;
    ((XmExtRec *)nsec)->object.being_destroyed = False;
    ((XmExtRec *)nsec)->object.destroy_callbacks = NULL;
    ((XmExtRec *)nsec)->object.constraints = NULL;

    ExtObj_LogicalParent(nsec) = new_w;
    ExtObj_ExtensionType(nsec) = XmCACHE_EXTENSION;

    XtGetSubresources(new_w, nsec, NULL, NULL,
		      (*bce)->secondaryObjectClass->core_class.resources,
		      (*bce)->secondaryObjectClass->core_class.num_resources,
		      args, *num_args);

    ed = (XmWidgetExtData)XtMalloc(sizeof(XmWidgetExtDataRec));
    ed->widget = (Widget)nsec;
    ed->reqWidget = (Widget)rsec;

    bcopy(nsec, rsec, size);
    ((XmExtRec *)rsec)->object.self = (Widget)rsec;

    _XmPushWidgetExtData(new_w, ed, XmCACHE_EXTENSION);

    LabG_Cache(new_w) = &(((XmLabelGCacheObject)nsec)->label_cache);
    LabG_Cache(request) = &(((XmLabelGCacheObject)rsec)->label_cache);
}

int
_XmLabelCacheCompare(XtPointer A, XtPointer B)
{
    return !bcmp(((XmLabelGCacheObjPart *)A),
		 ((XmLabelGCacheObjPart *)B),
		 sizeof(XmLabelGCacheObjPart));
}

void
_XmCalcLabelGDimensions(Widget w)
{
    Dimension cw, ch, width, height;

    if (LabG_IsText(w))
    {
	if (_XmStringIsXmString((XmString)LabG_Label(w)))
	{
	    DEBUGOUT(XdbDebug(__FILE__, w,
		"_XmCalcLabelGDimensions: convert LabG_Label to _XmString\n"));
	    LabG_Label(w) = _XmStringCreate((XmString)LabG_Label(w));
	}

	_XmStringExtent(LabG_Font(w),
			LabG_Label(w),
			&cw,
			&ch);
    }
    else /* pixmap */
    {
	_XmLabelGetPixmapSize(w, LabG_Pixmap(w), &cw, &ch);
    }

    width = (LabG_Highlight(w)
	     + LabG_Shadow(w)
	     + LabG_MarginLeft(w)
	     + LabG_MarginWidth(w)
	     + cw
	     + LabG_MarginWidth(w)
	     + LabG_MarginRight(w)
	     + LabG_Shadow(w)
	     + LabG_Highlight(w));

    height = (LabG_Highlight(w)
	      + LabG_Shadow(w)
	      + LabG_MarginTop(w)
	      + LabG_MarginHeight(w)
	      + ch
	      + LabG_MarginHeight(w)
	      + LabG_MarginBottom(w)
	      + LabG_Shadow(w)
	      + LabG_Highlight(w));

    XtWidth(w) = width;
    XtHeight(w) = height;
}

void
_XmReCacheLabG(Widget w)
{
    XmWidgetExtData ext;

    _XmPopWidgetExtData(w, &ext, XmCACHE_EXTENSION);

    LabG_Cache(w) = (XmLabelGCacheObjPart *)
	_XmCachePart(LabG_ClassCachePart(NULL),
		     (XtPointer)LabG_Cache(w),
		     sizeof(XmLabelGCacheObjPart));

    _XmExtObjFree((XtPointer)ext->widget);

    XtFree((char *)ext);
}

void
_XmAssignLabG_MarginHeight(XmLabelGadget lw, Dimension value)
{
    XmBaseClassExt *bce;
    XmWidgetExtData ed;
    int size;
    XtPointer nsec;

    if ((ed = _XmGetWidgetExtData((Widget)lw, XmCACHE_EXTENSION)) != NULL)
    {
	LabG_MarginHeight(lw) = value;
    }

    bce = _XmGetBaseClassExtPtr(XtClass((Widget)lw), XmQmotif);
    size = (*bce)->secondaryObjectClass->core_class.widget_size;

    nsec = _XmExtObjAlloc(size);

    ((XmExtRec *)nsec)->object.self = (Widget)nsec;
    ((XmExtRec *)nsec)->object.widget_class = (*bce)->secondaryObjectClass;
    ((XmExtRec *)nsec)->object.parent = XtParent((Widget)lw);
    ((XmExtRec *)nsec)->object.xrm_name = ((Widget)lw)->core.xrm_name;
    ((XmExtRec *)nsec)->object.being_destroyed = False;
    ((XmExtRec *)nsec)->object.destroy_callbacks = NULL;
    ((XmExtRec *)nsec)->object.constraints = NULL;

    ExtObj_LogicalParent(nsec) = (Widget)lw;
    ExtObj_ExtensionType(nsec) = XmCACHE_EXTENSION;

    bcopy(LabG_Cache((Widget)lw),
	  &((XmLabelGCacheObject)nsec)->label_cache,
	  sizeof(XmLabelGCacheObjPart));

    ed = (XmWidgetExtData)XtMalloc(sizeof(XmWidgetExtDataRec));
    ed->widget = (Widget)nsec;

    _XmPushWidgetExtData((Widget)lw, ed, XmCACHE_EXTENSION);

    _XmCacheDelete((XtPointer)LabG_Cache(lw));

    LabG_Cache((Widget)lw) = &(((XmLabelGCacheObject)nsec)->label_cache);

    LabG_MarginHeight(lw) = value;
}

void
_XmAssignLabG_MarginWidth(XmLabelGadget lw, Dimension value)
{
    XmBaseClassExt *bce;
    XmWidgetExtData ed;
    int size;
    XtPointer nsec;

    if ((ed = _XmGetWidgetExtData((Widget)lw, XmCACHE_EXTENSION)) != NULL)
    {
	LabG_MarginWidth(lw) = value;
    }

    bce = _XmGetBaseClassExtPtr(XtClass((Widget)lw), XmQmotif);
    size = (*bce)->secondaryObjectClass->core_class.widget_size;

    nsec = _XmExtObjAlloc(size);

    ((XmExtRec *)nsec)->object.self = (Widget)nsec;
    ((XmExtRec *)nsec)->object.widget_class = (*bce)->secondaryObjectClass;
    ((XmExtRec *)nsec)->object.parent = XtParent((Widget)lw);
    ((XmExtRec *)nsec)->object.xrm_name = ((Widget)lw)->core.xrm_name;
    ((XmExtRec *)nsec)->object.being_destroyed = False;
    ((XmExtRec *)nsec)->object.destroy_callbacks = NULL;
    ((XmExtRec *)nsec)->object.constraints = NULL;

    ExtObj_LogicalParent(nsec) = (Widget)lw;
    ExtObj_ExtensionType(nsec) = XmCACHE_EXTENSION;

    bcopy(LabG_Cache((Widget)lw),
	  &((XmLabelGCacheObject)nsec)->label_cache,
	  sizeof(XmLabelGCacheObjPart));

    ed = (XmWidgetExtData)XtMalloc(sizeof(XmWidgetExtDataRec));
    ed->widget = (Widget)nsec;

    _XmPushWidgetExtData((Widget)lw, ed, XmCACHE_EXTENSION);

    LabG_Cache((Widget)lw) = &(((XmLabelGCacheObject)nsec)->label_cache);

    LabG_MarginWidth(lw) = value;
}

void
_XmAssignLabG_MarginLeft(XmLabelGadget lw, Dimension value)
{
    XmBaseClassExt *bce;
    XmWidgetExtData ed;
    int size;
    XtPointer nsec;

    if ((ed = _XmGetWidgetExtData((Widget)lw, XmCACHE_EXTENSION)) != NULL)
    {
	LabG_MarginLeft(lw) = value;
    }

    bce = _XmGetBaseClassExtPtr(XtClass((Widget)lw), XmQmotif);
    size = (*bce)->secondaryObjectClass->core_class.widget_size;

    nsec = _XmExtObjAlloc(size);

    ((XmExtRec *)nsec)->object.self = (Widget)nsec;
    ((XmExtRec *)nsec)->object.widget_class = (*bce)->secondaryObjectClass;
    ((XmExtRec *)nsec)->object.parent = XtParent((Widget)lw);
    ((XmExtRec *)nsec)->object.xrm_name = ((Widget)lw)->core.xrm_name;
    ((XmExtRec *)nsec)->object.being_destroyed = False;
    ((XmExtRec *)nsec)->object.destroy_callbacks = NULL;
    ((XmExtRec *)nsec)->object.constraints = NULL;

    ExtObj_LogicalParent(nsec) = (Widget)lw;
    ExtObj_ExtensionType(nsec) = XmCACHE_EXTENSION;

    bcopy(LabG_Cache((Widget)lw),
	  &((XmLabelGCacheObject)nsec)->label_cache,
	  sizeof(XmLabelGCacheObjPart));

    ed = (XmWidgetExtData)XtMalloc(sizeof(XmWidgetExtDataRec));
    ed->widget = (Widget)nsec;

    _XmPushWidgetExtData((Widget)lw, ed, XmCACHE_EXTENSION);

    LabG_Cache((Widget)lw) = &(((XmLabelGCacheObject)nsec)->label_cache);

    LabG_MarginLeft(lw) = value;
}

void
_XmAssignLabG_MarginRight(XmLabelGadget lw, Dimension value)
{
    XmBaseClassExt *bce;
    XmWidgetExtData ed;
    int size;
    XtPointer nsec;

    if ((ed = _XmGetWidgetExtData((Widget)lw, XmCACHE_EXTENSION)) != NULL)
    {
	LabG_MarginRight(lw) = value;
    }

    bce = _XmGetBaseClassExtPtr(XtClass((Widget)lw), XmQmotif);
    size = (*bce)->secondaryObjectClass->core_class.widget_size;

    nsec = _XmExtObjAlloc(size);

    ((XmExtRec *)nsec)->object.self = (Widget)nsec;
    ((XmExtRec *)nsec)->object.widget_class = (*bce)->secondaryObjectClass;
    ((XmExtRec *)nsec)->object.parent = XtParent((Widget)lw);
    ((XmExtRec *)nsec)->object.xrm_name = ((Widget)lw)->core.xrm_name;
    ((XmExtRec *)nsec)->object.being_destroyed = False;
    ((XmExtRec *)nsec)->object.destroy_callbacks = NULL;
    ((XmExtRec *)nsec)->object.constraints = NULL;

    ExtObj_LogicalParent(nsec) = (Widget)lw;
    ExtObj_ExtensionType(nsec) = XmCACHE_EXTENSION;

    bcopy(LabG_Cache((Widget)lw),
	  &((XmLabelGCacheObject)nsec)->label_cache,
	  sizeof(XmLabelGCacheObjPart));

    ed = (XmWidgetExtData)XtMalloc(sizeof(XmWidgetExtDataRec));
    ed->widget = (Widget)nsec;

    _XmPushWidgetExtData((Widget)lw, ed, XmCACHE_EXTENSION);

    LabG_Cache((Widget)lw) = &(((XmLabelGCacheObject)nsec)->label_cache);

    LabG_MarginRight(lw) = value;
}

void
_XmAssignLabG_MarginTop(XmLabelGadget lw, Dimension value)
{
    XmBaseClassExt *bce;
    XmWidgetExtData ed;
    int size;
    XtPointer nsec;

    if ((ed = _XmGetWidgetExtData((Widget)lw, XmCACHE_EXTENSION)) != NULL)
    {
	LabG_MarginTop(lw) = value;
    }

    bce = _XmGetBaseClassExtPtr(XtClass((Widget)lw), XmQmotif);
    size = (*bce)->secondaryObjectClass->core_class.widget_size;

    nsec = _XmExtObjAlloc(size);

    ((XmExtRec *)nsec)->object.self = (Widget)nsec;
    ((XmExtRec *)nsec)->object.widget_class = (*bce)->secondaryObjectClass;
    ((XmExtRec *)nsec)->object.parent = XtParent((Widget)lw);
    ((XmExtRec *)nsec)->object.xrm_name = ((Widget)lw)->core.xrm_name;
    ((XmExtRec *)nsec)->object.being_destroyed = False;
    ((XmExtRec *)nsec)->object.destroy_callbacks = NULL;
    ((XmExtRec *)nsec)->object.constraints = NULL;

    ExtObj_LogicalParent(nsec) = (Widget)lw;
    ExtObj_ExtensionType(nsec) = XmCACHE_EXTENSION;

    bcopy(LabG_Cache((Widget)lw),
	  &((XmLabelGCacheObject)nsec)->label_cache,
	  sizeof(XmLabelGCacheObjPart));

    ed = (XmWidgetExtData)XtMalloc(sizeof(XmWidgetExtDataRec));
    ed->widget = (Widget)nsec;

    _XmPushWidgetExtData((Widget)lw, ed, XmCACHE_EXTENSION);

    LabG_Cache((Widget)lw) = &(((XmLabelGCacheObject)nsec)->label_cache);

    LabG_MarginTop(lw) = value;
}

void
_XmAssignLabG_MarginBottom(XmLabelGadget lw, Dimension value)
{
    XmBaseClassExt *bce;
    XmWidgetExtData ed;
    int size;
    XtPointer nsec;

    if ((ed = _XmGetWidgetExtData((Widget)lw, XmCACHE_EXTENSION)) != NULL)
    {
	LabG_MarginBottom(lw) = value;
    }

    bce = _XmGetBaseClassExtPtr(XtClass((Widget)lw), XmQmotif);
    size = (*bce)->secondaryObjectClass->core_class.widget_size;

    nsec = _XmExtObjAlloc(size);

    ((XmExtRec *)nsec)->object.self = (Widget)nsec;
    ((XmExtRec *)nsec)->object.widget_class = (*bce)->secondaryObjectClass;
    ((XmExtRec *)nsec)->object.parent = XtParent((Widget)lw);
    ((XmExtRec *)nsec)->object.xrm_name = ((Widget)lw)->core.xrm_name;
    ((XmExtRec *)nsec)->object.being_destroyed = False;
    ((XmExtRec *)nsec)->object.destroy_callbacks = NULL;
    ((XmExtRec *)nsec)->object.constraints = NULL;

    ExtObj_LogicalParent(nsec) = (Widget)lw;
    ExtObj_ExtensionType(nsec) = XmCACHE_EXTENSION;

    bcopy(LabG_Cache((Widget)lw),
	  &((XmLabelGCacheObject)nsec)->label_cache,
	  sizeof(XmLabelGCacheObjPart));

    ed = (XmWidgetExtData)XtMalloc(sizeof(XmWidgetExtDataRec));
    ed->widget = (Widget)nsec;

    _XmPushWidgetExtData((Widget)lw, ed, XmCACHE_EXTENSION);

    LabG_Cache((Widget)lw) = &(((XmLabelGCacheObject)nsec)->label_cache);

    LabG_MarginBottom(lw) = value;
}

static Boolean
drag_convert_proc(Widget w, Atom *selection,
		  Atom *target, Atom *type_return,
		  XtPointer *value_return,
		  unsigned long *length_return,
		  int *format_return)
{
    Atom COMPOUND_TEXT;
    Atom MOTIF_DROP;

    COMPOUND_TEXT = XmInternAtom(XtDisplay(w), _XA_COMPOUND_TEXT, False);
    MOTIF_DROP = XmInternAtom(XtDisplay(w), _XA_MOTIF_DROP, False);

    if (*selection != MOTIF_DROP)
    {
	return False;
    }

    DEBUGOUT(XdbDebug(__FILE__, w, "We're dealing with a motif drop\n"));
    return False;
}

static void
drag_drop_finish(Widget w, XtPointer client_data, XtPointer call_data)
{
}

void
_XmProcessDrag(Widget w, XEvent *event,
	       String *params, Cardinal *num_params)
{
    Atom export_target;
    Arg args[10];
    int n = 0;
    Widget dc;

    DEBUGOUT(XdbDebug(__FILE__, w, "Processing a drag-drop request\n"));

    if (LabG_IsPixmap(w))
    {
	export_target = XmInternAtom(XtDisplay(w),
				     _XA_PIXMAP,
				     False);
    }
    else
    {
	export_target = XmInternAtom(XtDisplay(w),
				     _XA_COMPOUND_TEXT,
				     False);
    }

    XtSetArg(args[n], XmNexportTargets, &export_target); n++;
    XtSetArg(args[n], XmNnumExportTargets, 1); n++;
    XtSetArg(args[n], XmNdragOperations, XmDROP_COPY); n++;
    XtSetArg(args[n], XmNconvertProc, drag_convert_proc); n++;
    XtSetArg(args[n], XmNclientData, w); n++;
    XtSetArg(args[n], XmNsourceCursorIcon,
	     _XmGetTextualDragIcon(XtParent(w))); n++;

    dc = XmDragStart(w, event, args, n);
    XtAddCallback(dc, XmNdragDropFinishCallback, drag_drop_finish, NULL);
}

/******************************* GADGET PART *********************************/
static void
class_initialize()
{
    /* don't let the nulls fool you.  look at the header file -- the arg
     * isn't used. */
    ClassCacheHead(LabG_ClassCachePart(NULL)).prev =
	&ClassCacheHead(LabG_ClassCachePart(NULL));
    ClassCacheHead(LabG_ClassCachePart(NULL)).next =
	&ClassCacheHead(LabG_ClassCachePart(NULL));

    _XmLabelGRectClassExtRec.record_type = XmQmotif;
}

static void
class_part_initialize(WidgetClass widget_class)
{
    XmLabelGadgetClass lc = (XmLabelGadgetClass)widget_class;
    XmLabelGadgetClass sc =
    (XmLabelGadgetClass)(widget_class->core_class.superclass);
    XmGadgetClassExt ext, *extptr, *sextptr;

    if (lc->label_class.menuProcs == XmInheritMenuProc)
    {
	lc->label_class.menuProcs =
	    sc->label_class.menuProcs;
    }

    extptr = (XmGadgetClassExt *)_XmGetClassExtensionPtr(
			    (XmGenericClassExt *)&(lc->gadget_class.extension),
							    NULLQUARK);
    sextptr = (XmGadgetClassExt *)_XmGetClassExtensionPtr(
			    (XmGenericClassExt *)&(sc->gadget_class.extension),
							     NULLQUARK);

    if (extptr == NULL || *extptr == NULL)
    {
	ext = (XmGadgetClassExt)XtNew(XmGadgetClassExtRec);
	if (ext != NULL)
	{
	    ext->next_extension = lc->gadget_class.extension;
	    ext->record_type = NULLQUARK;
	    ext->version = XmGadgetClassExtVersion;
	    ext->record_size = sizeof(XmGadgetClassExtRec);
	    lc->gadget_class.extension = (XtPointer)ext;
	}
    }
    else
	ext = *extptr;
    if (sextptr && *sextptr)
    {
	if (ext->widget_baseline == XmInheritBaselineProc)
	{
	    ext->widget_baseline = (*sextptr)->widget_baseline;
	}
	if (ext->widget_display_rect == XmInheritDisplayRectProc)
	{
	    ext->widget_display_rect = (*sextptr)->widget_display_rect;
	}
    }

    _XmFastSubclassInit(widget_class, XmLABEL_GADGET_BIT);
}

static void
CreateNormalGC(Widget w)
{
    XGCValues values;
    XtGCMask mask;

    mask = GCForeground | GCBackground | GCFillStyle | GCFunction |
	GCSubwindowMode | GCGraphicsExposures | GCPlaneMask;
    values.function = GXcopy;
    values.plane_mask = -1;
    values.subwindow_mode = ClipByChildren;
    values.graphics_exposures = False;
    values.foreground = XmParentForeground(w);
    values.background = XmParentBackground(w);
    values.fill_style = FillSolid;

    LabG_NormalGC(w) = XtGetGC(w, mask, &values);
}

static void
CreateInsensitiveGC(Widget w)
{
    XGCValues values;
    XtGCMask mask;

    mask = GCForeground | GCBackground | GCFillStyle | GCFunction | GCStipple |
	GCSubwindowMode | GCGraphicsExposures | GCPlaneMask |
	GCTileStipXOrigin | GCTileStipYOrigin;
    values.function = GXcopy;
    values.plane_mask = -1;
    values.subwindow_mode = ClipByChildren;
    values.graphics_exposures = False;
    values.foreground = XmParentForeground(w);
    values.background = XmParentBackground(w);
    values.fill_style = FillStippled;
    values.ts_x_origin = values.ts_y_origin = 0;

    if ((LabG_TextRect_x(w) & 1) ^ (LabG_TextRect_y(w) & 1))
    {
	values.stipple = XmGetPixmapByDepth(XtScreen(w),
					    XmODD_STIPPLE_IMAGE,
					    WhitePixelOfScreen(XtScreen(w)),
					    BlackPixelOfScreen(XtScreen(w)),
					    1);
    }
    else
    {
	values.stipple = XmGetPixmapByDepth(XtScreen(w),
					    XmEVEN_STIPPLE_IMAGE,
					    WhitePixelOfScreen(XtScreen(w)),
					    BlackPixelOfScreen(XtScreen(w)),
					    1);
    }

    LabG_InsensitiveGC(w) = XtGetGC(w, mask, &values);
}

#if 0
static void
initialize_prehook(Widget request, Widget new_w,
		   ArgList args, Cardinal *num_args)
{
    DEBUGOUT(XdbDebug(__FILE__, new_w, "LabelG InitializePrehook\n"));
}
#endif

static void
initialize_posthook(Widget request,
		    Widget new_w,
		    ArgList args,
		    Cardinal *num_args)
{
    XmWidgetExtData ext;

    DEBUGOUT(XdbDebug(__FILE__, new_w, "LabelG InitializePosthook\n"));

    /* don't let the null fool you */
    LabG_Cache(new_w) = (XmLabelGCacheObjPart *)
	_XmCachePart(LabG_ClassCachePart(NULL),
		     (XtPointer)LabG_Cache(new_w),
		     sizeof(XmLabelGCacheObjPart));

    _XmPopWidgetExtData(new_w, &ext, XmCACHE_EXTENSION);
    _XmExtObjFree((XtPointer)ext->widget);
    _XmExtObjFree((XtPointer)ext->reqWidget);
    XtFree((char *)ext);
}

static void
initialize(Widget request, Widget new_w,
	   ArgList args, Cardinal *num_args)
{
    DEBUGOUT(XdbDebug(__FILE__, new_w,
		      "LabelGadget initialize w,h before: %d %d\n",
		      XtWidth(new_w), XtHeight(new_w)));

    /* get the default fontlist if the label was created without one. */
    if (LabG_Font(new_w) == (XmFontList)XmUNSPECIFIED ||
	LabG_Font(new_w) == NULL)
    {
	LabG_Font(new_w) = _XmGetDefaultFontList(new_w, XmLABEL_FONTLIST);
    }
    /* if the user specified one, COPY it */
    else
    {
	LabG_Font(new_w) = XmFontListCopy(LabG_Font(new_w));
    }


    /* If the label was not initialized with the resource labelString set,
       use its name -- the follow _XmString code comes from MegaButton */
    if (LabG_Label(new_w) == (_XmString)XmUNSPECIFIED ||
	LabG_Label(new_w) == (_XmString)0)
    {				/* Shouldn't be necessary but is */
	XmString xmstring;

	xmstring = _XmOSGetLocalizedString((char *)NULL,
					   (Widget)new_w,
					   XmNlabelString,
					   XtName(new_w));

	LabG_Label(new_w) = _XmStringCreate(xmstring);
    }

    if (_XmStringIsXmString((XmString)LabG_Label(new_w)))
    {
	LabG_Label(new_w) = _XmStringCreate((XmString)LabG_Label(new_w));
    }

    if (LabG_AcceleratorText(new_w) != NULL)
    {
	LabG_AcceleratorText(new_w) =
	    _XmStringCreate((XmString)LabG_AcceleratorText(new_w));
    }
    else
    {
	LabG_AcceleratorText(new_w) =
	    _XmStringCreate(XmStringCreateLocalized(""));
    }

    /* if the parent is a row column, set the menu_type to
       it's type.  Otherwise, XmNONE  (Is this right?) FIX ME */

    if (XmIsRowColumn(XtParent(new_w)))
    {
	LabG_MenuType(new_w) = RC_Type(XtParent(new_w));
    }
    else
    {
	LabG_MenuType(new_w) = XmNONE;
    }

    /* have to check request since new_w may have been polluted by a
     * superclass 
     */
    if (XtWidth(request) == (Dimension)0)
    {
	XtWidth(new_w) = 0;
    }
    if (XtHeight(request) == (Dimension)0)
    {
	XtHeight(new_w) = 0;
    }

    _XmCalcLabelGDimensions(new_w);
    resize(new_w);

    /*
     * the user might have wanted something.  Change it back, if so
     */
    if (XtWidth(request) != 0)
    {
	XtWidth(new_w) = XtWidth(request);
    }
    if (XtHeight(request) != 0)
    {
	XtHeight(new_w) = XtHeight(request);
    }

    /* surge protection */
    if (XtWidth(new_w) == 0)
    {
	XtWidth(new_w) = 1;
    }
    if (XtHeight(new_w) == 0)
    {
	XtHeight(new_w) = 1;
    }

    CreateNormalGC(new_w);
    CreateInsensitiveGC(new_w);

    /* Force the traversal and highlight on enter resources if
       in an popup, pulldown, and option menus */

    if (LabG_MenuType(new_w) == XmMENU_POPUP ||
	LabG_MenuType(new_w) == XmMENU_PULLDOWN ||
	LabG_MenuType(new_w) == XmMENU_OPTION)
    {
#if 0
MLM: WHY TRAVERSAL?
	G_TraversalOn(new_w) = False;
#endif
	G_HighlightOnEnter(new_w) = False;
    }
    LabG_SkipCallback(new_w) = False;

    if (!XtIsSubclass(XtParent(new_w), xmManagerWidgetClass))
    {
	_XmError(new_w, "parent should be manager.");
    }

    if (LabG_MnemonicCharset(new_w) != NULL)
    {
	LabG_MnemonicCharset(new_w) = XtNewString(LabG_MnemonicCharset(new_w));
    }
    else
    {
	LabG_MnemonicCharset(new_w) = XtNewString("");
    }

    if (_XmStringIsXmString((XmString)LabG_Accelerator(new_w)))
    {
	XmStringGetLtoR((XmString)LabG_Accelerator(new_w),
			XmFONTLIST_DEFAULT_TAG,
			&LabG_Accelerator(new_w));
    }

    if (LabG_Accelerator(new_w))
    {
	LabG_Accelerator(new_w) = XtNewString(LabG_Accelerator(new_w));
	_XmManagerInstallAccelerator(XtParent(new_w), new_w,
				     LabG_Accelerator(new_w));
    }
    if (LabG_Mnemonic(new_w))
    {
	_XmManagerInstallMnemonic(XtParent(new_w), new_w,
				  LabG_Mnemonic(new_w));
    }

    G_EventMask(new_w) = XmBDRAG_EVENT | XmHELP_EVENT;
}

static void
destroy(Widget w)
{
    XtReleaseGC(w, LabG_NormalGC(w));
    XtReleaseGC(w, LabG_InsensitiveGC(w));
    _XmManagerUninstallAccelerator(XtParent(w), w);
    _XmManagerUninstallMnemonic(XtParent(w), w);

    _XmCacheDelete((XtPointer)LabG_Cache(w));
}

static void
resize(Widget w)
{
    Dimension width, height;
    Dimension pix_width, pix_height;
    Boolean showAcc;
    unsigned char beforex, beforey, afterx, aftery;

    /* NB. For gadgets, the TextRect is relative to the XtX and XtY
       positions, as the Xt[X|Y] and border_widths are added onto
       them before the text is drawn. */

    if (!XmIsLabelGadget(w))
    {
	return;
    }

    beforex = LabG_TextRect_x(w) & 1;
    beforey = LabG_TextRect_y(w) & 1;

    showAcc = _XmLabelShowsAccelerators(w);

    _XmLabelAccTextSize(w);

    /* set the label's size so the pixmap/string fits */
    if (LabG_IsText(w))
    {
	_XmStringExtent(LabG_Font(w),
			LabG_Label(w),
			&width,
			&height);
    }
    else
	/* LabG_IsPixmap(w) */
    {
	_XmLabelGetPixmapSize(w, LabG_Pixmap(w), &pix_width, &pix_height);
	width = pix_width;
	height = pix_height;
    }

    LabG_TextRect_width(w) = width;
    LabG_TextRect_height(w) = height;

    switch (LabG_Alignment(w))
    {
    case XmALIGNMENT_END:
	LabG_TextRect_x(w) = (XtWidth(w)
			      - LabG_Highlight(w)
			      - LabG_Shadow(w)
			      - LabG_MarginWidth(w)
			      - LabG_MarginRight(w)
			      - LabG_TextRect_width(w));
	break;

    case XmALIGNMENT_BEGINNING:
	LabG_TextRect_x(w) = (LabG_Highlight(w)
			      + LabG_Shadow(w)
			      + LabG_MarginWidth(w)
			      + LabG_MarginLeft(w));
	break;

    case XmALIGNMENT_CENTER:
    default:
	LabG_TextRect_x(w) = (XtWidth(w) -
			      (LabG_MarginLeft(w) +
			       LabG_MarginRight(w)) -
			      width) / 2 + LabG_MarginLeft(w);
	break;
    }

    LabG_TextRect_y(w) = ((XtHeight(w) -
			   (LabG_MarginTop(w) +
			    LabG_MarginBottom(w)) -
			   height)) / 2 +
	LabG_MarginTop(w);

    if (showAcc)
    {
	LabG_AccTextRect(w).x = XtWidth(w) - LabG_MarginRight(w)
	    + LABELG_ACC_PAD / 2;
	LabG_AccTextRect(w).y = LabG_TextRect_y(w);
    }

    afterx = LabG_TextRect_x(w) & 1;
    aftery = LabG_TextRect_y(w) & 1;
    if (beforex ^ afterx || beforey ^ aftery)
    {
	XtReleaseGC(w, LabG_InsensitiveGC(w));

	CreateInsensitiveGC(w);
    }
}

static Boolean
set_values_prehook(Widget old, Widget request, Widget new_w,
		   ArgList args, Cardinal *num_args)
{
    XmBaseClassExt *bce;
    XmWidgetExtData ed;
    int size;
    XtPointer nsec, rsec;

    bce = _XmGetBaseClassExtPtr(XtClass(new_w), XmQmotif);
    size = (*bce)->secondaryObjectClass->core_class.widget_size;

    nsec = _XmExtObjAlloc(size);
    rsec = _XmExtObjAlloc(size);

    ((XmExtRec *)nsec)->object.self = (Widget)nsec;
    ((XmExtRec *)nsec)->object.widget_class = (*bce)->secondaryObjectClass;
    ((XmExtRec *)nsec)->object.parent = XtParent(new_w);
    ((XmExtRec *)nsec)->object.xrm_name = new_w->core.xrm_name;
    ((XmExtRec *)nsec)->object.being_destroyed = False;
    ((XmExtRec *)nsec)->object.destroy_callbacks = NULL;
    ((XmExtRec *)nsec)->object.constraints = NULL;

    ExtObj_LogicalParent(nsec) = new_w;
    ExtObj_ExtensionType(nsec) = XmCACHE_EXTENSION;

    bcopy(LabG_Cache(new_w),
	  &((XmLabelGCacheObject)nsec)->label_cache,
	  sizeof(XmLabelGCacheObjPart));

    ed = (XmWidgetExtData)XtMalloc(sizeof(XmWidgetExtDataRec));
    ed->widget = (Widget)nsec;
    ed->reqWidget = (Widget)rsec;

    _XmPushWidgetExtData(new_w, ed, XmCACHE_EXTENSION);

    _XmGadgetImportSecondaryArgs(new_w, args, num_args);

    XtSetSubvalues((XtPointer)nsec,
		   (*bce)->secondaryObjectClass->core_class.resources,
		   (*bce)->secondaryObjectClass->core_class.num_resources,
		   args, *num_args);

    bcopy(nsec, rsec, size);
    ((XmExtRec *)rsec)->object.self = (Widget)rsec;

    LabG_Cache(new_w) = &(((XmLabelGCacheObject)nsec)->label_cache);
    LabG_Cache(request) = &(((XmLabelGCacheObject)rsec)->label_cache);

    _XmExtImportArgs((Widget)nsec, args, num_args);

    return False;
}

static Boolean
set_values_posthook(Widget old, Widget request, Widget new_w,
		    ArgList args, Cardinal *num_args)
{
    XmWidgetExtData ext;

    if (!_XmLabelCacheCompare((XtPointer)LabG_Cache(new_w),
			      (XtPointer)LabG_Cache(old)))
    {

	_XmCacheDelete((XtPointer)LabG_Cache(old));

	LabG_Cache(new_w) = (XmLabelGCacheObjPart *)
	    _XmCachePart(LabG_ClassCachePart(NULL),
			 (XtPointer)LabG_Cache(new_w),
			 sizeof(XmLabelGCacheObjPart));
    }
    else
    {
	LabG_Cache(new_w) = LabG_Cache(old);
    }

    _XmPopWidgetExtData(new_w, &ext, XmCACHE_EXTENSION);

    _XmExtObjFree((XtPointer)ext->widget);
    _XmExtObjFree((XtPointer)ext->reqWidget);

    XtFree((char *)ext);

    return False;
}

/*
 * Manipulated to have the layout algorithms be called only once per call to
 * set_values, instead of three or four times... Danny 28/8/96
 */
static Boolean
set_values(Widget old, Widget request, Widget new_w,
	   ArgList args, Cardinal *num_args)
{
    Boolean refresh_needed = False, relayout_needed = False;

    DEBUGOUT(XdbDebug(__FILE__, new_w, "LabelGadget SetValues %d %d\n",
		      LabG_MarginRight(new_w), LabG_MarginRight(old)));

    if (XtSensitive(old) != XtSensitive(new_w))
    {
    	refresh_needed = True;
    }
    /* This is a Primitive resource but we have the GC's for it... */
    if (XmParentForeground(new_w) != XmParentForeground(old))
    {
	XtReleaseGC(new_w, LabG_NormalGC(new_w));
	XtReleaseGC(new_w, LabG_InsensitiveGC(new_w));

	CreateNormalGC(new_w);
	CreateInsensitiveGC(new_w);

	refresh_needed = True;
    }

    if (LabG_AcceleratorText(new_w) != LabG_AcceleratorText(old))
    {
	LabG_AcceleratorText(new_w) =
	    _XmStringCreate((XmString)LabG_AcceleratorText(new_w));

	_XmStringFree(LabG_AcceleratorText(old));

	if (LabG_RecomputeSize(new_w))
	{
	    LabG_AccTextRect(new_w).width = LabG_AccTextRect(new_w).height = 0;

	    if (_XmLabelShowsAccelerators(new_w))
	    {
		Dimension width, height;

		_XmStringExtent(LabG_Font(new_w), LabG_AcceleratorText(new_w),
				&width, &height);

		LabG_AccTextRect(new_w).height = height;
		LabG_AccTextRect(new_w).width = width;

		if (LabG_MarginRight(new_w) <
		    LabG_AccTextRect(new_w).width + LABELG_ACC_PAD)
		{
		    LabG_MarginRight(new_w) =
			LabG_AccTextRect(new_w).width + LABELG_ACC_PAD;

		    DEBUGOUT(XdbDebug(__FILE__, new_w,
				      "_XmLabelAccTextSize: set rmargin %d\n",
				      LabG_MarginRight(new_w)));
		}
	    }

	    relayout_needed = True;
	}
	else
	{
	    refresh_needed = True;
	}
    }
    if (LabG_MnemonicCharset(new_w) != LabG_MnemonicCharset(old))
    {
	LabG_MnemonicCharset(new_w) = XtNewString(LabG_MnemonicCharset(new_w));

	XtFree(LabG_MnemonicCharset(old));

	refresh_needed = True;
    }

    /* if labelString is still NULL, it was set that way by the
     * user: NULL labelStrings get the widget name
     */
    if (LabG_Label(new_w) == NULL)
    {
	LabG_Label(new_w) =
	    _XmStringCreate(XmStringCreateSimple(XtName(new_w)));
	if (LabG_RecomputeSize(new_w))
	{
	    relayout_needed = True;
	}
	else
	{
	    refresh_needed = True;
	}
    }
    /*
     * The "else" was inserted here to make sure we don't do
     * _XmStringCreate twice
     */
    else if (LabG_Label(new_w) != LabG_Label(old))
    {
	if (_XmStringIsXmString((XmString)LabG_Label(new_w)))
	{
	    LabG_Label(new_w) = _XmStringCreate((XmString)LabG_Label(new_w));
	}

	if (LabG_Label(old))
	{
	    _XmStringFree(LabG_Label(old));
	}

	if (LabG_RecomputeSize(new_w))
	{
	    relayout_needed = True;
	}
	else
	{
	    refresh_needed = True;
	}
    }

    if (LabG_Alignment(new_w) != LabG_Alignment(old))
    {
	refresh_needed = True;
    }

    if (LabG_Font(new_w) && LabG_Font(new_w) != (XmFontList)XmUNSPECIFIED &&
	LabG_Font(new_w) != LabG_Font(old))
    {
	XmFontListFree(LabG_Font(old));
	LabG_Font(new_w) = XmFontListCopy(LabG_Font(new_w));

	if (LabG_RecomputeSize(new_w))
	{
	    relayout_needed = True;
	}
	else
	{
	    refresh_needed = True;
	}
    }

    if (LabG_MarginTop(new_w) != LabG_MarginTop(old)
	|| LabG_MarginBottom(new_w) != LabG_MarginBottom(old)
	|| LabG_MarginLeft(new_w) != LabG_MarginLeft(old)
	|| LabG_MarginRight(new_w) != LabG_MarginRight(old)
	|| LabG_MarginWidth(new_w) != LabG_MarginWidth(old)
	|| LabG_MarginHeight(new_w) != LabG_MarginHeight(old)
	|| LabG_Mnemonic(new_w) != LabG_Mnemonic(old)
	|| LabG_StringDirection(new_w) != LabG_StringDirection(old))
    {
	if (LabG_RecomputeSize(new_w))
	{
	    relayout_needed = True;
	}
	else
	{
	    refresh_needed = True;
	}
    }

    /* check for change in insensitive pixmap */
    if ((LabG_PixmapInsensitive(new_w) != LabG_PixmapInsensitive(old))
	&& !XtSensitive(new_w) && LabG_IsPixmap(new_w))
    {
	if (LabG_RecomputeSize(new_w))
	{
	    relayout_needed = True;
	}
	else
	{
	    refresh_needed = True;
	}
    }
    /* check for change in pixmap */
    if (LabG_Pixmap(new_w) != LabG_Pixmap(old))
    {
	/* if changed pixmap to UNSPECIFIED, automatically configure to a
	 * string
	 */
	if (LabG_IsPixmap(new_w)
	    && LabG_Pixmap(new_w) == (Pixmap)XmUNSPECIFIED_PIXMAP)
	{
	    LabG_LabelType(new_w) = XmSTRING;
	}

	if (LabG_RecomputeSize(new_w))
	{
	    relayout_needed = True;
	}
	else
	{
	    refresh_needed = True;
	}
    }

    /* did the label change types? */
    if (LabG_LabelType(new_w) != LabG_LabelType(old))
    {
	if (LabG_RecomputeSize(new_w))
	{
	    relayout_needed = True;
	}
	else
	{
	    refresh_needed = True;
	}
    }

    if (LabG_Accelerator(new_w) != LabG_Accelerator(old))
    {

	if (_XmStringIsXmString((XmString)LabG_Accelerator(new_w)))
	{
	    XmStringGetLtoR((XmString)LabG_Accelerator(new_w),
			    XmFONTLIST_DEFAULT_TAG,
			    &LabG_Accelerator(new_w));
	}
	else if (LabG_Accelerator(new_w))
	{
	    LabG_Accelerator(new_w) = XtNewString(LabG_Accelerator(new_w));
	}
	_XmManagerUninstallAccelerator(XtParent(new_w), new_w);
	_XmManagerInstallAccelerator(XtParent(new_w), new_w,
				     LabG_Accelerator(new_w));

	if (LabG_RecomputeSize(new_w))
	{
	    relayout_needed = True;
	}
	else
	{
	    refresh_needed = True;
	}
    }
    if (LabG_Mnemonic(new_w) != LabG_Mnemonic(old))
    {
	_XmManagerUninstallMnemonic(XtParent(new_w), new_w);
	_XmManagerInstallMnemonic(XtParent(new_w), new_w, LabG_Mnemonic(new_w));

	if (LabG_RecomputeSize(new_w))
	{
	    relayout_needed = True;
	}
	else
	{
	    refresh_needed = True;
	}
    }

    if (XtWidth(new_w) == 0 || XtHeight(new_w) == 0)
    {
	relayout_needed = True;
    }

    if (relayout_needed)
    {
	if (LabG_RecomputeSize(new_w) && XtWidth(new_w) == XtWidth(old))
	{
	    XtWidth(new_w) = 0;
	}
	if (LabG_RecomputeSize(new_w) && XtHeight(new_w) == XtHeight(old))
	{
	    XtHeight(new_w) = 0;
	}

	_XmCalcLabelGDimensions(new_w);

	refresh_needed = True;
    }

    return refresh_needed;
}

static void
get_values_prehook(Widget new_w, ArgList args, Cardinal *num_args)
{
    XmBaseClassExt *bce;
    XmWidgetExtData ed;
    int size;
    XtPointer nsec;

    bce = _XmGetBaseClassExtPtr(XtClass(new_w), XmQmotif);
    size = (*bce)->secondaryObjectClass->core_class.widget_size;

    nsec = _XmExtObjAlloc(size);

    bcopy(LabG_Cache(new_w),
	  &((XmLabelGCacheObject)nsec)->label_cache,
	  sizeof(XmLabelGCacheObjPart));

    /*
     * don't do this and ResInd will blow up.
     */
    ((XmExtRec *)nsec)->object.self = (Widget)nsec;
    ((XmExtRec *)nsec)->object.widget_class = (*bce)->secondaryObjectClass;
    ((XmExtRec *)nsec)->object.parent = XtParent(new_w);
    ((XmExtRec *)nsec)->object.xrm_name = new_w->core.xrm_name;
    ((XmExtRec *)nsec)->object.being_destroyed = False;
    ((XmExtRec *)nsec)->object.destroy_callbacks = NULL;
    ((XmExtRec *)nsec)->object.constraints = NULL;

    ExtObj_LogicalParent(nsec) = new_w;
    ExtObj_ExtensionType(nsec) = XmCACHE_EXTENSION;

    ed = (XmWidgetExtData)XtMalloc(sizeof(XmWidgetExtDataRec));
    ed->widget = (Widget)nsec;

    _XmPushWidgetExtData(new_w, ed, XmCACHE_EXTENSION);

    XtGetSubvalues((XtPointer)nsec,
		   (*bce)->secondaryObjectClass->core_class.resources,
		   (*bce)->secondaryObjectClass->core_class.num_resources,
		   args, *num_args);

    _XmExtGetValuesHook((Widget)nsec, args, num_args);
}

static void
get_values_posthook(Widget new_w, ArgList args, Cardinal *num_args)
{
    XmWidgetExtData ext;

    _XmPopWidgetExtData(new_w, &ext, XmCACHE_EXTENSION);

    _XmExtObjFree((XtPointer)ext->widget);

    XtFree((char *)ext);
}

#if 0
static void
get_values_hook(Widget w, ArgList args, Cardinal *num_args)
{
    DEBUGOUT(XdbDebug(__FILE__, w, "LabelG: GetValuesHook\n"));
}
#endif

static void
expose(Widget w,
       XEvent *event,
       Region region)
{
    XRectangle cliprect;
    GC myGC;

    /*
     * I'm getting paranoid - Danny - see testXm/filesb/test3
     */
    if (!XtIsRealized(w))
    {
	return;
    }

    /* if the internals of the widget haven't been recomputed yet,
     * recompute them now (happens if resize isn't called after set_values)
     */
    resize(w);

    /* use the right GC */
    if (XtSensitive(w))
    {
	myGC = LabG_NormalGC(w);
    }
    else
    {
	myGC = LabG_InsensitiveGC(w);
    }

    /* Set a clip rectangle for the GC - ensure we don't overwrite shadows */
    /* the rectangle used to include MarginWidth and MarginHeight.  Leaving
     * those two out makes Xinvest and Xmcd look better */
    cliprect.x = XtX(w) + G_HighlightThickness(w) + G_ShadowThickness(w);
    cliprect.y = XtY(w) + G_HighlightThickness(w) + G_ShadowThickness(w);
    cliprect.width = XtWidth(w) -
	2 * (G_ShadowThickness(w) + G_HighlightThickness(w));
    cliprect.height = XtHeight(w) -
	2 * (G_ShadowThickness(w) + G_HighlightThickness(w));

    XSetClipRectangles(XtDisplay(w), myGC, 0, 0, &cliprect, 1, Unsorted);

    if (LabG_IsText(w))
    {
	if (_XmLabelShowsMnemonic(w) && LabG_Mnemonic(w))
	{
	    char m[2];

	    m[0] = LabG_Mnemonic(w);
	    m[1] = '\0';

	    _XmStringDrawMnemonic(XtDisplay(w), XtWindow(w),
				  LabG_Font(w), LabG_Label(w), myGC,
				  XtX(w) + LabG_TextRect_x(w),
				  XtY(w) + LabG_TextRect_y(w),
				  LabG_TextRect_width(w),
				  LabG_Alignment(w),
				  0,
				  NULL,
				  m, LabG_MnemonicCharset(w));
	}
	else
	{
	    _XmStringDraw(XtDisplayOfObject(w),
			  XtWindowOfObject(w),
			  LabG_Font(w),
			  LabG_Label(w),
			  myGC,
			  XtX(w) + LabG_TextRect_x(w),
			  XtY(w) + LabG_TextRect_y(w),
			  LabG_TextRect_width(w),
			  LabG_Alignment(w),
			  0,
			  NULL);
	}
	/* AcceleratorText */
	if (_XmLabelShowsAccelerators(w))
	{
	    DEBUGOUT(XdbDebug(__FILE__, w,
			      "LabelG wid %d ht %d, accelerator @ %d %d\n",
			      XtWidth(w), XtHeight(w),
	      XtX(w) + LabG_AccTextRect(w).x, XtY(w) + LabG_AccTextRect(w).y));

	    _XmStringDraw(XtDisplay(w),
			  XtWindow(w),
			  LabG_Font(w),
			  LabG_AcceleratorText(w),
			  myGC,
			  XtX(w) + LabG_AccTextRect(w).x,
			  XtY(w) + LabG_AccTextRect(w).y,
			  LabG_AccTextRect(w).width,
			  XmALIGNMENT_BEGINNING,
			  0,
			  NULL);
	}
	else
	{
	    DEBUGOUT(XdbDebug(__FILE__, w,
			      "LabelG wid %d ht %d, no accelerator\n",
			      XtWidth(w), XtHeight(w)));
	}
    }
    else if (XtSensitive(w) &&
	     LabG_Pixmap(w) != XmUNSPECIFIED_PIXMAP)
    {
	DEBUGOUT(XdbDebug(__FILE__, w,
			"XmLabelGadget %s XCopyArea Pixmap 0x%X on win 0x%X\n",
			  XtName(w), LabG_Pixmap(w), XtWindowOfObject(w)));

	XCopyArea(XtDisplay(w),
		  LabG_Pixmap(w),
		  XtWindow(w),
		  myGC,
		  0,
		  0,
		  LabG_TextRect_width(w),
		  LabG_TextRect_height(w),
		  XtX(w) + XtBorderWidth(w) + LabG_TextRect_x(w),
		  XtY(w) + XtBorderWidth(w) + LabG_TextRect_y(w));
    }
    else if (!XtSensitive(w) &&
	     LabG_PixmapInsensitive(w) != XmUNSPECIFIED_PIXMAP)
    {
	DEBUGOUT(XdbDebug(__FILE__, w,
			"XmLabelGadget %s XCopyArea Pixmap 0x%X on win 0x%X\n",
			  XtName(w), LabG_Pixmap(w), XtWindowOfObject(w)));

	XCopyArea(XtDisplay(w),
		  LabG_PixmapInsensitive(w),
		  XtWindow(w),
		  myGC,
		  0,
		  0,
		  LabG_TextRect_width(w),
		  LabG_TextRect_height(w),
		  XtX(w) + XtBorderWidth(w) + LabG_TextRect_x(w),
		  XtY(w) + XtBorderWidth(w) + LabG_TextRect_y(w));
    }

    XSetClipMask(XtDisplay(w), myGC, None);
}


static XtGeometryResult
query_geometry(Widget w, XtWidgetGeometry *proposed, XtWidgetGeometry *answer)
{
    XtWidgetGeometry a;		/* Standin for answer if NULL parameter */
    Dimension wd, ht;

#define	Wants(x)	(proposed->request_mode & x)

    wd = XtWidth(w);
    ht = XtHeight(w);
    /* rws 28 Feb 1997
     * Setting height and width to 0 will calculate the minimum
     * size of the label. If recompute is false we do not want to
     * do that. This helps form/test4 (and some of my own apps)
     * This, however requires a change to the initialize
     *
     * rws 22 Mar 1997
     * As Mitch suspects recompute size is only dealt with in set_values
     */

    if (proposed->request_mode & CWWidth)
    {
	XtWidth(w) = proposed->width;
    }
    if (proposed->request_mode & CWHeight)
    {
	XtHeight(w) = proposed->height;
    }

    if (!LabG_RecomputeSize(w))
    {
	a.width = XtWidth(w);
	a.height = XtHeight(w);
	a.request_mode = CWWidth | CWHeight;

	XtWidth(w) = wd;
	XtHeight(w) = ht;
	if ((proposed->request_mode & (CWWidth | CWHeight)) ==
	    (CWWidth | CWHeight) &&
	    proposed->width == answer->width &&
	    proposed->height == answer->height)
	{
	    return XtGeometryYes;
	}
	else if (answer->width == XtWidth(w) && answer->height == XtHeight(w))
	{
	    return XtGeometryNo;
	}
	else
	{
	    return XtGeometryAlmost;
	}
    }

    if (XmIsCascadeButtonGadget(w))
    {
	extern void _XmCBGCalcDimensions(Widget w);

	_XmCBGCalcDimensions(w);
    }
    else
    {
	_XmCalcLabelGDimensions(w);
    }

    a.width = XtWidth(w);
    a.height = XtHeight(w);
    a.request_mode = CWWidth | CWHeight;
    DEBUGOUT(XdbDebug(__FILE__, w,
		      "LabelGadget queried for size: reporting %d %d %08x\n",
		      XtWidth(w), XtHeight(w), answer));

    XtWidth(w) = wd;
    XtHeight(w) = ht;

    if (answer)
    {
	*answer = a;
    }

    if ((proposed->request_mode & (CWWidth | CWHeight)) ==
	(CWWidth | CWHeight) &&
	proposed->width >= answer->width && proposed->height >= answer->height)
    {
	return XtGeometryYes;
    }
    else if (answer->width == XtWidth(w) && answer->height == XtHeight(w))
    {
	return XtGeometryNo;
    }
    else
    {
	return XtGeometryAlmost;
    }
}

static Cardinal
get_sec_res_data(WidgetClass wc, XmSecondaryResourceData **data)
{
    /* FIX ME */

    return _XmSecondaryResourceData(&_XmLabelGRectClassExtRec,
				    data, NULL, NULL, NULL, NULL);
}

static void
input_dispatch(Widget gadget,
	       XEvent *event,
	       Mask event_mask)
{
    switch (event_mask)
    {
    case XmHELP_EVENT:
	DEBUGOUT(XdbDebug(__FILE__, gadget, "LabelGadget got help event\n"));
	break;

    case XmBDRAG_EVENT:
	DEBUGOUT(XdbDebug(__FILE__, gadget, "LabelGadget got bdrag event\n"));
	_XmProcessDrag(gadget, event, NULL, NULL);
	break;
    }
}

Widget
XmCreateLabelGadget(Widget parent, char *name,
		    Arg *arglist, Cardinal argcount)
{
    return XtCreateWidget(name, xmLabelGadgetClass, parent,
			  arglist, argcount);
}
