/*								-*- C++ -*-
 * $Id: UTL_error.cpp,v 1.3 1997-01-15 14:58:53+01 mho Exp $
 *
 * Purpose: error routines
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#include "wx.h"

#include <stdarg.h>

void wxDebugMsg(const char *fmt, ...)
{
    if (!wxAPP_DEBUGOUTPUT)
	return ;
    va_list ap;
    va_start(ap, fmt);
    vfprintf(stderr, fmt, ap); fflush(stderr);
    va_end(ap);
}

void wxError(const char *msg, const char *title)
{
    fprintf(stderr, "%s: %s\n", title?title:"???", msg?msg:"???");
}

void wxFatalError(const char *msg, const char *title)
{
    fprintf(stderr, "%s: %s\n", title?title:"???", msg?msg:"???");
    exit(1);
}
