\name{rat}
\title{Calculate a Rational Approximation by Continued Fractions}
\usage{
rat(x, leng=6, maxm=100, name="rational.so")
}
\arguments{
  \item{x}{numeric data object for which the rational approximation is
    needed.}
  \item{leng}{maximum length of the continued fraction used.}
  \item{maxm}{maximum partial denominator.  If any partial denominator
    exceeds \code{maxm} the continued fraction terminates at that point.}
  \item{name}{name of object file containing the dynamically loaded C
    function.}}
\value{
  list of two components, $a and $b, containing the numerators and the
  denominators of the rational approximations respectively.

  \code{rat()} can be viewed as providing a speculative way of removing
  roundoff error if the correct answer should be rational numbers with
  "small" denominators.
}
\seealso{
  \code{rational()} and \code{fractions()} which use \code{rat()}
}
\examples{
# solve() accuracy check using a small Hilbert Matrix
    x <- matrix(0,5,5); x <- 1/(row(x) + col(x) -1)
# confirm:
    rat(x)


    x1 <- solve(solve(x)); x2 <- rat(x1)
# compare:
    x-x1
# with:
    x-x2$num/x2$den
}
\keyword{rational}
% Converted by Sd2Rd version 0.2-a3.
