kruskal.test <- function(x, g)
{
  if (is.list(x)) {
    if (length(x) < 2)
      stop("x must be a list with at least 2 elements")
    DNAME <- deparse(substitute(x))
    x <- lapply(x, function(x) x <- x[is.finite(x)])
    k <- length(x)
    g <- as.factor(rep(1 : k, sapply(x, "length")))
    x <- unlist(x)
  }
  else {
    if (length(x) != length(g))
      stop("x and g must have the same length")
    DNAME <- paste(deparse(substitute(x)), "and", deparse(substitute(g)))
    if (!all(is.finite(g)))
      stop("all group levels must be finite")
    OK <- !is.na(x)
    x <- x[OK]
    g <- as.factor(g[OK])
    k <- nlevels(g)
    if (k < 2)
      stop("all observations are in the same group")
  }

  n <- length(x)
  if (n < 2)
    stop("not enough observations")
  r <- rank(x)
  TIES <- table(x)
  STATISTIC <- sum(tapply(r, g, "sum")^2 / tapply(r, g, "length"))
  STATISTIC <- ((12 * STATISTIC / (n * (n + 1)) - 3 * (n + 1)) /
		(1 - sum(TIES^3 - TIES) / (n^3 - n)))
  names(STATISTIC) <- "Kruskal-Wallis chi-square"
  PARAMETER <- k - 1
  names(PARAMETER) <- "df"

  RVAL <- list(statistic = STATISTIC,
	       parameter = PARAMETER,
	       p.value = 1 - pchisq(STATISTIC, PARAMETER),
	       method = "Kruskal-Wallis rank sum test",
	       data.name = DNAME)
  class(RVAL) <- "htest"
  return(RVAL)
}
