#include "defs.h"
#include "Garmin.h"
#include "Prefs.h"

#include <pwd.h>
#include <sys/time.h>



extern Frame   frame;
extern Display *display;
extern int     dsp_width, dsp_height;


Frame  PrefsFrame;
Panel  PrefsPanel, PrefsDatum, PrefsFormat, PrefsOffset, PrefsDevice;
Panel  PrefsApply, PrefsSave, PrefsCancel;
Panel  dat[6];
int    ListSelected;

struct PREFS gPrefs;


extern struct DATUM const gDatum[];
extern struct ELLIPSOID const gEllipsoid[];
extern short  nDatums;




void SetEllipsoid(int n);


char   prop_scratch[255];



/****************************************************************************/
/* Expend the filename.                                                     */
/****************************************************************************/
char *AbsolutFilename(ch)
char *ch;
{
  char           temp[255], temp1[255];
  char           *search;
  struct passwd  *pwdentry;
  if (ch[0] != '~') {
    sprintf(prop_scratch, "%s", ch);
    return(&prop_scratch[0]);
  }
  sprintf(temp, "%s", ch);
  if (ch[1] == '/') {
    sprintf(temp1, "%s%s", getenv("HOME"), &temp[1]);
    sprintf(temp, "%s", temp1);
  } else {
    sprintf(temp1, "%s", temp);
    search   = strchr(temp1, '/');
    *search  = (char) 0;
    pwdentry = getpwnam(&temp1[1]);
    search   = strchr(temp, '/');
    if (pwdentry != NULL) {
      sprintf(temp1, "%s%s", pwdentry->pw_dir, search);
      sprintf(temp, "%s", temp1);
    } else {
      temp[0] = (char) 0;
    }
  }
  sprintf(prop_scratch, "%s", temp);
  return (&prop_scratch[0]);
}


/****************************************************************************/
/* Analyzes a dataline and separate keyword and data.                       */
/****************************************************************************/
int AnalyzeLine(line, key, data)
char   line[255], key[255], data[255];
{
  int i;

  if (line[strlen(line) - 1] == '\n') line[strlen(line) - 1] = '\0';

  if (line[0] == '#') return (1 == 2);
  if (strlen(line) < 5) return (1 == 2);

  i = 0;
  while ((i <= strlen(line)) && (line[i] != ':'))
    i++;

  if (i >= strlen(line)) return (1 == 2);

  sprintf(key, "%s", line);
  key[i] = '\0';

  while (key[0] == ' ')  sprintf(key, "%s", &key[1]);
  while (key[0] == '\t') sprintf(key, "%s", &key[1]);

  if (strlen(key) != 4) return (1 == 2);

  sprintf(data, "%s", &line[i + 2]);

  return (1 == 1);
}





void SavePrefs()
{
  FILE     *preffp;

  preffp = fopen(AbsolutFilename(PrefFileName), "wt");
  if (preffp == (FILE *) 0) {
    Message("Can't write preferences in file '%s'", 
	    AbsolutFilename(PrefFileName));
  } else {
    fprintf(preffp, "# Properties file of gpstrans - do not edit this file\n");
    fprintf(preffp, "FMAT: %d\n", gPrefs.format);
    fprintf(preffp, "OFFS: %1.2f\n", gPrefs.offset);
    fprintf(preffp, "DATU: %d\n", gPrefs.datum);
    fprintf(preffp, "DEVI: %s\n", gPrefs.Device);
    fclose(preffp);
  }
}


void LoadPrefs()
{
  FILE     *preffp;
  char   Line[255], Keyword[255], Data[255];
  int    value;
  float  floatval;

  gPrefs.format = DMS;
  gPrefs.offset = +0.0;
  gPrefs.datum  = 100;
  sprintf(gPrefs.Device, "%s", DefaultServerDevice);

  preffp = fopen(AbsolutFilename(PrefFileName), "rt");
  if (preffp != (FILE *) 0) {

    fgets(Line, 255, preffp);
    while (!feof(preffp)) {
      
      if (AnalyzeLine(Line, Keyword, Data)) {

	if (!strcmp(Keyword, "FMAT")) {
	  sscanf(Data, "%d", &value);
	  gPrefs.format = value;
	} else
	if (!strcmp(Keyword, "OFFS")) {
	  sscanf(Data, "%f", &floatval);
	  gPrefs.offset = (double) floatval;
	} else
	if (!strcmp(Keyword, "DATU")) {
	  sscanf(Data, "%d", &value);
	  gPrefs.datum = value;
	} else
	if (!strcmp(Keyword, "DEVI")) {
	  sprintf(gPrefs.Device, "%s", Data);
	}
      }
      fgets(Line, 255, preffp);
    }
    fclose(preffp);
  }
}




    


void InitPrefs()
{

  LoadPrefs();

  xv_set(PrefsFormat, PANEL_VALUE, (int) gPrefs.format, NULL);
  xv_set(PrefsOffset, PANEL_VALUE, (int) gPrefs.offset, NULL);
  xv_set(PrefsDatum,  PANEL_LIST_SELECT, (int)gPrefs.datum, TRUE, NULL);
  xv_set(PrefsDevice, PANEL_VALUE, DefaultServerDevice, NULL);

  ListSelected = 100;

  SetEllipsoid(gPrefs.datum);
}



Panel PrefsMessage(int x, int y, int b, char *txt)
{
  if (b == 0) {
    return xv_create(PrefsPanel,         PANEL_MESSAGE,
	      XV_X,               x,
	      XV_Y,               y,
	      PANEL_LABEL_BOLD,   FALSE,
	      PANEL_LABEL_STRING, txt,
	      NULL);
  } else {
    return xv_create(PrefsPanel,         PANEL_MESSAGE,
	      XV_X,               x,
	      XV_Y,               y,
	      PANEL_LABEL_BOLD,   TRUE,
	      PANEL_LABEL_STRING, txt,
	      NULL);
  }
}    




void ChangePrefs()
{
  if (xv_get(PrefsFrame, FRAME_CMD_PUSHPIN_IN) == TRUE) 
    xv_set(PrefsFrame, FRAME_CMD_PUSHPIN_IN, FALSE,
                       XV_SHOW,              FALSE,
                       NULL);
  else 
    xv_set(PrefsFrame, XV_SHOW,              TRUE, 
                       FRAME_CMD_PUSHPIN_IN, TRUE,
                       NULL);
  
}



void SetEllipsoid(int n)
{
  int start = 160;
  int i, p;
  char temp[30];

  if (dat[0]) {
    for (i = 0; i <= 6; i++)
      xv_destroy(dat[i]);
  }

  p = gDatum[n].ellipsoid;
  
  sprintf(temp, "%-25s", gDatum[n].name);
  dat[0] = PrefsMessage(115, start +  25, 1, temp);
  sprintf(temp, "%-25s", gEllipsoid[p].name);
  dat[1] = PrefsMessage(115, start +  50, 1, temp);

  sprintf(temp, "= %0.3f", gEllipsoid[p].a);
  dat[2] = PrefsMessage(75, start +  70, 0, temp);
  sprintf(temp, "= %0.8f", gEllipsoid[p].invf);
  dat[3] = PrefsMessage(75, start +  85, 0, temp);
  sprintf(temp, "= %d m", gDatum[n].dx);
  dat[4] = PrefsMessage(75, start + 130, 0, temp);
  sprintf(temp, "= %d m", gDatum[n].dy);
  dat[5] = PrefsMessage(75, start + 145, 0, temp);
  sprintf(temp, "= %d m", gDatum[n].dz);
  dat[6] = PrefsMessage(75, start + 160, 0, temp);
}


void PrefsDoApply()
{
  xv_set(PrefsFrame, FRAME_CMD_PUSHPIN_IN, FALSE, XV_SHOW, FALSE, NULL);

  gPrefs.offset = (double) xv_get(PrefsOffset, PANEL_VALUE);
  gPrefs.format = (int)    xv_get(PrefsFormat, PANEL_VALUE);
  gPrefs.datum  = (short)ListSelected;
  sprintf(gPrefs.Device, "%s", xv_get(PrefsDevice, PANEL_VALUE));
}


void PrefsDoSave()
{
  PrefsDoApply();
  SavePrefs();
}


void PrefsDoCancel()
{
  xv_set(PrefsFrame, FRAME_CMD_PUSHPIN_IN, FALSE, XV_SHOW, FALSE, NULL);

  xv_set(PrefsFormat, PANEL_VALUE, (int) gPrefs.format, NULL);
  xv_set(PrefsOffset, PANEL_VALUE, (int) gPrefs.offset, NULL);
  xv_set(PrefsDatum,  PANEL_LIST_SELECT, (int)gPrefs.datum, TRUE, NULL);
  xv_set(PrefsDevice, PANEL_VALUE, DefaultServerDevice, NULL);

  SetEllipsoid(gPrefs.datum);

  ListSelected = gPrefs.datum;
}



void HandleDatumChange(item, string, client_data, op, event)
Panel_item     item;
char           *string;
caddr_t        client_data;
Panel_list_op  op;
Event          *event;
{
  if (op == 1) {
    SetEllipsoid((int)client_data);
    ListSelected = (int)client_data;
  }
}



void CreateDatumList()
{
  short v;

  xv_set(PrefsDatum, PANEL_LIST_NROWS, nDatums, NULL);
  for (v = 0; v <= nDatums; v++) 
    xv_set(PrefsDatum, PANEL_LIST_STRING, v, gDatum[v].name,
	   PANEL_LIST_CLIENT_DATA, v, v, NULL); 
}


void CreatePrefsWindow()
{
  int start = 160;
  int PrefsWidth, PrefsHeight;


  PrefsFrame = (Frame) xv_create(frame,            FRAME_CMD,
				 XV_WIDTH,         10,
				 XV_HEIGHT,        10,
				 FRAME_LABEL,      PrefsWindowHeader,
				 NULL);

  PrefsPanel = (Panel) xv_create(PrefsFrame,       PANEL,
				 XV_X,             10,
				 XV_Y,             10,
				 NULL);

  PrefsDatum = (Panel) xv_create(PrefsPanel,       PANEL_LIST,
				 XV_X,             5,
				 XV_Y,             5,
				 PANEL_LIST_TITLE, "Select Map Datum:",
				 PANEL_LIST_WIDTH, 200,
				 PANEL_LIST_DISPLAY_ROWS, 5,
				 PANEL_NOTIFY_PROC, HandleDatumChange,
				 NULL);

  CreateDatumList();


  PrefsMessage(10, start      , 1, "Map Datum:");
  PrefsMessage(30, start +  25, 1, "Datum:");
  PrefsMessage(30, start +  50, 1, "Ellipsoid:");
  PrefsMessage(50, start +  70, 0, "a");
  PrefsMessage(50, start +  85, 0, "1/f");
  PrefsMessage(30, start + 110, 1, "Geocentric displacement:");
  PrefsMessage(50, start + 130, 0, "dx");
  PrefsMessage(50, start + 145, 0, "dy");
  PrefsMessage(50, start + 160, 0, "dz");


  PrefsFormat = (Panel) xv_create(PrefsPanel,           PANEL_CHOICE_STACK,
				  XV_Y,                  80,
				  PANEL_VALUE_X,        450,
				  PANEL_LAYOUT,         PANEL_HORIZONTAL,
				  PANEL_CHOOSE_ONE,     TRUE,
				  PANEL_LABEL_STRING, 
				  "Output File Position Format:",
				  PANEL_CHOICE_STRINGS,
				  "lat/lon  dddmm'ss.s\"",
				  "lat/lon  dddmm.mmm'",
				  "lat/lon  ddd.ddddd",
				  "utm/ups Grid",
				  "British Grid",
				  "Irish Grid",
				  "Swiss Grid (not yet implemented)",
				  NULL,
				  PANEL_VALUE,           0,
				  NULL);


  PrefsOffset = (Panel) xv_create(PrefsPanel,               PANEL_NUMERIC_TEXT,
				  XV_Y,                     120,
				  PANEL_VALUE_X,            450,
				  PANEL_MIN_VALUE,          -12,
				  PANEL_MAX_VALUE,          +12,
				  PANEL_VALUE_DISPLAY_WIDTH, 20,
				  PANEL_LABEL_STRING,    "UTC Offset [hours]:",
				  PANEL_VALUE,                0,
				  NULL);

  PrefsDevice = (Panel) xv_create(PrefsPanel,                PANEL_TEXT,
				  XV_Y,                      200,
				  PANEL_VALUE_X,             450,
				  PANEL_LABEL_STRING,  "Serial device node:",
				  PANEL_VALUE_DISPLAY_WIDTH, 150,
				  NULL);


  PrefsApply  = (Panel) xv_create(PrefsPanel,                PANEL_BUTTON,
				  XV_X,                      355,
				  XV_Y,                      310,
				  PANEL_LABEL_BOLD,                TRUE,
				  PANEL_LABEL_STRING,        "Apply",
				  PANEL_NOTIFY_PROC,         PrefsDoApply,
				  NULL);

  PrefsSave   = (Panel) xv_create(PrefsPanel,                PANEL_BUTTON,
				  XV_X,                      450,
				  XV_Y,                      310,
				  PANEL_LABEL_STRING,        "Save",
				  PANEL_NOTIFY_PROC,         PrefsDoSave,
				  NULL);

  PrefsCancel = (Panel) xv_create(PrefsPanel,                PANEL_BUTTON,
				  XV_X,                      540,
				  XV_Y,                      310,
				  PANEL_LABEL_STRING,        "Cancel",
				  PANEL_NOTIFY_PROC,         PrefsDoCancel,
				  NULL);

  window_fit(PrefsPanel);
  window_fit(PrefsFrame);

  PrefsWidth  = (int) xv_get(PrefsFrame, XV_WIDTH);
  PrefsHeight = (int) xv_get(PrefsFrame, XV_HEIGHT);

  xv_set(PrefsFrame, XV_X, (int) ((dsp_width - PrefsWidth) / 2),
	             XV_Y, (int) ((dsp_height / 2) - (PrefsHeight / 2)),
         NULL);
}
       


