/*
 * lftp and utils
 *
 * Copyright (c) 1996-1997 by Alexander V. Lukyanov (lav@yars.free.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef RGLOB_H
#define RGLOB_H

#include "SMTask.h"
#include "ftpclass.h"

class RemoteGlob : public SMTask
{
   enum state_t
      {
	 INITIAL,
	 GETTING_DATA,
	 DONE
      };
   state_t state;

   char	 **list;
   int	 list_size;
   int	 list_alloc;

   Ftp::open_mode mode;

   int	 inbuf;
   char	 *buf;
   char	 *ptr;
   bool	 from_cache;

   bool	 use_cache;

   FileAccess  *f;

   int	 flags;
   enum { RESTRICT_SLASHES=2,RESTRICT_PATH=4 };
   int	 extra_slashes;

   int	 err_code;

public:
   int	 Do();

   char	 *pattern;

   RemoteGlob(FileAccess *session,char *n_pattern,Ftp::open_mode n_mode=Ftp::LIST);
   virtual ~RemoteGlob();

   void	 SetSlashFilter(int num)
   {
      extra_slashes=num;
      flags|=RESTRICT_SLASHES;
   }
   void RestrictPath() { flags|=RESTRICT_PATH; }
   void NoCache() { use_cache=false; }

   bool	 Done() { return state==DONE; }
   bool	 Error() { return err_code!=Ftp::OK; }
   int	 ErrorCode() { return err_code; }

   char **GetResult() { return(Done()?list:0); }
};

#endif
