/*
 *  qftp
 *  Copyright (C) 1997,1998 Peter Strand
 *  Distributed under the GNU Pulic Licence
 */

#include <arpa/inet.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <unistd.h>
#include <errno.h>
#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <ctype.h>


#include "net.h"
#include "ftpconn.h"


FtpConn::FtpConn()
{
	ctrl = new Socket;
	data = NULL;
	cwdch = 1;
	conn = 0;
}

FtpConn::~FtpConn()
{
}

int FtpConn::Connect(char *host)
{
	char buf[500];
	Host h(host);
	if (!ctrl)
		ctrl = new Socket;
	cwdch = 1;
	if (ctrl->Connect(h))
		return -1;
	if (!GetReply())
		return 1;
	conn = 1;
	return 0;
}

void FtpConn::Close()
{
	if (conn) {
		Cmd("QUIT");
		GetReply();
	}
	conn = 0;
	if (ctrl) {
		ctrl->Close();
		ctrl = NULL;
	}
	if (data) {
		data->Close();
		data = NULL;
	}
}

int FtpConn::Cmd(char *cm, char *arg = NULL)
{
	char buf[1024];
	
	if (arg && *arg)
		sprintf(buf, "%s %s", cm, arg);
	else
		sprintf(buf, "%s", cm);
	if (ctrl->Writeln(buf))
		return -1;
	return GetReply();
}

int FtpConn::GetReply()
{
	int i;
	
	if (ctrl->Readln(retmsg) == -1)
		return -1;
	retval = atoi(retmsg);
	i = 0;
	if (retmsg[3] == '-') {
		do {
			i += strlen(&retmsg[i]);
			if (ctrl->Readln(&retmsg[i]) == -1)
				return -1;
		} while ((atoi(&retmsg[i]) == retval)?(retmsg[i + 3] == '-'):1);
	}
	i += strlen(retmsg);
	return retval;
}

int FtpConn::Get(char *s, int fd, void (*cbf)(int) = NULL)
{
	Socket *ns;
	char buf[4096];
	int n;
	
	data = new Socket(ctrl);
	if (data->Listen() == -1)
		return -1;
	if ((unsigned)Port() >= 400)
		return -1;
	
	if ((unsigned)Cmd("RETR", s) >= 400)
		return -1;
	
	if (!(ns = data->Accept()))
		return -1;
	if (cbf)
		cbf(-1);
	while ((n = ns->Read(buf, 4096))) {
		write(fd, buf, n);
		if (cbf)
			cbf(n);
	}
	delete ns;
	delete data;
	return (GetReply() == -1)?-1:0;
}


int FtpConn::Put(char *s, int fd, void (*cbf)(int) = NULL)
{
	Socket *ns;
	char buf[4096];
	int n;
	
	data = new Socket(ctrl);
	if (data->Listen() == -1)
		return -1;
	if ((unsigned)Port() >= 400)
		return -1;
	
	if ((unsigned)Cmd("STOR", s) >= 400)
		return -1;

	if (!(ns = data->Accept()))
		return -1;
	if (cbf)
		cbf(-1);
	while ((n = read(fd, buf, 4096)) > 0) {
		ns->Write(buf, n);
		if (cbf)
			cbf(n);
	}
	delete ns;
	delete data;
	return (GetReply() == -1)?-1:0;
}


int FtpConn::Quote(char *s)
{
	return Cmd(s, NULL);
}

int FtpConn::Cd(char *s = NULL)
{
	cwdch = 1;
	return Cmd("CWD", s);
}

int FtpConn::Size(char *s)
{
	return Cmd("SIZE", s);
}

int FtpConn::Login(char *user, char *pass)
{
	if ((unsigned)Cmd("USER", user) >= 400)
		return -1;
	if ((unsigned)Cmd("PASS", pass) >= 400)
		return -1;
	return 0;
}

int FtpConn::List(FileList &fl, char *s = NULL)
{
	Socket *ns;
	char buf[500];
	FileInf f;
	int i;
	
	data = new Socket(ctrl);
	if (data->Listen() == -1)
		return -1;
	if ((unsigned)Port() >= 400)
		return -1;
	
	if ((unsigned)Cmd("NLST", s) >= 400)
		return -1;		
	
	if (!(ns = data->Accept()))
		return -1;
	fl.Flush();
	while ((i = ns->Readln(buf))) {
		if (i == -1)
			return -1;
		i = strlen(buf);
		if (buf[i - 1] == '\n' || buf[i - 1] == '\r')
			buf[i - 1] = 0;
		if (buf[i - 2] == '\n' || buf[i - 2] == '\r')
			buf[i - 2] = 0;
		f.name = buf;
		f.type = -1;
		f.perm = -1;
		f.date = NULL;
		f.size = -1;
		fl.AddFile(f);
	}
	delete ns;
	delete data;
	data = NULL;
	return (GetReply() == -1)?-1:0;
}

int FtpConn::LongList(FileList &fl, char *s = NULL)
{
	Socket *ns;
	char buf[500];
	FileInf f;
	int i;
	
	data = new Socket(ctrl);
	if (data->Listen() == -1)
		return -1;
	if ((unsigned)Port() >= 400)
		return -1;
	if ((unsigned)Cmd("LIST", s) >= 400)
		return -1;
	if (!(ns = data->Accept()))
		return -1;
	if (!ns->Readln(buf))
		return -1;
	fl.Flush();
	while ((i = ns->Readln(buf))) {
		if (i == -1)
			return -1;
		i = strlen(buf);
		if (buf[i - 1] == '\n')
			buf[i - 1] = 0;
		f.type = buf[0];
		f.perm = 0;
		if (buf[1] == 'r')
			f.perm |= 0400;
		if (buf[2] == 'w')
			f.perm |= 0200;
		if (buf[3] == 'x')
			f.perm |= 0100;
		if (buf[4] == 'r')
			f.perm |= 0040;
		if (buf[5] == 'w')
			f.perm |= 0020;
		if (buf[6] == 'x')
			f.perm |= 0010;
		if (buf[7] == 'r')
			f.perm |= 0004;
		if (buf[8] == 'w')
			f.perm |= 0002;
		if (buf[9] == 'x')
			f.perm |= 0001;
		if (buf[3] == 's')
			f.perm |= 04000;
		if (buf[6] == 's')
			f.perm |= 02000;
		if (buf[9] == 's')
			f.perm |= 01000;
		f.date = &buf[42];
		buf[54] = 0;
		f.name = &buf[55];
		f.size = atol(&buf[32]);
		fl.AddFile(f);
	}
	delete ns;
	delete data;
	data = NULL;
	return (GetReply() == -1)?-1:0;
}

char *FtpConn::GetHost()
{
	return ctrl->GetRHost();
}

char *FtpConn::GetMsg()
{
	return retmsg;
}

const char *FtpConn::GetError()
{
	return ctrl->GetError();
}

char *FtpConn::GetCwd()
{
	char *p;
	int i;
	if (cwdch) {
		if (Cmd("PWD") >= 400)
			return 0;
		p = strchr(retmsg, '"') + 1;
		i = 0;
		while ((cwd[i++] = *p++) != '"');
		cwd[i - 1] = 0;
	}
	cwdch = 0;
	return cwd;
}

int FtpConn::Port()
{
	char buf[500];
	long badr, bp;
	badr = ntohl(data->GetLAddr());
	bp = ntohs(data->GetLPort());
	sprintf(buf, "%d,%d,%d,%d,%d,%d", (int) (badr >> 24) & 0xff,
		(int) (badr >> 16) & 0xff, (int) (badr >> 8) & 0xff,
		(int) badr & 0xff, (int) (bp >> 8) & 0xff, (int) bp & 0xff);
	return Cmd("PORT", buf);
}

