/*
 * hr_vars.h --
 *
 * This file contains the definitions for the Host Resources MIB (RFC 1514).
 *
 * Copyright (c) 1995-1996
 *
 * Erik Schoenfelder		TU Braunschweig, Germany
 * Juergen Schoenwaelder	University of Twente, The Netherlands
 * Patrick Weemeeuw		KU Leuven, Belgium
 *
 * 
 * Permission to use, copy, modify, and distribute this software and its 
 * documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in 
 * supporting documentation, and that the name of CMU not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  
 * 
 * THE AUTHORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * THE AUTHORS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 */

#ifndef HR_VARS_H
#define HR_VARS_H

/*
 * Definitions of tags that are used internally to read/write the
 * selected object type. These tags should be unique. We allocate
 * value is groups (high byte) so that we can make changes easily.
 */

#define HRSYSTEMUPTIME			0x01
#define HRSYSTEMDATE			0x02
#define HRSYSTEMINITIALLOADDEVICE	0x03
#define HRSYSTEMINITIALLOADPARAMETERS	0x04
#define HRSYSTEMNUMUSERS		0x05
#define HRSYSTEMPROCESSES		0x06
#define HRSYSTEMMAXPROCESSES		0x07

#define HRMEMORYSIZE			0x22

#define HRSTORAGEINDEX			0x31
#define HRSTORAGETYPE			0x32
#define HRSTORAGEDESCR			0x33
#define HRSTORAGEALLOCUNITS		0x34
#define HRSTORAGESIZE			0x35
#define HRSTORAGEUSED			0x36
#define HRSTORAGEALLOCFAILURES		0x37

#define HRDEVICEINDEX			0x41
#define HRDEVICETYPE			0x42
#define HRDEVICEDESCR			0x43
#define HRDEVICEID			0x44
#define HRDEVICESTATUS			0x45
#define HRDEVICEERRORS			0x46

#define HRPROCESSORFRWID		0x47
#define HRPROCESSORLOAD			0x48

#define HRFSINDEX			0x51
#define HRFSMOUNTPOINT			0x52
#define HRFSREMOTEMOUNTPOINT		0x53
#define HRFSTYPE			0x54
#define HRFSACCESS			0x55
#define HRFSBOOTABLE			0x56
#define HRFSSTORAGEINDEX		0x57
#define HRFSLASTFULLBACKUPDATE		0x58
#define HRFSLASTPARTIALBACKUPDATE	0x59

#define HRSWOSINDEX			0x61

#define HRSWRUNINDEX			0x71
#define HRSWRUNNAME			0x72
#define HRSWRUNID			0x73
#define HRSWRUNPATH			0x74
#define HRSWRUNPARAMETERS		0x75
#define HRSWRUNTYPE			0x76
#define HRSWRUNSTATUS			0x77

#define HRSWRUNPERFCPU			0x81
#define HRSWRUNPERFMEM			0x82

/*
 * The functions exported by the hr_vars.c module.
 */

extern void hr_init();
extern unsigned char* var_hr();

#endif
