/*      _ ____       _           _   
**     (_) ___|  ___| | ___  ___| |_ 
**    / /\___ \ / _ \ |/ _ \/ __| __|
**   / /  ___) |  __/ |  __/ (__| |_ 
**  (_(  |____/ \___|_|\___|\___|\__|
**
**  iSelect -- Interactive Selection Tool
**
**  iSelect is a Curses-based tool for interactive line selection 
**  in an ASCII file via a full-screen terminal session.
**  
**  ======================================================================
**
**  Copyright (c) 1996,1997 Ralf S. Engelschall, All rights reserved.
**
**  This program is free software; it may be redistributed and/or modified
**  only under the terms of either the Artistic License or the GNU General
**  Public License, which may be found in the ePerl source distribution.
**  Look at the files ARTISTIC and COPYING or run ``eperl -l'' to receive
**  a built-in copy of both license files.
**
**  This program is distributed in the hope that it will be useful, but
**  WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See either the
**  Artistic License or the GNU General Public License for more details.
**
**  ======================================================================
**
**  iselect_browse.h -- Curses-based file browser header
*/

/*
 *  The Structure of our screen lines
 */
struct Line { 
    char *cpLine;      /* the input line */
    int   fSelectable; /* whether selectable or not */
    int   fSelected;   /* whether alreay selected or not */
    char *cpResult;    /* the result string */
} Line;

#define MAXLINELEN 1024
#define MAXLINES   1024
#define MAXBUF     MAXLINELEN*MAXLINES

extern struct Line *spaLines[MAXLINES];
extern int          nLines;
extern char         caBuf[MAXBUF];

/*
 *  Prototypes
 */
extern int iSelect(int pos, char *title, char *name,
                   int stripco, int stripws, 
                   int browsealways, int allselectable,
                   int multiselect, int exitnoselect);

/*EOF*/
