#include "pscol.h"

/************************************************************************/
/*                                                                      */
/* convert: converts the string to readable format depending on the     */
/*          parameters                                                  */
/*                                                                      */
/************************************************************************/

char *convert(char **var, int pls, int uid, int col, int typ, int v)
{
 char *markup, *data, *color, *ret, *line;
 int m, c, outlen = 0;

 for (c = 0;var[c];c++)
 {
  line = var[c];         /* for simplicity! */
   /* if none are set, no converting will be done */
  if (pls || uid || col || typ)
  {
   /* can't use STRTOK here.  I would but color may have a ,  .. OUCH */
   for (markup = line;*line != ',' && *line;line++);
   *line = 0;
   for (data = ++line;*line != ',' && *line;line++);
   *line = 0;
   color = ++line;
   m = atoi(markup);
   /* uid? */
   if (m == 2 && (uid || pls))
   {
    if (v) info("Converting UIDs");
    data = convuids(atoi(data), uid, pls);
   }
   if (typ)
   {
    if (v) info("Converting Markup Type");
    markup = convtype(m);
   }
   if (col)
   {
    if (v) info("Converting Colors");
    color = convcolor(color);
   }
   line = malloc(strlen(markup) + strlen(data) + strlen(color) + 4);
   /* added 3 for: 2 ,'s, 1 \n and 1 NULL */
   sprintf(line, "%s,%s,%s\n", markup, data, color);
   var[c] = line;
  }
  else
  {  /* no converting period! */
   line = malloc(strlen(line) + 2); /* added 2 for \n and NULL */
   sprintf(line, "%s\n", var[c]);
   var[c] = line;
  }
  outlen += strlen(var[c]);
 }
 ret = malloc(outlen + 1);
 bzero(ret, outlen + 1);
 for (c = 0;var[c];c++) strcat(ret, var[c]);
 return ret;
}
