/*
    Wn: A Server for the HTTP
    File: wn/vhost.c
    Version 1.18.0
    
    Copyright (C) 1996-7  <by John Franks>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <errno.h>
#include <string.h>
#include "../config.h"
#include "wn.h"

#ifdef USE_VIRTUAL_HOSTS

/*
 * The MAXVHOSTS line below sets the maximum number of virtual hosts
 * which can be listed in a virtual host file.  You can increase it
 * if you wish.
 */

#define	MAXVHOSTS	(64)

#ifndef VIRTUAL_HOSTS_FILE
#include "vhost.h"
#else

char *vhostlist[MAXVHOSTS][3] = 
{
	{ NULL, NULL, NULL }
};

extern char	*malloc();

char	vhostfile[SMALLLEN] = VIRTUAL_HOSTS_FILE;

void
load_virtual()
{
	register char	*cp;
	char	buf[SMALLLEN];

	FILE	*vhostfp;
	int	i = 0;

	if ( (vhostfp = fopen( vhostfile, "r")) == (FILE *) NULL) {
		daemon_logerr( err_m[99], vhostfile, errno);
		return;
	}

	while ( fgets( buf, MIDLEN, vhostfp)) {
		chop( buf);
		if ( !buf[0] || buf[0] == '#')
			continue;

		if ( (vhostlist[i][0] = malloc( strlen( buf) + 2)) == NULL) {
			daemon_logerr( err_m[64], " load_virtual",  errno);
			return;
		}
		strcpy( vhostlist[i][0], buf);
			
		cp = vhostlist[i][0];

		while ( *cp && isspace( *cp))
			cp++;

		if ( *cp )
			vhostlist[i][0] = cp;
		else {
			daemon_logerr( err_m[101], buf, 0);
			break;
		}

		while ( *cp && !isspace( *cp))
			cp++;
		if ( *cp)
			*cp++ = '\0';

		while ( *cp && isspace( *cp))
			cp++;

		if ( *cp )
			vhostlist[i][1] = cp;
		else {
			daemon_logerr( err_m[101], buf, 0);
			break;
		}

		while ( *cp && !isspace( *cp))
			cp++;
		if ( *cp )
			*cp++ = '\0';

		while ( *cp && isspace( *cp))
			cp++;

		if ( *cp )
			vhostlist[i][2] = cp;
		else {
			daemon_logerr( err_m[101], buf, 0);
			break;
		}

		while ( *cp && !isspace( *cp))
			cp++;
		if ( *cp )
			*cp = '\0';

		i++;
		if ( i >= MAXVHOSTS) {
			daemon_logerr( err_m[100], "",  0);
			return;
		}
	}
	vhostlist[i][0] = vhostlist[i][1] = vhostlist[i][2] = NULL;
	fclose( vhostfp);
}

#endif /* VIRTUAL_HOSTS_FILE */
#endif /* USE_VIRTUAL_HOSTS */



