

#include "WINGs.h"

#include "generic/wwmlib.h"

#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include <assert.h>

#include <stdlib.h>


#define DOUBLE_BUFFER



/* internal messages */
#define WM_RADIO_PRESS	128


#define SETUP_INTERNAL_MESSAGE(event, scrPtr) \
		event.xclient.type=ClientMessage;\
		event.xclient.display=scrPtr->display;\
		event.xclient.send_event=False;\
		event.xclient.serial=0;\
		event.xclient.message_type=scrPtr->internalMessage;

typedef unsigned long WMPixel;


typedef struct W_Font {
    struct W_Screen *screen;
#ifndef I18N_MB___
    XFontStruct *font;
#else
    XFontSet font;
#endif
    short height;
    short y;
    short refCount;
} W_Font;


typedef struct W_Pixmap {
    struct W_Screen *screen;
    Pixmap pixmap;
    Pixmap mask;
    unsigned short width;
    unsigned short height;
    short depth;
    short refCount;
} W_Pixmap;



typedef struct W_Screen {
    Display *display;
    int screen;
    int depth;
    
    Colormap colormap;
    
    Visual *visual;
    
    Time lastEventTime;
    
    Window rootWin;
    
    RContext *rcontext;

    struct W_View *focusedControl;	/* control that has the input focus */


    WMPixel whitePixel;
    WMPixel blackPixel;
    WMPixel lightPixel;
    WMPixel darkPixel;
    GC whiteGC;
    GC blackGC;
    GC lightGC;
    GC darkGC;
    
    GC copyGC;
    
    W_Font *normalFont;
    GC normalFontGC;
    W_Font *largeFont;
    
    struct W_Pixmap *checkButtonImageOn;
    struct W_Pixmap *checkButtonImageOff;
    
    struct W_Pixmap *radioButtonImageOn;
    struct W_Pixmap *radioButtonImageOff;

    struct W_Pixmap *buttonArrow;
    struct W_Pixmap *pushedButtonArrow;
    
    struct W_Pixmap *applicationIcon;
    
    Atom internalMessage;	       /* for ClientMessage */
} W_Screen;


typedef struct W_EventHandler {
    unsigned long eventMask;
    
    WMEventProc *proc;
    
    void *clientData;
    
    struct W_EventHandler *nextHandler;
} W_EventHandler;



#define CHECK_CLASS(widget, class) assert(W_CLASS(widget)==(class))





W_View *W_GetViewForXWindow(Display *display, Window window);

W_View *W_CreateView(W_View *parent);

W_View *W_CreateTopView(W_Screen *screen);

void W_DestroyView(W_View *view);

void W_RealizeView(W_View *view);

void W_MoveView(W_View *view, int x, int y);



void W_DrawRelief(W_Screen *scr, Drawable d, int x, int y, unsigned int width,
		  unsigned int height, WMReliefType relief);


void W_CleanUpEvents(WMView *view);

void W_CallDestroyHandlers(W_View *view);

int W_ConfigureViewArg(W_View *view, WMArgument *arg);

void W_PaintTextAndImage(W_View *view, int wrap, GC textGC, W_Font *font,
			 WMReliefType relief, char *text, int textHeight,
			 WMAlignment alignment, W_Pixmap *image, 
			 WMImagePosition position, GC backGC, int ofs);

void W_PaintText(W_View *view, Drawable d, WMFont *font,  int x, int y,
		 int width, WMAlignment alignment, GC gc,
		 int wrap, char *text, int length);

int W_GetTextHeight(WMFont *font, char *text, int width, int wrap);


void W_BindButtonEvent(WMButton *bPtr, WMEventType eventType, WMCallBack *callback,
		       void *clientData);



void W_BroadcastMessage(W_View *targetParent, XEvent *event);

void W_DispatchMessage(W_View *target, XEvent *event);


void W_SetFocusToWidget(WMWidget *widget);
