/* appicon.h- application icon
 * 
 *  WindowMaker window manager
 * 
 *  Copyright (c) 1997 Alfredo K. Kojima
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef WMAPPICON_H_
#define WMAPPICON_H_

#include <wraster.h>

#include "wcore.h"
#include "window.h"
#include "icon.h"
#include "application.h"

typedef struct WAppIcon {
    short xindex;
    short yindex;
    struct WAppIcon *next;	       /* list of dock icons */
    struct WAppIcon *prev;
    WIcon *icon;
    
    RImage *image;

    char *client_machine;
    
    int x_pos, y_pos;		       /* absolute screen coordinate */
    
    char *command;		       /* command used to launch app */
    
#ifdef OFFIX_DND
    char *dnd_command;		       /* command to use when something is */
				       /* dropped on us */
#endif
    
    char *wm_class;
    char *wm_instance;
    pid_t pid;			       /* for apps launched from the dock */
    Window main_window;
    unsigned int gnustep_app:1;	       /* if this is a GNUstep application */
    unsigned int docked:1;
    unsigned int launching:1;
    unsigned int running:1;	       /* application is already running */
    unsigned int relaunching:1;	       /* launching 2nd instance */

    unsigned int forced_dock:1;
    unsigned int auto_launch:1;	       /* launch app on startup */
    unsigned int remote_start:1;
    unsigned int updated:1;
    unsigned int editing_command:1;
    
    unsigned int drop_launch:1;	       /* launching from drop action */
} WAppIcon;


WAppIcon *wAppIconCreate(WWindow *leader_win);
WAppIcon *wAppIconCreateForCommand(WScreen *scr, char *command,
				   char *wm_class, char *wm_instance);

void wAppIconDestroy(WAppIcon *aicon);

void wAppIconPaint(WAppIcon *aicon);



#endif
