/*
 * bin.c
 *
 * Load/verify chos binaries.
 *
 * Copyright (c) Tuomo Valkonen 1997.
 */
 
#include<stdio.h>
#include<strings.h>
#include<sys/types.h>
#include<sys/stat.h>
#include<fcntl.h>
#include<errno.h>

#include<chos/chos.h>
#include<chos/main.h>
#include<chos/image.h>
#include<chos/install.h>
#include<chos/map.h>
#include<chos/mapfile.h>

char*	bindir="/boot";
int bindir_set=0;

void do_chos_bindir(char*d)
{
	struct stat st;
	int	i;
	
	if(bindir_set)
		return;
		
	if(!*d)
		die(-1,"directory name expected...\n");
		
	if(stat(d,&st))
		die(errno,"%s",d);

	if(!S_ISDIR(st.st_mode))
		die(-1,"%s: Not a directory...\n",d);
		
	i=strlen(d);
	
	if(!(bindir=(char*)malloc(i+1)))
		die(-1,"Outta memory. Can this really happen????\n");
		
	memcpy(bindir,d,i+1);
	
	verbose("Searching for binaries in %s\n",d);
}

static int do_get_binary(char*name,int wanted_type,char*typename,int*size_return)
{
	int	fd;
	int	i;
	static ChosHeader	hdr;
	struct stat st;
	
	if(sizeof(ChosHeader)!=8)
		die(-1,"sizeof(ChosHeader)!=8\n");
		
	if((fd=open(name,O_RDONLY))<0)
		die(errno,"%s",name);
	if(fstat(fd,&st)<0)
		die(errno,"%s",name);
	if(!S_ISREG(st.st_mode))
		die(-1,"%s: not a regular file\n",name);
		
	if(read(fd,&hdr,8)!=8)
		die(errno,"%s",name);

	if(hdr.id[0]!='C' || hdr.id[1]!='H' || hdr.id[2]!='O')
		die(-1,"%s: Not a Choose-OS binary..\n",name);

	if(hdr.major!=CHOS_MAJOR || hdr.minor!=CHOS_MINOR)
		die(-1,"%s: Incorrect version (was %d.%d, expected %d.%d)\n",name,hdr.major,hdr.minor,CHOS_MAJOR,CHOS_MINOR);

	if(hdr.type!=wanted_type)
		die(-1,"%s: Not \"%s\"\n"
		       "%s: (type was 0x%02x, expected 0x%02x)\n",name,typename,name,hdr.type,wanted_type);

	if(size_return){
		if((i=lseek(fd,0,SEEK_END))<0)
			die(errno,"%s",name);
		lseek(fd,0,SEEK_SET);
	
		*size_return=i;
	}
	return fd;
}

int get_binary(char*name,int wanted_type,char*typename,int*size_return)
{
	if(*name!='.' && *name!='/'){
		sprintf(tmpstr2,"%s/chos.%s",bindir,name);
		name=tmpstr2;
	}
	return do_get_binary(name,wanted_type,typename,size_return);
}

typedef struct{
	char*name;
	int	type;
}LoaderInfo;

static LoaderInfo	loaders[MAX_LOADERS]={{0,},};

int find_loader(char*name,int wanted_type)
{
	int i;
	
	for(i=0;i<mh->nloaders;i++){
		if(strcmp(name,loaders[i].name))
			continue;
		if(loaders[i].type==wanted_type)
			return i;
	}
	return -1;
}

int get_loader(char*name,int wanted_type,char*typename)
{
	int		size;
	int		nr,i;
	int		fd;
	GEOMETRY 	geo;
	
	if(*name!='.' && *name!='/'){
		sprintf(tmpstr2,"%s/chos.loader-%s",bindir,name);
		name=tmpstr2;
	}
	
	nr=find_loader(name,wanted_type);
	if(nr>=0)
		goto done;
		
	fd=do_get_binary(name,wanted_type,typename,&size);

	size=size/513+1;
	
	if(size>MAX_LOADER_SIZE)
		die(-1,"%s is too big for a loader..\n",name);
		
	if(mh->nloaders==MAX_LOADERS)
		die(-1,"Maximum number of loaders exceeded\n");
		
	nr=mh->nloaders;
	loaders[nr].type=wanted_type;
	i=strlen(name)+1;
	if(!(loaders[nr].name=(char*)malloc(i)))
		die(-1,"What iz thiz? Outta memory????\n");
	memcpy(loaders[nr].name,name,i);
	mh->nloaders++;
	
	if( !get_device(fd,&geo) )
		die(errno,name);

	mh->loaders[nr].nsects=size;
	mh->loaders[nr].drive=geo.device;
	
	for(i=0;i<size;i++){
		if((mh->loaders[nr].sects[i]=get_addr(fd,i,&geo))==0)
			die(-1,"Hole in %s\n",name);
		VER_BIOS(&geo,mh->loaders[nr].sects[i],name);
	}
done:	
	verbose("\tUsing loader %s (\"%s\")\n",name,typename);
	close(fd);
	
	return nr;
}
