static char outputwin_rcsid[]="outputwin.c,v 1.2 1994/11/28 16:55:21 kerce Exp";
/***********************************************************
 *
 * Written By: Raju R. Lakhamraju 
 * Date: 7/2/94, 4/01/94, 6/17/94
 *
 * Based on Motif qmon by Jeff Snyder
 *
 * Major modifications: Removed motif calls and replaced
 *                     with athena widget set calls.
 *      Added several modules for new DQS commands.
 *
 * Copyright 1992, 1993, 1994
 *
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 *  SCRI representatives make no claims about the
 *  suitability of this software for any purpose.
 *  It is provided "as is" without express or
 *  implied warranty.
 *
 *  outputwin.c,v
 * Revision 1.2  1994/11/28  16:55:21  kerce
 * *** empty log message ***
 *
 * Revision 1.2  1994/09/13  18:03:59  raju
 * *** empty log message ***
 *
 * Revision 1.1  1994/07/11  15:28:24  raju
 * Initial revision
 *
 *
 *
 **********************************************************/
#include "globals.h"

static Widget          widget_outputwin;
static FILE            *fpout;
static FILE            *fperr;


/***********************************************************
 * initoutputwin - Initializes the output window
 */
int initoutputwin(Widget paned)
{
  Arg             args[32];
  int             ii;
  int             pipeout[2];
  int             pipeerr[2];

  ii=0;
  XtSetArg(args[ii],XtNscrollVertical,XawtextScrollAlways); ii++;
  XtSetArg(args[ii],XtNscrollHorizontal,XawtextScrollNever); ii++;
  XtSetArg(args[ii],XtNeditType,XawtextEdit); ii++;
  widget_outputwin=XtCreateManagedWidget("outputwin",asciiTextWidgetClass,
						paned,args,ii);

  /*
   * Set up the redirection of all stdout/stderr from this program
   * and any programs executed from within this program to the
   * outputwin
   */
  if(pipe(pipeout)<0) {
    logerr("cannot open pipeout");
    exit(-1);
  }
  if(pipe(pipeerr)<0) {
    logerr("cannot open pipeerr");
    exit(-2);
  }
  fcntl(pipeout[0],F_SETFL,O_NDELAY);
  fcntl(pipeerr[0],F_SETFL,O_NDELAY);
  dup2(pipeout[1],1);
  dup2(pipeerr[1],2);
  fpout=fdopen(pipeout[0],"r");
  fperr=fdopen(pipeerr[0],"r");

}



/***********************************************************
 * updateoutputwindow - See if there is any stdout or stderr that
 *                      needs to be redirected to the outputwin
 */
int updateoutputwindow()
{
  char            buffer[MAX_STRING_SIZE];

  fflush(stdout);
  fflush(stderr);
  while(fgets(buffer,MAX_STRING_SIZE,fpout)) {
    outputtext(buffer);
  }
  while(fgets(buffer,MAX_STRING_SIZE,fperr)) {
    outputtext(buffer);
  }
}


/***********************************************************
 * outputtext - Send text to the output window
 */
int outputtext(char *str)
{
  Arg             args[32];
  int             ii;
  XawTextBlock text ;
  static XawTextPosition pos = 0;

  text.length = strlen(str);
  text.ptr = str;
  text.firstPos = 0;
  text.format = FMT8BIT;
  
  XawTextReplace( widget_outputwin, pos, pos, &text);
  pos += text.length;
  XawTextSetInsertionPoint(widget_outputwin, pos);


}
