;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Module/load.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jun  7 08:44:07 1996                          */
;*    Last change :  Tue Jun 11 11:59:17 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The load clause compilation                                      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module module_load
   (import module_module
	   engine_param
	   tools_error
	   type_type
	   ast_var
	   ast_env
	   type_env
	   tools_speek
	   read_load)
   (export (make-load-compiler)))

;*---------------------------------------------------------------------*/
;*    make-load-compiler ...                                           */
;*---------------------------------------------------------------------*/
(define (make-load-compiler)
   (instantiate::ccomp (id 'load)
		       (producer load-producer)))

;*---------------------------------------------------------------------*/
;*    load-producer ...                                                */
;*---------------------------------------------------------------------*/
(define (load-producer clause)
   (match-case clause
      ((?- . ?protos)
       (for-each (lambda (proto) (load-parser proto clause)) protos))
      (else
       (user-error "Parse error"
		   (string-append "Illegal `load' clause")
		   clause
		   '()))))
   
;*---------------------------------------------------------------------*/
;*    load-parser ...                                                  */
;*---------------------------------------------------------------------*/
(define (load-parser proto clause)
   (match-case proto
      (((and ?module (? symbol?)) (and ?file (? string?)) . ?files)
       (let loop ((f files))
	  (cond
	     ((null? f)
	      (load-module module (cons file files)))
	     ((not (string? (car f)))
	      (user-error "Parse error" "Illegal load clause" clause '()))
	     (else
	      (loop (cdr f))))))
      ((? symbol?)
       (let ((b (assq proto *access-table*)))
	  (if (not b)
	      (user-error "load" "Can't load module" proto)
	      (load-module proto (cdr b)))))
      (else
       (user-error "Parse error" "Illegal load clause" clause '()))))

