package biss.awt;

import java.awt.Color;
import java.awt.image.IndexColorModel;

/**
 * auxiliary class used to get a single, shared IndexColorModel for all
 * clients (like ClassImageSource) which use just the standard Java colors
 * (Color.white, Color.black, ...). Just here to minimize the memory
 * footprint of biss.awt apps.
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class DefaultIndexModel
{
	public static IndexColorModel Model;
	public static Color[] Colors = { Awt.WindowBackClr, Color.white, Color.lightGray,
                   Color.gray, Color.darkGray, Color.black,
                   Color.red, Color.pink, Color.orange,
                   Color.yellow, Color.green, Color.magenta,
                   Color.cyan, Color.blue };
	public static byte[] Reds;
	public static byte[] Blues;
	public static byte[] Greens;

static {
	Reds   = new byte[Colors.length]; 
	Greens = new byte[Colors.length]; 
	Blues  = new byte[Colors.length];

	for ( int idx=0; idx<Colors.length; idx++){
		Color c = Colors[idx];
		Reds[idx]   = (byte)c.getRed();
		Greens[idx] = (byte)c.getGreen();
		Blues[idx]  = (byte)c.getBlue();
	}

	Model = new IndexColorModel( 8, Colors.length, Reds, Greens, Blues, 0);
}

public static int argbFor ( int index) {
	try { return Model.getRGB( index);}
	catch( Throwable t) { return 0; }
}

public static Color colorFor ( int index) {
	try { return Colors[index]; }
	catch( Throwable t) { return null; }
}

public static void dumpRGBs () {
	for ( int i=0; i<Colors.length; i++)
		System.out.println( Model.getRed( i) + ", " +
	                    Model.getGreen( i) + ", " +
	                    Model.getBlue( i) );
}

public static Color getTransColor () {
	return Colors[0];
}

public static byte getTransIdx () {
	return 0;
}

public static int indexFor ( Color c) {
	for ( int i=0; i<Colors.length; i++) {
		if ( c == Colors[i] )
			return i;
	}
	//transparent index
	return 0;
}

public static Color nearestColorFor ( int rgbVal) {
	byte idx = nearestIdxFor( rgbVal);
	return Colors[idx];
}

public static byte nearestIdxFor ( Color c) {
	return nearestIdxFor( c.getRGB() );
}

public static byte nearestIdxFor ( int rgbVal) {
	byte r = (byte)((rgbVal >> 16) & 0xFF);
	byte g = (byte)((rgbVal >> 8)  & 0xFF);
	byte b = (byte)((rgbVal >> 0)  & 0xFF); 
	int delta = 1000;
	byte match = 0;

	for ( int i=0; i<Colors.length; i++) {
		int d = Math.abs( Reds[i]-r) + Math.abs( Blues[i]-b) + Math.abs( Greens[i]-g);
		if ( d < delta) {
			delta = d;
			match = (byte)i;
		}
	}

	return match;
}

public static int rgbFor ( int index) {
	try { return Colors[index].getRGB();}
	catch( Throwable t) { return 0; }
}
}
