/*
** Copyright (c) Massachusetts Institute of Technology 1994-1997.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@larch.lcs.mit.edu).
*/
/*
** hashTable.h
*/

# ifndef HTABLE_H
# define HTABLE_H

/*@constant int HBUCKET_BASESIZE; @*/
# define HBUCKET_BASESIZE 2

/*@constant int HBUCKET_DNE; @*/
# define HBUCKET_DNE NOT_FOUND

typedef struct _hashTable *hashTable ;

typedef struct _hentry
{
  /*@dependent@*/ cstring key;
                  int     val;
} hentry;

typedef /*@null@*/ struct _hbucket
{
  int size;
  int nspace;
  /*@only@*/ hentry *entries;
} *hbucket;

typedef /*@only@*/ hbucket o_hbucket;

struct _hashTable
{
  int size;
  int nentries;
  /*@only@*/ o_hbucket *buckets;
} ;


extern /*@only@*/ hashTable hashTable_create(int p_size);
extern void hashTable_insert (hashTable p_h, cstring p_key, int p_value);
extern int hashTable_lookup (hashTable p_h, cstring p_key);
extern /*@unused@*/ /*@only@*/ cstring hashTable_stats(hashTable p_h);
extern void hashTable_free (/*@only@*/ hashTable p_h);
extern void hashTable_remove (hashTable p_h, cstring p_key) /*@modifies p_h@*/ ;
extern void 
  hashTable_replaceKey (hashTable p_h, cstring p_oldkey, /*@dependent@*/ cstring p_newkey);

# else
# error "Multiple include"
# endif 













