/*
** Copyright (c) Massachusetts Institute of Technology 1994-1997.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@larch.lcs.mit.edu).
*/
/*
** idDecl.h
*/

# ifndef idDecl_H
# define idDecl_H

struct _idDecl
{
  cstring id;
  qtype   typ;
} ; 

/*@constant null idDecl idDecl_undefined; @*/
# define idDecl_undefined ((idDecl) NULL)

extern /*@falsenull@*/ bool idDecl_isDefined (idDecl p_t) /*@*/ ;
# define idDecl_isDefined(t) ((t) != idDecl_undefined)

extern void idDecl_free (/*@only@*/ idDecl p_t);
extern /*@only@*/ idDecl 
  idDecl_create (/*@only@*/ cstring p_s, /*@only@*/ qtype p_t);
extern /*@only@*/ cstring idDecl_unparse (idDecl p_d);
extern /*@exposed@*/ qtype idDecl_getTyp (idDecl p_d);
extern void idDecl_setTyp (idDecl p_d, /*@only@*/ qtype p_c);
extern idDecl idDecl_expectFunction (/*@returned@*/ idDecl p_d);
extern idDecl idDecl_replaceCtype (/*@returned@*/ idDecl p_d, ctype p_c);
extern idDecl idDecl_fixBase (/*@returned@*/ idDecl p_t, qtype p_b);
extern idDecl idDecl_fixParamBase (/*@returned@*/ idDecl p_t, qtype p_b);
extern ctype idDecl_getCtype (idDecl p_d) /*@*/ ;
extern /*@exposed@*/ qualList idDecl_getQuals (idDecl p_d) /*@*/ ; 

extern /*@dependent@*/ /*@observer@*/ cstring idDecl_getName (idDecl p_t) /*@*/ ;
extern /*@observer@*/ cstring idDecl_observeId (idDecl p_d) /*@*/ ;
extern void idDecl_addQual (idDecl p_d, qual p_q);

# define idDecl_getName(t) idDecl_observeId(t)

# else
# error "Multiple include"
# endif


