/*
** Copyright (c) Massachusetts Institute of Technology 1994-1997.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@larch.lcs.mit.edu).
*/
/*
** macrocache.h
*/

# ifndef MACROCACHE_H
# define MACROCACHE_H

typedef struct _mce
{
  fileloc fl;
  cstring def;
  bool defined;
  bool scomment;
} *mce;

typedef /*@only@*/ mce o_mce;

typedef struct _mcelist
{
  int nspace;
  int entries;
  /*@reldef@*/ /*@only@*/ o_mce *contents;
} *macrocache;

extern void 
  macrocache_processUndefinedElements (macrocache p_m) ; /* modifies externalState */

extern /*@observer@*/ fileloc
  macrocache_processFileElements (macrocache p_m, cstring p_base) ;

extern /*@only@*/ /*@unused@*/ cstring macrocache_unparse (macrocache p_m) /*@*/ ;
extern /*@only@*/ macrocache macrocache_create (void) /*@*/ ;

extern void 
  macrocache_addEntry (macrocache p_s, /*@only@*/ fileloc p_fl, /*@only@*/ cstring p_def);

extern void 
  macrocache_addComment (macrocache p_s, /*@only@*/ fileloc p_fl, /*@only@*/ cstring p_def);

extern void macrocache_free (/*@only@*/ macrocache p_s);

# else
# error "Multiple include"
# endif
