/*
** Copyright (c) Massachusetts Institute of Technology 1994-1997.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@larch.lcs.mit.edu).
*/
/*
** programNodeList.c
**
** based on list_template.c
**
** where T has T_equal (or change this) and T_unparse
*/

# include "lclintMacros.nf"
# include "llbasic.h"

/*@only@*/ programNodeList
programNodeList_new ()
{
  programNodeList s = (programNodeList) dmalloc (sizeof (*s));
  
  s->nelements = 0;
  s->nspace = programNodeListBASESIZE;
  s->elements = (programNode *) 
    dmalloc (sizeof (*s->elements) * programNodeListBASESIZE);

  return (s);
}

static void
programNodeList_grow (programNodeList s)
{
  int i;
  programNode *newelements;

  s->nspace += programNodeListBASESIZE;
  newelements = (programNode *) dmalloc (sizeof (*newelements)
					 * (s->nelements + s->nspace));

  for (i = 0; i < s->nelements; i++)
    {
      newelements[i] = s->elements[i];
    }

  sfree (s->elements); 
  s->elements = newelements;
}

void 
programNodeList_addh (programNodeList s, /*@keep@*/ programNode el)
{
  if (s->nspace <= 0)
    programNodeList_grow (s);

  s->nspace--;
  s->elements[s->nelements] = el;
  s->nelements++;
}

/*@only@*/ cstring
programNodeList_unparse (programNodeList s)
{
  bool first = TRUE;
  cstring st = cstring_undefined;

  programNodeList_elements (s, current)
  {
    if (first)
      {
	st = programNode_unparse (current);
	first = FALSE;
      }
    else
      {
	st = message ("%q; %q", st, programNode_unparse (current));
      }
  } end_programNodeList_elements;

  return st;
}

void
programNodeList_free (programNodeList s)
{
  int i;
  for (i = 0; i < s->nelements; i++)
    {
      programNode_free (s->elements[i]); 
    }

  sfree (s->elements); 
  sfree (s);
}
