#!@PERL@
#
# Test of selecting on keys that consist of many parts
#
##################### Standard benchmark inits ##############################

use DBI;
use Getopt::Long;
use Benchmark;

$opt_loop_count=10000;
$small_loop_count=10;
$opt_regions=6;
$opt_groups=100;

chomp($pwd = `pwd`); $pwd = "." if ($pwd eq '');
require "$pwd/bench-init.pl" || die "Can't read Configuration file: $!\n";

$columns=min($limits->{'max_columns'},500,($limits->{'query_size'}-50)/24,
	     $limits->{'max_conditions'}-3);

print "Testing the speed of selecting on keys that consist of many parts\n";
print "The tests are done with a table that has $opt_loop_count rows.\n\n";

####
####  Connect and start timeing
####

$dbh = DBI->connect($server->{'data_source'}, $opt_user, $opt_password,
		    { PrintError => 0}) || die $DBI::errstr;
$start_time=new Benchmark;

####
#### Create needed tables
####

goto select_test if ($opt_skip_create);

print "Creating table\n";
$dbh->do("drop table bench1");

do_many($dbh,$server->create("bench1",
			     ["region char(1) NOT NULL",
			      "id int(6) NOT NULL",
			      "rev_id int(6) NOT NULL",
			      "grp int(6) NOT NULL"],
			     ["primary key (region,id)",
			      "unique (region,rev_id)",
			      "unique (region,grp,id)"]));
if ($opt_lock_tables)
{
  do_query($dbh,"LOCK TABLES bench1 WRITE");
}

if ($opt_fast && $opt_server eq "pg")
{
  $server->vacuum($dbh);
}

####
#### Insert $opt_loop_count records with
#### region:	"A" -> "E"
#### id: 	0 -> count
#### rev_id:	count -> 0,
#### grp:	distributed values 0 - > count/100
####

print "Inserting $opt_loop_count rows\n";

$loop_time=new Benchmark;
$query="insert into bench1 values (";
$half_done=$opt_loop_count/2;
for ($id=0,$rev_id=$opt_loop_count-1 ; $id < $opt_loop_count ; $id++,$rev_id--)
{
  $grp=$id*3 % $opt_groups;
  $region=chr(65+$id%$opt_regions);
  do_query($dbh,"$query'$region',$id,$rev_id,$grp)");
  if ($id == $half_done)
  {				# Test with different insert
    $query="insert into bench1 (region,id,rev_id,grp) values (";
  }
}

$end_time=new Benchmark;
print "Time to insert ($opt_loop_count): " .
    timestr(timediff($end_time, $loop_time),"noc") . "\n\n";

if ($opt_fast && $opt_server eq "pg")
{
  $server->vacuum($dbh);
}

####
#### Do some selects on the table
####

select_test:

print "Testing big selects on the table\n";
$loop_time=new Benchmark;
for ($i=0 ; $i < $small_loop_count ; $i++)
{
  $grp=$i*11 % $opt_groups;
  $region=chr(65+$i%($opt_regions+1));	# One larger to test misses
  fetch_all_rows($dbh,"select id from bench1 where region='$region'");
  fetch_all_rows($dbh,"select id from bench1 where region='$region' and id=$i");
  fetch_all_rows($dbh,"select id from bench1 where region='$region' and rev_id=$i");
  fetch_all_rows($dbh,"select id from bench1 where region='$region' and grp=$grp");
  fetch_all_rows($dbh,"select id from bench1 where region>='B' and region<='C' and grp=$grp");
  fetch_all_rows($dbh,"select id from bench1 where region>='B' and region<='E' and grp=$grp");
  fetch_all_rows($dbh,"select id from bench1 where grp=$grp"); # This is hard
}
$count=$small_loop_count*7;

$end_time=new Benchmark;
print "Time for select_big ($count): " .
    timestr(timediff($end_time, $loop_time),"noc") . "\n";

# Test select with many OR's

$loop_time=new Benchmark;
$tmpvar=0;
$count=0;
$estimated=0;
$max_and_conditions=$limits->{'max_conditions'}/2;

for ($i=0 ; $i < $small_loop_count ; $i++)
{
  $region=chr(65+$i%($opt_regions+1));	# One larger to test out-of-regions
  $query="select * from bench1 where ";
  $or_part="grp = 1";
  $or_part2="region='A' and grp=1";

  for ($j=1 ; $j < $columns; $j++)
  {
    $tmpvar^= ((($tmpvar + 63) + $j)*3 % 100000);
    $tmp=$tmpvar % $opt_groups;
    $tmp_region=chr(65+$tmpvar%$opt_regions);
    $or_part.=" or grp=$tmp";
    if ($j < $max_and_conditions)
    {
      $or_part2.=" or region='$tmp_region' and grp=$tmp";
    }
  }
  $or_part="region='$region' and ($or_part)";

# Same query, but use 'func_extra_in_num' instead.
  if ($limits->{'func_extra_in_num'})
  {
    $in_part=$or_part;
    $in_part=~ s/ = / IN \(/;
    $in_part=~ s/ or grp=/,/g;
    $in_part.= ")";
    defined(fetch_all_rows($dbh,$query . $in_part)) || die $DBI::errstr;
    $count++;
  }
  for ($j=0; $j < 10 ; $j++)
  {
    fetch_all_rows($dbh,$query . $or_part);
    fetch_all_rows($dbh,$query . $or_part2);
# Do it a little harder by setting a extra range
    fetch_all_rows($dbh,"$query ($or_part) and id < 50");
    fetch_all_rows($dbh,"$query (($or_part) or (region='A' and grp < 10)) and region <='B'")
  }
  $count+=$j*4;
  $end_time=new Benchmark;
  last if ($estimated=predict_query_time($loop_time,$end_time,\$count,$i,
					 $small_loop_count));
}

if ($estimated)
{ print "Estimated time"; }
else
{ print "Time"; }
print " for select_range ($count): " .
  timestr(timediff($end_time, $loop_time),"noc") . "\n";

####
#### End of benchmark
####

if ($opt_lock_tables)
{
  do_query($dbh,"UNLOCK TABLES");
}
if (!$opt_skip_delete)
{
  do_query($dbh,"drop table bench1");
}

if ($opt_fast && $opt_server eq "pg")
{
  $server->vacuum($dbh);
}

$dbh->disconnect;				# close connection

end_benchmark($start_time);


sub do_query
{
  my($dbh,$query)=@_;
  print $query if ($opt_debug);
  $dbh->do($query) or
    die "\nError executing '$query':\n$DBI::errstr\n";
}
