/*
    cthugha.c

    General functions
*/

#include "cthugha.h"
#include "information.h"			/* title, credits, ... */
#include "display.h"
#include "sound.h"
#include "action.h"				/* display_sound() */
#include "translate.h"
#include "options.h"
#include "keys.h"
#include "cd_player.h"
#include "server.h"
#include "imath.h"
#include "waves.h"

#include <sys/time.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <signal.h>

int cthugha_verbose = 1;
int cthugha_close = 0;
int cthugha_pause = 0;

static int true = 1;
int cth_init_level = -1;
struct init_exit_t {
    int * depend;
    int (*init)();
    int (*exit)();
    char * msg;
} init_exit[] = {
    {&ncurses_use,	init_ncurses,	exit_ncurses,	"ncurses"},
    {&server,		init_server,	exit_server,	"sound server"},
    {&true,		init_flames,	NULL,		"flame functions"},
    {&true,		init_display,	exit_display,	"display"},
    {&true,		init_translate,	NULL,		"translation tables"},
    {&true,		init_wave,	NULL,		"waves"},
    {&true,		init_sound,	exit_sound,	"sound"},
    {&true,		init_sound_process, NULL,	NULL},
    {&true,		read_ini_usage, NULL,		NULL},
    {&true,		init_startup,	exit_startup,	NULL}
};
int nr_init_exit = sizeof(init_exit) / sizeof(struct init_exit_t);
	

/*
 * shutdown code for cthugha
 */
void exit_cthugha() {

    for(cth_init_level --; cth_init_level >= 0; cth_init_level --) { 
	if( *(init_exit[cth_init_level].depend) ) {
	    if(init_exit[cth_init_level].exit) {
		if( init_exit[cth_init_level].msg )
		    printfv(1, "Closing %s...\n", 
			    init_exit[cth_init_level].msg);
		init_exit[cth_init_level].exit();
	    }
	}
    }
}


void * cth_memory(void * old, int size, char * error_msg) {
    void * ptr = realloc(old, size);
    if( ptr == NULL) {
	printfe(error_msg ? error_msg : "Can not allocate memory.");
	exit(1);
    }
    return ptr;
}

/*
 * get the 1/100 sec since program start
 */

int gettime() {
    struct timeval tv;
    struct timezone tz;
    static int starttime = 0;
    
    gettimeofday( &tv, &tz);

    if(starttime == 0) {
	starttime = tv.tv_sec;
    }
    tv.tv_sec -= starttime;

    return tv.tv_sec * 100L + tv.tv_usec / 10000L;
}


/*
 * handle ^Z and continue 
 */
void sig_tty_cont(int a);
void sig_tty_stop(int a) {
    printfv(0, "Stopping...\n");

    signal(SIGCONT, sig_tty_cont);		/* set, how to continue */

    cthugha_pause = 1;				/* in interface we will really stop */
}
void sig_tty_cont(int a) {
    printfv(0, "Continuing...\n");

    init_graph_mode();				/* turn back on graphics */
    alloc_sound();				/* and sound */

    signal(SIGTSTP, sig_tty_stop);		/* how to stop agian */

    raise(SIGCONT);				/* default action */
}
	

/*
 *
 */
int main(int argc, char * argv[]) {
    srand(time(0));			/* initialize random generator */
    atexit(exit_cthugha);

    if( get_pre_params(argc, argv) )
	return 1;

    if( cth_init(&argc, argv) )		/* special initialization */
	return 1;

    if( get_params(argc, argv) )	/* parse cmd-line and read ini-files*/
	return 1;

    title();				/* Display titlemessage */

    /* Initialization */
    init_imath();
    for(cth_init_level=0; cth_init_level < nr_init_exit;
	cth_init_level++) {
	if( *(init_exit[cth_init_level].depend) ) {
	    if( init_exit[cth_init_level].msg )
		printfv(1, "Initializing %s...\n", 
			init_exit[cth_init_level].msg);
	    if( (init_exit[cth_init_level].init)() )
		return 1;
	}
    }

    signal(SIGTSTP, sig_tty_stop);	/* react to ^Z */

    cth_main();
    
    return 0;
}











