#ifndef __FEATURE_H
#define __FEATURE_H

typedef enum {
    f_flame = 0,
    f_flame_general,
    f_wave,
    f_screen,
    f_palette,
    f_table,
    f_translation,
    f_massage,
    f_fft,
    f_flashlight,
    f_pcx,
    f_object,
    f_mirror_horiz,
    f_mirror_vert,
    f_rgb,
    f_MAX
} cth_feature;


#define MAX_NAME_LEN	24
#define MAX_DESC_LEN	30

typedef struct {
    void * data;				/* function of data */
    int use;					/* use it or not */
    char name[MAX_NAME_LEN];			/* name (short) */
    char desc[MAX_DESC_LEN];			/* description or long name */
} feature_entry;

typedef struct {
    char name[MAX_NAME_LEN];
    feature_entry * entries;
    int nr_entries;
    int current;
    cth_feature f_nr;				/* feature number */
} feature;

#define	CHANGE_RANDOM	-1
#define CHANGE_NEXT	-2
#define CHANGE_PREV	-3

int add_feature(feature * features, const feature_entry * entry);

/* feature_entry * feature_change(int to, feature * features); */
/* feature_entry * feature_change2(char * to, feature * features); */
int feature_defined(const char * name, const feature * features);

int init_startup();
int exit_startup();


void change(cth_feature f, int to, int save);
#define CHANGE(f)   change(f, CHANGE_RANDOM, 1)

#endif
