#include "cthugha.h"
#include "cd_player.h"
#include "sound.h"
#include "interface.h"
#include "keys.h"
#include "display.h"

#include <string.h>

/* 
 *  CD-Player-user-interface (and mixer)
 *  This is much more than a simple CD-Player. It's more a control-panel
 *  for sound-related stuff.
 */

static int sel = 0;
static int nr_cd_sel = 0;
static int nr_dsp_sel = 0;
static int nr_mixer_sel = 0;

#if USE_CDROM == 1
static int skip = 0;
static int fast = 0;
#endif

static char * cd_text() {
#if USE_CDROM == 1
    char str[512];
    static char str2[1000];

    if ( subchnl.cdsc_audiostatus == CDROM_AUDIO_PLAY )
	sprintf(str, 
		"CD-Player Track: %d %d:%02d (%d - %d) %d:%02d",
		subchnl.cdsc_trk,
		subchnl.cdsc_reladdr.msf.minute,
		subchnl.cdsc_reladdr.msf.second,
		first, last,
		subchnl.cdsc_absaddr.msf.minute,
		subchnl.cdsc_absaddr.msf.second);
    else if ( subchnl.cdsc_audiostatus == CDROM_AUDIO_PAUSED )
	sprintf(str, 
		"CD-Player Track: %d %d:%02d (%d - %d) %d:%02d pause",
		subchnl.cdsc_trk,
		subchnl.cdsc_reladdr.msf.minute,
		subchnl.cdsc_reladdr.msf.second,
		first, last,
		subchnl.cdsc_absaddr.msf.minute,
		subchnl.cdsc_absaddr.msf.second);
    else
	if(ejected)
	    sprintf(str,"CD-Player: ejected");
	else if (no_disk)
	    sprintf(str,"CD-Player: no disk in drive");
	else
	    sprintf(str,"CD-Player Track: stopped");
    
    sprintf(str2, 
	    "%s\n"
	    "<- prev(7)  pause(8)  -> next(9) \n"
	    "<< rev(4)   stop(5)   >> fwd(6)  \n"
	    "            %s             \n"
	    "\n"
	    "%cAutoplay:       %10s%c\n"
	    "%cPlayloop:       %10s%c\n"
	    "%cRandomplay:     %10s%c\n"
	    "%cEject On End:   %10s%c\n"
	    "\n",
	    str, 
	    ejected ? "close(2)":"eject(2)",
	    
	    (sel == 0) ? '>' : ' ',
	    (cd_first_track == -1) ? "off" : "on",
	    (sel == 0) ? '<' : ' ',
	    
	    (sel == 1) ? '>' : ' ',
	    (cd_loop) ? "on" : "off",
	    (sel == 1) ? '<' : ' ',
	    
	    (sel == 2) ? '>' : ' ',
	    (cd_randomplay) ? "on" : "off",
	    (sel == 2) ? '<' : ' ',
	    
	    (sel == 3) ? '>' : ' ',
	    (cd_eject_on_end) ? "on" : "off",
	    (sel == 3) ? '<' : ' ');

    nr_cd_sel = 4;

    return str2;
#else
    return "";
#endif
}


static char * dsp_text() {
#if USE_DSP == 1
    static char str[200];
    int s = sel - nr_cd_sel;

    sprintf(str, 
	    "%cSample rate:    %10d%c\n"
	    "%cChannels:       %10s%c\n",
	    (s == 0) ? '>' : ' ',
	    sound_options->speed,
	    (s == 0) ? '<' : ' ',
	    
	    (s == 1) ? '>' : ' ',
	    (sound_options->channels == 1) ? "mono" : "stereo",
	    (s == 1) ? '<' : ' '
	);

    nr_dsp_sel = 2;
    return str;
#else
    nr_dsp_sel = 0;
    return "";
#endif
}


#if USE_MIXER == 1
static char * voltostr(int volume, char * str) {
    if ( volume < 0) {
	strcpy( str, "default");
	return str;
    }
    sprintf(str, "%d", volume & 255);
    return str;
}
#endif

static char * mixer_text() {
#if USE_MIXER == 1
    static char str[2000];
    char vstr[16];
    int s = sel - nr_cd_sel - nr_dsp_sel;
    int i;

    nr_mixer_sel = 0;

    str[0] = '\0';
    for(i=0; i < mixer_nr_names; i++) {
	sprintf(str, 
		"%s\n"
		"%cVolume %7s: %10s%c",
		str,
		(s == nr_mixer_sel) ? '>' : ' ',
		MIXER_NAME(i),
		voltostr( MIXER_VOL(i), vstr),
		(s == nr_mixer_sel) ? '<' : ' ');
	nr_mixer_sel ++;
    }

    return str;
#else
    nr_mixer_sel = 0;
    return "";
#endif
}
    
int cd_pre_key() {
    static char str[2000];

    sprintf(str, "%s\n%s\n%s", 
	    cd_text(), 
	    dsp_text(), 
	    mixer_text());

    main_text = display_reprint(main_text, str, 0, 'l', 0, TEXT_COLOR_NORMAL);

    return 0;
}

void cd_do_key() {
    int nr_sel = nr_cd_sel + nr_dsp_sel + nr_mixer_sel;

    switch( int_var.key ) {

#if USE_CDROM == 1
	/* CD-Player keys */
    case '9':
	skip ++;
	break;
    case '7':
	skip --;
	break;
    case '6':
	fast += 15;
	break;
    case '4':
	fast -= 15;
	break;
    case '8':
	cd_pause();
	break;
    case '5':
	cd_stop();
	break;
    case '2':
	cd_eject();
	break;
#endif
	
	/* cursor movement up and down */
    case CK_UP:
	sel = (sel - 1 + nr_sel) % nr_sel;
	break;
    case CK_DOWN:
	sel = (sel + 1) % nr_sel;
	break;
	
    case '+': case CK_RIGHT:
#if USE_CDROM == 1
	/* change CD-Player settings */
	switch(sel) {
	case 0:
	    cd_first_track = 1;
	    break;
	case 1:
	    cd_loop = 1;
	    cd_eject_on_end = 0;
	    break;
	case 2:
	    cd_randomplay = 1;
	    break;
	case 3:
	    cd_eject_on_end = 1;
	    cd_loop = 0;
	    break;
	}
#endif
	
#if USE_DSP == 1
	/* increase dsp settings */
	switch(sel - nr_cd_sel) {
	case 0:
	    sound_options->speed += 1000;
	    sound_dsp_update();
	    break;
	case 1:
	    sound_options->channels = (sound_options->channels == 1) ? 2 : 1;
	    sound_dsp_update();
	    break;
	}
#endif

#if USE_MIXER == 1
	/* increase mixer settings */
	if(sel >= (nr_cd_sel + nr_dsp_sel)) {
	    MIXER_VOL(sel-nr_cd_sel-nr_dsp_sel) < 0 ? 
		(MIXER_VOL(sel-nr_cd_sel-nr_dsp_sel) = 25700):
		    (MIXER_VOL(sel-nr_cd_sel-nr_dsp_sel) += 257);
	    sound_set_mixer();
	}
	break;

    case '0':	/* set mixer setting to 0*/
	if(sel >= (nr_cd_sel + nr_dsp_sel)) {
	    MIXER_VOL(sel-nr_cd_sel-nr_dsp_sel) = 0;
	    sound_set_mixer();
	}
#endif
	break;	

    case '-': case CK_LEFT:

#if USE_CDROM == 1
	/* change CD-Player settings */
	switch(sel) {
	case 0:
	    cd_first_track = -1;
	    break;
	case 1:
	    cd_loop = 0;
	    break;
	case 2:
	    cd_randomplay = 0;
	    if ( random_played) {
		free(random_played);
		random_played = NULL;
	    }
	    cd_track(subchnl.cdsc_trk);
	    break;
	case 3:
	    cd_eject_on_end = 0;
	    break;
	}
#endif
	
#if USE_DSP == 1
	/* decrease dsp settings */
	switch(sel - nr_cd_sel) {
	case 0:
	    if ( (sound_options->speed -= 1000) <= 0)
		sound_options->speed = 0;
	    sound_dsp_update();
	    break;
	case 1:
	    sound_options->channels = (sound_options->channels == 1) ? 2 : 1;
	    sound_dsp_update();
	    break;
	}
#endif

#if USE_MIXER == 1
	/* decrease mixer settings */
	if(sel >= (nr_cd_sel + nr_dsp_sel)) {
	    if ( (MIXER_VOL(sel-nr_cd_sel-nr_dsp_sel) -= 257) < 0) {
		MIXER_VOL(sel-nr_cd_sel-nr_dsp_sel) = 0;
	    }
	    sound_set_mixer();
	}
	break;

    case '.':	/* set mixer setting to 100 */
	if(sel >= (nr_cd_sel + nr_dsp_sel)) {
	    MIXER_VOL(sel-nr_cd_sel-nr_dsp_sel) = 100*256 + 100;
	    sound_set_mixer();
	}
#endif
	break;	
    }
}

int cd_post_key() {

#if USE_CDROM == 1
    if ( skip != 0) {
	cd_next(skip);
	skip = 0;
    }
    if ( fast != 0) {
	cd_fast(fast);
	fast = 0;
    }
#endif

    return 0;
}
