#include "cthugha.h"
#include "interface.h"
#include "sound.h"
#include "keys.h"
#include "options.h"
#include "sound.h"
#include "display.h"
#include "keys.h"
#include "action.h"

#include <limits.h>

static int sel = 0;

char * form_time(int time) {
    static char c[16];
    sprintf(c, "%7.2f", (double)time/100.0);
    return c;
}
char * form_int(int val) {
    static char c[16];
    sprintf(c, "%7d", val);
    return c;
}
char * form_bool(int b) {
    static char c[16];
    sprintf(c, "%7s", b ? "yes" : "no");
    return c;
}

struct T_ {
    char * format;
    char * (* form)();
    int * variable;
    int mod, inc1, inc2;
};
struct T_ T[] = {
    { "%cMinimal Time btw. Change: %7s sec%c",	form_time,	&sound_wait_min,	INT_MAX,10,50},
    { "%c+ Random Time btw. Change:%7s sec%c",	form_time,	&sound_wait_random,	INT_MAX,10,50},
    { "%cQuiet Time:               %7s sec%c",	form_time,	&sound_wait_quiet,	INT_MAX,10,50},
    { "%cSilence Time:             %7s sec%c",	form_time,	&sound_quiet_change,	INT_MAX,10,50},
    { "%cSilence Level:            %7s    %c",	form_int,	&sound_minnoise,	256, 1, 10},
    { "%cFire Level:               %7s    %c",	form_int,	&sound_firelevel,	256, 1, 10},
    { "%cLittle Changes:           %7s    %c",	form_bool,	&change_little,		2, 1,1},
    { "%cAllow FFT:                %7s    %c",	form_bool,	&sound_use_fft,		2, 1,1},
    { "%cAllow Flashlight:         %7s    %c",	form_bool,	&sound_use_flashlight,	2, 1,1},
    { "%cAllow RGB:                %7s    %c",  form_bool,      &flame_use_rgb,         2, 1,1},
};
int Ts = sizeof(T)/sizeof(struct T_);
    
int opt_pre_key() {
    int i;
    char str[256];

    main_text = display_reprint(main_text, 
				"Cthugha Options\n"
				"---------------",
				0, 'l', 0, TEXT_COLOR_HIGHLIGHT);

    for(i=0; i < Ts; i++) {
	sprintf(str, T[i].format, 
		(sel==i) ? '>' : ' ',
		T[i].form( *( T[i].variable) ),
		(sel==i) ? '<' : ' ');
	main_text = display_add_text( main_text, str, 0, 'l', 0, 
				      (sel==i) ? TEXT_COLOR_HIGHLIGHT : TEXT_COLOR_NORMAL);
    }

    return 0;
}

void opt_do_key() {
    int value = 0;

    value = 0;
    switch( int_var.key ) {
    case CK_UP:			/* move cursor up */
	if( -- sel < 0)
	    sel = Ts-1;
	break;
    case CK_DOWN:		/* move curse down */
	if ( ++ sel >= Ts)
	    sel = 0;
	break;
    case CK_RIGHT:		/* increase value */
	value = ((sel < 4) || (sel == 5)) ? 49 : 9;
    case '+': 
	value += 1;
	switch( sel) {
	case 0:
	    sound_wait_min += value;
	    break;
	case 1:
	    sound_wait_random += value;
	    break;
	case 2:
	    sound_wait_quiet += value;
	    break;
	case 3:
	    sound_quiet_change += value;
	    break;
	case 4:
	    sound_minnoise += value;
	    if( sound_minnoise > 255) 
		sound_minnoise = 255;
	    break;
	case 5:
	    sound_firelevel += value;
	    break;
	case 6:
	    change_little = 1 - change_little;
	    break;
	case 7:
	    sound_use_fft = 1 - sound_use_fft;
	    break;
	case 8:
	    sound_use_flashlight = 1 - sound_use_flashlight;
	    break;
	case 9:
	    flame_use_rgb = 1 - flame_use_rgb;
	    break;
	}
	break;
    case CK_LEFT:		/* decrease value */
	value = ((sel < 4) || (sel == 5)) ? 49 : 9;
    case '-': 
	value += 1;
	switch( sel) {
	case 0:
	    sound_wait_min -= value;
	    if ( sound_wait_min < 0)
		sound_wait_min = 0;
	    break;
	case 1:
	    sound_wait_random -= value;
	    if ( sound_wait_random < 0)
		sound_wait_random = 0;
	    break;
	case 2:
	    sound_wait_quiet -= value;
	    if ( sound_wait_quiet < 0)
		sound_wait_quiet = 0;
	    break;
	case 3:
	    sound_quiet_change -= value;
	    if ( sound_quiet_change < 0)
		sound_quiet_change = 0;
	    break;
	case 4:
	    sound_minnoise -= value;
	    if ( sound_minnoise < 0)
		sound_minnoise = 0;
	    break;
	case 5:
	    sound_firelevel -= value;
	    if ( sound_firelevel < 0)
		sound_firelevel = 0;
	    break;
	case 6:
	    change_little = 1 - change_little;
	    break;
	case 7:
	    sound_use_fft = 1 - sound_use_fft;
	    break;
	case 8:
	    sound_use_flashlight = 1 - sound_use_flashlight;
	    break;
	case 9:
	    flame_use_rgb = 1 - flame_use_rgb;
	    break;
	}
	break;
    }
}

