/*
 * Read sound via network from Cthugha server
 */

#include "cthugha.h"
#include "sound.h"
#include "network.h"

#include <errno.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <string.h>
#include <unistd.h>

int REQ_PORT = 5555;
int CLT_PORT = 5556;
int SRV_PORT = 5555;

char sound_hostname[256] = "";

static int sound_net_handle;


/* 
 * create data-socket 
 */
int sound_net_init() {
    printfv(1,"Initializing net-sound...\n");

    /* create socket */
    if( (sound_net_handle = make_socket(SOCK_DGRAM, CLT_PORT)) < 0)
	printfee("Can not create socket.");

    /* set to non-blocking mode */
    fcntl( sound_net_handle, F_SETFL, O_NONBLOCK);
	
    /* send request to server */
    net_request(0); 

    return 0;
}

/* 
 * send a request over the net 
 * request: 0: connect
 *          1: disconnect
 */
int net_request(int request) {
    struct sockaddr_in s_addr;
    struct hostent * hostinfo;
    int request_socket;
    char req[65];

    /* create request-string */
    switch( request) {
    case 0:			/* connect */
	/* request connection from host "sound_hostname" */
	sprintf(req, "connect %ld %d", get_local_addr(), CLT_PORT);
	break;
    case 1:
	/* request for disconnect on exit */
	sprintf(req, "disconnect %ld %d", get_local_addr(), CLT_PORT);
	break;
    default:
	/* unknown request */
	return 1;
    }
    printfv(1,"  Requesting: %c%s%c.\n", 34, req, 34);

    /* create socket for request */
    if( (request_socket = make_socket(SOCK_STREAM, CLT_PORT2)) < 0)
	printfee("Can not create request socket.");

    /* create address of server */
    s_addr.sin_family = AF_INET;
    s_addr.sin_port = htons(SRV_PORT);
    hostinfo = gethostbyname( sound_hostname );
    if ( hostinfo == NULL) {
	printfee("Could not find host %c%s%c.\n", 34,sound_hostname,34);
	close(request_socket);
	return 1;
    } 
    s_addr.sin_addr = *(struct in_addr*)hostinfo->h_addr;
	
    /* connect to server */
    if( connect(request_socket, 
		(struct sockaddr*) &s_addr, 
		sizeof(struct sockaddr) ) < 0) {
	printfee("Can not connect to server %s.\n", sound_hostname);
	close(request_socket);
	return 0;
    }

    /* sending request */
    printfv(1,"  Sending request %c%s%c\n", 34,req,34);
    strcat( req, "\n");
    if( send(request_socket, req, 64, 0) <= 0) {
	printfee("Can not send request.");
    }

    sleep(1);

    /* closing socket */
    if( shutdown(request_socket, 2) )
	printfee("Can not shutdown request-socket.");

    if( close(request_socket) )
	printfee("Can not close request-socket.");

    return 0;
}


/* 
 * read sound from network 
 */
int sound_net_read() {
    int nr_read;

    while( (nr_read = recv(sound_net_handle, 
			   sound_data, 2 * BUFF_WIDTH, 0) ) >= 0);
    return 0;
}

/*
 * sent disconnect-request
 */
int sound_net_exit() {
    net_request(1);
    close(sound_net_handle);
    return 0;
}




