#include "cthugha.h"
#include "sound.h"

#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

char sound_file_name[512];

static FILE * sound_file;

enum sndfile_t{
    sndfile_raw,
    sndfile_wave
};
static enum sndfile_t sound_file_type = sndfile_raw;


#define RIFF		0x46464952	
#define WAVE		0x45564157
#define FMT		0x20746D66
#define DATA		0x61746164
#define PCM_CODE	1
#define WAVE_MONO	1
#define WAVE_STEREO	2

/* it's in chunks like .voc and AMIGA iff, but my source say there
   are in only in this combination, so I combined them in one header;
   it works on all WAVE-file I have
*/
typedef struct _waveheader {
  unsigned long	main_chunk;	/* 'RIFF' */
  unsigned long	length;		/* filelen */
  unsigned long	chunk_type;	/* 'WAVE' */

  unsigned long	sub_chunk;	/* 'fmt ' */
  unsigned long	sc_len;		/* length of sub_chunk, =16 */
  unsigned short format;	/* should be 1 for PCM-code */
  unsigned short modus;		/* 1 Mono, 2 Stereo */
  unsigned long	sample_fq;	/* frequence of sample */
  unsigned long	byte_p_sec;
  unsigned short byte_p_spl;	/* samplesize; 1 or 2 bytes */
  unsigned short bit_p_spl;	/* 8, 12 or 16 bit */ 

  unsigned long	data_chunk;	/* 'data' */
  unsigned long	data_length;	/* samplecount */
} WaveHeader;


int sound_play_init(void) {
    WaveHeader header;

    if( (sound_file = fopen(sound_file_name, "r")) == NULL) {
	printfee("Can not open sound file `%s' for reading.", sound_file_name);
	return 1;
    }
    fread(&header, sizeof(header), 1, sound_file);

    /* is it a .wav file */
    if( (header.main_chunk == RIFF) &&
	(header.chunk_type == WAVE) ) {
	
	sound_options->channels		= header.modus;
	sound_options->bps		= header.bit_p_spl;
	sound_options->speed		= header.sample_fq;

	sound_file_type = sndfile_wave;
    } else {
	printfv(2, "  Unknown sound file format. Using raw data\n");
	sound_file_type = sndfile_raw;
    }

    return 0;
}

int sound_play_read(void) {
    unsigned char sound_buffer[sound_bsize * sound_options->channels * sound_options->bps];

    /* read sound from file */
    fread(sound_buffer, sound_bsize * sound_options->channels * sound_options->bps, 1, sound_file);

    /* play the sound */
#if USE_DSP == 1
    if(sound_use[snddev_dsp_w])
	sound_dsp_write(sound_buffer);
#endif

    /* check for end of file */
    if(feof(sound_file)) { 
	rewind(sound_file);

	/* skip header */
	switch(sound_file_type) {
	case sndfile_wave: {
	    WaveHeader header;
	    fread(&header, sizeof(header), 1, sound_file);
	    break;
	}
	default:
	    ;
	}
    }
    
    sound_convert(sound_buffer, sound_options->channels, sound_options->bps);
    
    return 0;
}

int sound_play_update(void) {
    return 0;
}

int sound_play_exit(void) {
    fclose(sound_file);
#if USE_DSP == 1
    sound_dsp_exit();
#endif
    return 0;
}

