//============================================================================
//
//    SSSS    tt          lll  lll              
//   SS  SS   tt           ll   ll                
//   SS     tttttt  eeee   ll   ll   aaaa    "An Atari 2600 VCS Emulator"
//    SSSS    tt   ee  ee  ll   ll      aa      
//       SS   tt   eeeeee  ll   ll   aaaaa   Copyright (c) 1995,1996,1997
//   SS  SS   tt   ee      ll   ll  aa  aa         Bradford W. Mott
//    SSSS     ttt  eeeee llll llll  aaaaa    
//
//============================================================================

/**
  Abstract base class used for devices that are attached to the System
  in the "core" code.

  @author  Bradford W. Mott
  @version $Id: Device.cxx,v 1.2 1997/05/17 19:00:05 bwmott Exp $
*/

#include "Device.hxx"
#include "System.hxx"

//============================================================================
// Constructor
//============================================================================
Device::Device(System& system)
    : mySystem(system)
{
}

//============================================================================
// Destructor
//============================================================================
Device::~Device()
{
  // Tell system to unmap myself
  mySystem.unmap(*this);
}


