//============================================================================
//
//    SSSS    tt          lll  lll              
//   SS  SS   tt           ll   ll                
//   SS     tttttt  eeee   ll   ll   aaaa    "An Atari 2600 VCS Emulator"
//    SSSS    tt   ee  ee  ll   ll      aa      
//       SS   tt   eeeeee  ll   ll   aaaaa   Copyright (c) 1995,1996,1997
//   SS  SS   tt   ee      ll   ll  aa  aa         Bradford W. Mott
//    SSSS     ttt  eeeee llll llll  aaaaa    
//
//============================================================================

#ifndef TERMINAL_HXX
#define TERMINAL_HXX

class TIA;

#include "machine.hxx"
#include "BasTerm.hxx"
#include "Props.hxx"

/**
  Provides a standard API for terminal display objects.  This
  interface is "old" and shouldn't be used to create any new
  Terminals from.  Instead they should be derived from 
  the BasicTerminal class.

  @author  Bradford W. Mott
  @version $Id: Term.hxx,v 1.2 1997/05/17 19:00:09 bwmott Exp $
*/
class Terminal : public BasicTerminal
{
  public:
    /// Constructor
    Terminal(const Properties& properties);
 
    /// Destructor
    virtual ~Terminal();

  public: 
    /// Update the screen with the TIA frame
    virtual void update(TIA& tia);

    /// Answer the state of the given event
    virtual uLong eventState(Event event);

  private:
    // Process any events releated to the terminal
    void handleEvents();

  private:
    // Indicates if an instance has already been created
    static bool ourInstanceCreated;

    // Pointer to the properties
    const Properties* myProperties;
};
#endif

