/********************************************************************************
 * Copyright (c) Erik Kunze 1995, 1996, 1997
 *
 * Permission to use, distribute, and sell this software and its documentation
 * for any purpose is hereby granted without fee, provided that the above
 * copyright notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that the name
 * of the copyright holder not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior permission.  The
 * copyright holder makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or implied
 * warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
 *
 * THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Erik Kunze
 *
 * changed by EKU
 *******************************************************************************/
#ifndef lint
static char rcsid[] = "$Id: loadsave.c,v 3.17 1997/11/02 12:13:32 erik Rel $";
#endif

#include <X11/keysym.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <assert.h>
#include "z80.h"
#include "debug.h"
#include "resource.h"
#include "mem.h"
#include "util.h"
#include "dialog.h"
#ifndef REGISTERED
#include "menu.h"
#endif
#include "screen.h"
#ifdef REGISTERED
#include "voc.h"
#endif
#include "loadsave.h"


#if defined(sun) && !defined(SVR4)
#define NO_FPOS_T
#endif
#define PAGE_SIZE			17
typedef struct _tapeRecord {
	uns8 id;
	uns8 type;
	char name [11];
	uns16 length;
#ifdef NO_FPOS_T
	long pos;
#else
	fpos_t pos;
#endif
	char current;
} tapeRecord;

static uns8 getNextTapeBitDummy(void);
static void browseTapeDummy(void);
static void browseTapFile(void);
static int getTapeContens(void);
#ifndef REGISTERED
static void displayBlocks(int);
#endif

unsigned short TapeState = TS_TRAPLOAD;
FILE *TapeIn = NULL;
uns8 (*GetNextTapeBit)(void) = getNextTapeBitDummy;
void (*BrowseTape)(void) = browseTapeDummy;

static char *tapeInputFile = NULL;
static char *tapeOutputFile = NULL;
static FILE *tapeOut = NULL;
static int numBlocks = 0;
static llist *blockList = NULL;

void
SetLoadSaveTraps(void)
{
	int	basicRom;
	uns16 loadAddr, saveAddr;
	uns8 loadByte, saveByte;
	basicRom = GET_BASIC_ROM(GETCFG(machine));
	switch(GETCFG(machine))
	{
		default:
		case 48:
			loadAddr = LOAD_ADDR;
			loadByte = LOAD_BPT_BYTE;
			saveAddr = SAVE_ADDR;
			saveByte = SAVE_BPT_BYTE;
			break;
		case 128:
			loadAddr = LOAD_ADDR;
			loadByte = LOAD_BPT_BYTE;
			saveAddr = SAVE_ADDR;
			saveByte = SAVE_BPT_BYTE;
			break;
#ifdef XZX_PLUS3
		case 3:
			loadAddr = LOAD_ADDR_3;
			loadByte = LOAD_BPT_BYTE;
			saveAddr = SAVE_ADDR_3;
			saveByte = SAVE_BPT_BYTE;
			break;
#endif
	}
	if (RealMemory[basicRom][loadAddr] == loadByte)
	{
		RealMemory[basicRom][loadAddr] = 0xed;
		RealMemory[basicRom][loadAddr + 1] = LOAD_BPT;
	}
	else
	{
		Msg(M_WARN, "modified ROM, LOAD disabled");
	}
	if (RealMemory[basicRom][saveAddr] == saveByte)
	{
		RealMemory[basicRom][saveAddr] = 0xed;
		RealMemory[basicRom][saveAddr + 1] = SAVE_BPT;
	}
	else
	{
		Msg(M_WARN, "modified ROM, SAVE disabled");
	}
}


void
Loader(void)
{
	uns16 length, remain;
	int byte, id, crc, error = False;
	ScreenRefresh();
#ifdef DEBUG
	if (GETCFG(debug) & D_TAPE)
	{
		Msg(M_DEBUG, "%s request: id = %02x, addr = %04X, length = %5d",
			F & C_FLAG ? "load" : "verify", A, IX, DE);
	}
#endif
#ifdef REGISTERED
	if (!(TapeState & TS_TRAPLOAD) || TapeState & TS_VOCIN)
	{

		uns16 swap;

		D++;
		F = (F & C_FLAG) |
			(D & (S_FLAG | B5_FLAG | B3_FLAG)) |
			(D ? 0 : Z_FLAG) |
			(D & 0xf ? 0 : H_FLAG) |
			(D == 0x80 ? V_FLAG : 0);

		swap = AF; AF = AF1; AF1 = swap;
		return;
	}
#endif
	if (!(TapeState & TS_TAPIN))
	{
	  newtape:
		if (InsertTape("Load Tape", TO_READ | TO_TAP) == -1)
		{
			PC = 0x0552;
			return;
		}
	}
	if (!(length = getc(TapeIn) + (getc(TapeIn) << 8)))
	{

#ifdef DEBUG
		if (GETCFG(debug) & D_TAPE)
		{
			Msg(M_DEBUG, "%s: id = ff, pos = %6d, block =     0",
				F & C_FLAG ? "loading" : "verifying", (int)ftell(TapeIn) - 3);
		}
#endif
		RET();
		return;
	}
	id = getc(TapeIn);
	remain = length - 1;
	length -= 2;
	if (feof(TapeIn))
	{
#ifdef DEBUG
		if (GETCFG(debug) & D_TAPE)
		{
			Msg(M_DEBUG, "end of tape reached");
		}
#endif
		TapeState &= ~TS_TAPIN;
		(void)fclose(TapeIn);
		TapeIn = NULL;
		free(tapeInputFile);
		tapeInputFile = NULL;
		BrowseTape = browseTapeDummy;
		goto newtape;
	}
	if (id == A)
	{
#ifdef DEBUG
		if (GETCFG(debug) & D_TAPE)
		{
			Msg(M_DEBUG, "%s: id = %02x, pos = %6d, block = %5d",
				F & C_FLAG ? "loading" : "verifying", id, (int)ftell(TapeIn) - 3,
				length);
		}
#endif
		if (DE > length)
		{
			DE = length;
			error = True;
		}
		crc = id;
		while (DE--)
		{
			byte = getc(TapeIn);
			remain--;
			if (F & C_FLAG)
			{
				WR_BYTE(IX, byte);
			}
			else
			{
				if (byte != RD_BYTE(IX))
				{
					error = True;
				}
			}
			IX++;
			crc ^= byte;
		}
		if (!error)
		{
			byte = getc(TapeIn);
			remain--;
			if ((crc ^= byte) != 0)
			{
#ifdef DEBUG
				if (GETCFG(debug) & D_TAPE)
				{
					Msg(M_DEBUG, "checksum error");
				}
#endif
				error = True;
			}
		}
	}
	else
	{
		error = True;
	}
	if (remain)
	{

		(void)fseek(TapeIn, (long)remain, SEEK_CUR);
	}
	if (error)
	{
		F &= Z_FLAG | C_FLAG;
	}
	else
	{
		F |= Z_FLAG | C_FLAG;
	}
	IX += DE;
	DE = 0;

	IFF1 = 1;
	IFF2 = 1;
	RET();
	if (GETCFG(pause))
	{
#ifdef REGISTERED
		ScreenRefresh();
		(void)Dialog(DIALOG_INFO, "Loading paused", "Continue", NULL, 0);
#else

		int oldInDialog = EnterOSD();

		SetBorderColor(LastBorderColor);

		SetCursor(0, ROWS -1);
		PrintString("   Loading paused - press key   ");
		ScreenRefresh();

		if (GetKey() == XK_F1)
		{
			SetBorderColor((MENU_TEXT_ATTR & PAPER) >> 3);
			MainMenu(OSD_HELP);
		}

		LeaveOSD(oldInDialog);
#endif
	}
}

void
Saver(void)
{
	uns16 length;
	int byte, crc;
	ScreenRefresh();
#ifdef DEBUG
	if (GETCFG(debug) & D_TAPE)
	{
		Msg(M_DEBUG, "%stape saving: addr = %04X, length = %04X",
			A ? "headerless " : "",	IX, DE);
	}
#endif
	if (!(TapeState & TS_TAPOUT))
	{
		if (InsertTape("Save Tape", TO_WRITE | TO_TAP) == -1)
		{
			PC = 0x0552;
			return;
		}
	}
	length = DE + 2;
	(void)putc(length & 255, tapeOut);
	(void)putc(length / 256, tapeOut);
	(void)putc(A, tapeOut);
	crc = A;
	while (DE--)
	{
		byte = RD_BYTE(IX);
		(void)putc(byte, tapeOut);
		IX++;
		crc ^= byte;
	}
	(void)putc(crc, tapeOut);
	(void)fflush(tapeOut);
	F |= C_FLAG;
	IX += DE;
	DE = 0;

	IFF1 = 1;
	IFF2 = 1;
	RET();
}

static uns8
getNextTapeBitDummy(void)
{
	return 0;
}

int
InsertTape(char *title, int operation)
{
	char *fileName;
	FILE *fp = NULL;
	char *ext[3] = { NULL, NULL, NULL };
	int i = 0;
	if (operation & TO_TAP)
	{
		ext[i++] = "tap";
	}
#ifdef REGISTERED
	if (operation & TO_VOC)
	{
		assert(operation & TO_READ);
		ext[i++] = "voc";
	}
#endif
	if (operation & TO_READ)
	{
		if ((fileName = FileSelector(title, True, ext[0], ext[1], ext[2])))
		{
			if (!(fp = Fopen(fileName, "rb")))
			{
				Msg(M_PERR, "couldn't open <%s> for reading", fileName);
			}
			else
			{
				switch (GetFileType(fileName))
				{
#ifdef REGISTERED
					case FT_VOC:

						if (VocNewFile(fp) == -1)
						{
							(void)fclose(fp);
							return -1;
						}
						TapeState &= ~(TS_TAPIN | TS_PLAY | TS_ERRIN);
						TapeState |= TS_VOCIN;
						BrowseTape = browseTapeDummy;
						break;
#endif
					case FT_TAP:
						TapeState &= ~(TS_VOCIN | TS_PLAY | TS_ERRIN);
						TapeState |= TS_TAPIN;
						BrowseTape = browseTapFile;
						break;
				}

				GetNextTapeBit = getNextTapeBitDummy;
				if (TapeIn)
				{
					(void)fclose(TapeIn);
					assert(tapeInputFile);
					free(tapeInputFile);
				}
				TapeIn = fp;
				tapeInputFile = fileName;
			}
		}
	}
	else
	{
		if ((fileName = FileSelector(title, False, ext[0], ext[1], ext[2])))
		{
			if (!(fp = Fopen(fileName, "wb")))
			{
				Msg(M_PERR, "couldn't open <%s> for writing", fileName);
			}
			else
			{
				TapeState |= TS_TAPOUT;
				if (tapeOut)
				{
					(void)fclose(tapeOut);
					assert(tapeOutputFile);
					free(tapeOutputFile);
				}
				tapeOut = fp;
				tapeOutputFile = fileName;
			}
		}
	}
	return (fp ? 0 : -1);
}

char *
GetTapeName(int operation)
{
	return (operation == TO_READ ? tapeInputFile : tapeOutputFile);
}

#ifdef REGISTERED
void
StartTapePlayer(void)
{
	assert((TapeState & (TS_VOCIN | TS_ERRIN)) == TS_VOCIN);
	TapeState |= TS_PLAY;
	GetNextTapeBit = VocGetNextBit;
	VocStartPlaying();
}
#endif

#ifdef REGISTERED
void
StopTapePlayer(void)
{
	assert(TapeState & TS_PLAY);
	TapeState &= ~TS_PLAY;
	GetNextTapeBit = getNextTapeBitDummy;
}
#endif

static void
browseTapeDummy(void)
{
}

#ifdef REGISTERED
static void
browseTapFile(void)
{
	char buf[18], **lines;
	int cnt, item;
	tapeRecord *tr;
	assert(TapeIn);

	if ((item = getTapeContens()) != -1 && --numBlocks > 0)
	{
		lines = Malloc(numBlocks * sizeof(char  *), "browseTapFile");
		for (cnt = 0; cnt < numBlocks; cnt++)
		{
			tr = (tapeRecord *)RetrieveElemList(blockList, cnt);
			assert(tr);
			(void)sprintf(buf, "%10s  %5d", tr->name, tr->length);
			lines[cnt] = Strdup(buf, "browseTapFile");
		}
		if ((item = BrowseList("Blocks on input TAP file", lines, numBlocks,
							   item)) != -1)
		{
			tr = (tapeRecord *)RetrieveElemList(blockList, item);
			assert(tr);
			if (!tr->current)
			{
#ifdef NO_FPOS_T
				if (fseek(TapeIn, tr->pos, SEEK_SET) == -1)
#else
				if (fsetpos(TapeIn, &(tr->pos)))
#endif
				{
					Msg(M_PERR, "couldn't set file position");
				}
			}
		}
		while (--numBlocks >= 0)
		{
			free(lines[numBlocks]);
		}
		free(lines);
	}
	DestroyList(blockList, NULL);
	blockList = NULL;
	numBlocks = 0;
}
#else
static void
browseTapFile(void)
{
	int item;
	int oldInDialog;
	tapeRecord *tr;
	assert(TapeIn);

	oldInDialog = EnterOSD();

	{
		char *selectorText[PAGE_SIZE + 2];
		int i;
		selectorText[0] = "Browse Inputfile";
		for (i = 1; i <= NOPTS(selectorText); i++)
		{
			selectorText[i] = " ";
		}
		selectorText[i] = NULL;
		DisplayMenu(selectorText);
	}

	if ((item = getTapeContens()) == -1 || !numBlocks)
	{
		goto quit;
	}
	displayBlocks(item / PAGE_SIZE);
	for (;;)
	{
		switch (BrowseList(&item, numBlocks, PAGE_SIZE, displayBlocks))
		{

			case XK_Return:

				tr = (tapeRecord *)RetrieveElemList(blockList, item);
				assert(tr);
				if (!tr->current)
				{
#ifdef NO_FPOS_T
					if (fseek(TapeIn, tr->pos, SEEK_SET) == -1)
#else
					if (fsetpos(TapeIn, &(tr->pos)))
#endif
					{
						Msg(M_PERR, "couldn't set file position");
					}
				}

			case XK_Escape:
				goto quit;
		}
	}
  quit:
	LeaveOSD(oldInDialog);
	DestroyList(blockList, NULL);
	blockList = NULL;
	numBlocks = 0;
}
#endif

static int
getTapeContens(void)
{
#ifdef NO_FPOS_T
	long curpos;
#else
	fpos_t curpos;
#endif
	tapeRecord *tr;
	int i;
	int current = -1;

#ifdef NO_FPOS_T
	if ((curpos = ftell(TapeIn)) == -1)
#else
	if (fgetpos(TapeIn, &curpos))
#endif
	{
		Msg(M_PERR, "couldn't get file position");
		return -1;
	}
	if (fseek(TapeIn, 0L, SEEK_SET) == -1)
	{
		Msg(M_PERR, "couldn't set file position");
		return -1;
	}
	for (;;)
	{
		tr = Malloc(sizeof(tapeRecord), "getTapeContens");
#ifdef NO_FPOS_T
		tr->pos = ftell(TapeIn);
#else
		(void)fgetpos(TapeIn, &tr->pos);
#endif
		if (!(tr->length = getc(TapeIn) + (getc(TapeIn) << 8)))
		{

			tr->id = 0xff;
		}
		else
		{

			tr->length -= 2;
			tr->id = getc(TapeIn);
		}
		if ((tr->current = (curpos == tr->pos)))
		{
			current = numBlocks;
		}
		blockList = AppendElemList(blockList, (void *)tr);
		numBlocks++;
		if (feof(TapeIn))
		{
			break;
		}
#ifdef DEBUG
		if (GETCFG(debug) & D_TAPE)
		{
			Msg(M_DEBUG, "scaning: id = %02x, pos = %6d, block = %5d",
				tr->id, tr->pos, tr->length);
		}
#endif
		if (!tr->id)
		{
			tr->type = getc(TapeIn);
			for (i = 0; i < 10; i++)
			{
				tr->name[i] = getc(TapeIn);
			}
			tr->name[10] = '\0';
			if (fseek(TapeIn, (long)(tr->length - 10), SEEK_CUR) == 1)
			{
				break;
			}
		}
		else
		{
			tr->name[0] = '\0';
			if (tr->length
				&& fseek(TapeIn, (long)(tr->length + 1), SEEK_CUR) == -1)
			{
				break;
			}
		}
	}

	for (i = numBlocks - 2; i >= 0; i--)
	{
		if (((tapeRecord *)RetrieveElemList(blockList, i))->length)
		{
			break;
		}
	}
	numBlocks = i + 2;
	if (current == -1 || current >= numBlocks)
	{
		current = numBlocks - 1;
	}
#ifdef DEBUG
	if (GETCFG(debug) & D_TAPE)
	{
		Msg(M_DEBUG, "scaning: current = %d, total = %d", current,
			numBlocks - 1);
	}
#endif

#ifdef NO_FPOS_T
	if (fseek(TapeIn, curpos, SEEK_SET) == -1)
#else
	if (fsetpos(TapeIn, &curpos))
#endif
	{
		Msg(M_PERR, "couldn't set file position");
		return -1;
	}
	return current;
}

#ifndef REGISTERED
static void
displayBlocks(int page)
{
	int cnt, cursor_y = MENU_CURSOR_Y;
	tapeRecord *tr;
	char buf[COLS + 1];
	uns8 attr= GetAttr();
	SetAttr(MENU_SELECT_ATTR);
	SetCursor(MENU_CURSOR_X + 1, cursor_y);
	DrawBox(COLS - 2 * (MENU_CURSOR_X + 1), PAGE_SIZE);

	for (cnt = page * PAGE_SIZE;
		 cnt < (page + 1) * PAGE_SIZE && cnt < numBlocks;
		 cnt++)
	{
		tr = (tapeRecord *)RetrieveElemList(blockList, cnt);
		assert(tr);
		if (cnt == numBlocks - 1)
		{
			(void)sprintf(buf, "     *** End Of Tape ***");
		}
		else
		{
			(void)sprintf(buf, "   %03d : %10s  %5d", cnt, tr->name, tr->length);
		}
		if (tr->current)
		{
			SetAttr(MENU_DISABLED_ATTR);
			PrintString(buf);
			SetAttr(MENU_SELECT_ATTR);
		}
		else
		{
			PrintString(buf);
		}
		SetCursor(MENU_CURSOR_X + 1, ++cursor_y);
	}

	SetAttr(attr);
}
#endif

