/********************************************************************************
 * Copyright (c) Des Herriott 1993, 1994
 *               Erik Kunze   1995, 1996, 1997
 *
 * Permission to use, distribute, and sell this software and its documentation
 * for any purpose is hereby granted without fee, provided that the above
 * copyright notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that the name
 * of the copyright holder not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior permission.  The
 * copyright holder makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or implied
 * warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
 *
 * THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Des Herriott
 *         Erik Kunze
 *
 * changed by EKU
 *******************************************************************************/
#ifndef lint
static char z80_ops_c[] = "$Id: z80_ops.c,v 3.7 1997/10/31 20:54:15 erik Rel $";
#endif


case 0x00:
	Tstates += 4;
	break;

case 0x01:
	Tstates += 10;
	BC = RD_WORD(PC);
	PC += 2;
	break;

case 0x02:
	Tstates += 7;
	WR_BYTE(BC, A);
	break;

case 0x03:
	Tstates += 6;
	BC++;
	break;

case 0x04:
	Tstates += 4;
	INC(B);
	break;

case 0x05:
	Tstates += 4;
	DEC(B);
	break;

case 0x06:
	Tstates += 7;
	B = RD_BYTE(PC++);
	break;

case 0x07:
	Tstates += 4;
	A = (A << 1) | (A >> 7);
	F = (F & (S_FLAG | Z_FLAG | V_FLAG)) | (A & (B5_FLAG | B3_FLAG | C_FLAG));
	break;

case 0x08:
	Tstates += 4;
	work16 = AF; AF = AF1; AF1 = work16;
	break;

case 0x09:
	Tstates += 11;
	ADD_HL(BC);
	break;

case 0x0A:
	Tstates += 7;
	A = RD_BYTE(BC);
	break;

case 0x0B:
	Tstates += 6;
	BC--;
	break;

case 0x0C:
	Tstates += 4;
	INC(C);
	break;

case 0x0D:
	Tstates += 4;
	DEC(C);
	break;

case 0x0E:
	Tstates += 7;
	C = RD_BYTE(PC++);
	break;

case 0x0F:
	Tstates += 4;
	F = (F & (S_FLAG | Z_FLAG | V_FLAG)) | (A & C_FLAG);
	A = (A >> 1) | (A << 7);
	F |= A & (B5_FLAG | B3_FLAG);
	break;

case 0x10:
	if (--B)
	{
		Tstates += 13;
		PC += (sgn8)RD_BYTE(PC) + 1;
	}
	else
	{
		Tstates += 8;
		PC++;
	}
	break;

case 0x11:
	Tstates += 10;
	DE = RD_WORD(PC);
	PC += 2;
	break;

case 0x12:
	Tstates += 7;
	WR_BYTE(DE, A);
	break;

case 0x13:
	Tstates += 6;
	DE++;
	break;

case 0x14:
	Tstates += 4;
	INC(D);
	break;

case 0x15:
	Tstates += 4;
	DEC(D);
	break;

case 0x16:
	Tstates += 7;
	D = RD_BYTE(PC++);
	break;

case 0x17:
	Tstates += 4;
	work8 = A >> 7;
	A = (A << 1) | (F & C_FLAG);
	F = (F & (S_FLAG | Z_FLAG | V_FLAG)) | (A & (B5_FLAG | B3_FLAG)) | work8;
	break;

case 0x18:
	Tstates += 12;
	JR;
	break;

case 0x19:
	Tstates += 11;
	ADD_HL(DE);
	break;

case 0x1A:
	Tstates += 7;
	A = RD_BYTE(DE);
	break;

case 0x1B:
	Tstates += 6;
	DE--;
	break;

case 0x1C:
	Tstates += 4;
	INC(E);
	break;

case 0x1D:
	Tstates += 4;
	DEC(E);
	break;

case 0x1E:
	Tstates += 7;
	E = RD_BYTE(PC++);
	break;

case 0x1F:
	Tstates += 4;
	work8 = A & C_FLAG;
	A = (A >> 1) | (F << 7);
	F = (F & (S_FLAG | Z_FLAG | V_FLAG)) | (A & (B5_FLAG | B3_FLAG)) | work8;
	break;

case 0x20:
	if (!(F & Z_FLAG))
	{
		Tstates += 12;
		JR;
	}
	else
	{
		Tstates += 7;
		PC++;
	}
	break;

case 0x21:
	Tstates += 10;
	HL = RD_WORD(PC);
	PC += 2;
	break;

case 0x22:
	Tstates += 16;
	WR_WORD(RD_WORD(PC), HL);
	PC += 2;
	break;

case 0x23:
	Tstates += 6;
	HL++;
	break;

case 0x24:
	Tstates += 4;
	INC(H);
	break;

case 0x25:
	Tstates += 4;
	DEC(H);
	break;

case 0x26:
	Tstates += 7;
	H = RD_BYTE(PC++);
	break;

case 0x27:
	Tstates += 4;
	carry = F & C_FLAG;
	if (!(sub = F & N_FLAG))
	{
		add = 0;
		if ((F & H_FLAG) || (A & 0x0f) > 9)
		{
			add = 0x06;
		}
		if ((F & C_FLAG) || (A >> 4) > 9 || ((A >> 4) >= 9 && (A & 0x0f) > 9))
		{
			add |= 0x60;
			carry = 1;
		}
	}
	else
	{
		if (F & C_FLAG)
		{
			add = (F & H_FLAG) ? 0x9a : 0xa0;
		}
		else
		{
			add = (F & H_FLAG) ? 0xfa : 0x00;
		}
	}
	ADD(add);
	F = (F & ~(N_FLAG | P_FLAG | C_FLAG)) | sub | PARITY(A) | carry;
	break;

case 0x28:
	if (F & Z_FLAG)
	{
		Tstates += 12;
		JR;
	}
	else
	{
		Tstates += 7;
		PC++;
	}
	break;

case 0x29:
	Tstates += 11;
	ADD_HL(HL);
	break;

case 0x2A:
	Tstates += 16;
	HL = RD_WORD(RD_WORD(PC));
	PC += 2;
	break;

case 0x2B:
	Tstates += 6;
	HL--;
	break;

case 0x2C:
	Tstates += 4;
	INC(L);
	break;

case 0x2D:
	Tstates += 4;
	DEC(L);
	break;

case 0x2E:
	Tstates += 7;
	L = RD_BYTE(PC++);
	break;

case 0x2F:
	Tstates += 4;
	A ^= 0xff;
	F = (F & (S_FLAG | Z_FLAG | V_FLAG | C_FLAG)) | (A & (B5_FLAG | B3_FLAG)) |
		(H_FLAG | N_FLAG);
	break;

case 0x30:
	if(!(F & C_FLAG))
	{
		Tstates += 12;
		JR;
	}
	else
	{
		Tstates += 7;
		PC++;
	}
	break;

case 0x31:
	Tstates += 10;
	SP = RD_WORD(PC);
	PC += 2;
	break;

case 0x32:
	Tstates += 13;
	WR_BYTE(RD_WORD(PC), A);
	PC += 2;
	break;

case 0x33:
	Tstates += 6;
	SP++;
	break;

case 0x34:
	Tstates += 11;
	work8 = RD_BYTE(HL);
	INC(work8);
	WR_BYTE(HL, work8);
	break;

case 0x35:
	Tstates += 11;
	work8 = RD_BYTE(HL);
	DEC(work8);
	WR_BYTE(HL, work8);
	break;

case 0x36:
	Tstates += 10;
	WR_BYTE(HL, RD_BYTE(PC++));
	break;

case 0x37:
	Tstates += 4;
	F = (F & (S_FLAG | Z_FLAG | V_FLAG)) | (A & (B5_FLAG | B3_FLAG)) | C_FLAG;
	break;

case 0x38:
	if (F & C_FLAG)
	{
		Tstates += 12;
		JR;
	}
	else {
		Tstates += 7;
		PC++;
	}
	break;

case 0x39:
	Tstates += 11;
	ADD_HL(SP);
	break;

case 0x3A:
	Tstates += 13;
	A = RD_BYTE(RD_WORD(PC));
	PC += 2;
	break;

case 0x3B:
	Tstates += 6;
	SP--;
	break;

case 0x3C:
	Tstates += 4;
	INC(A);
	break;

case 0x3D:
	Tstates += 4;
	DEC(A);
	break;

case 0x3E:
	Tstates += 7;
	A = RD_BYTE(PC++);
	break;

case 0x3F:
	Tstates += 4;
	F = (F & (S_FLAG | Z_FLAG | V_FLAG)) | (A & (B5_FLAG | B3_FLAG)) |
		(F & C_FLAG ? H_FLAG : C_FLAG);
	break;

case 0x40:
	Tstates += 4;
	break;

case 0x41:
	Tstates += 4;
	B = C;
	break;

case 0x42:
	Tstates += 4;
	B = D;
	break;

case 0x43:
	Tstates += 4;
	B = E;
	break;

case 0x44:
	Tstates += 4;
	B = H;
	break;

case 0x45:
	Tstates += 4;
	B = L;
	break;

case 0x46:
	Tstates += 7;
	B = RD_BYTE(HL);
	break;

case 0x47:
	Tstates += 4;
	B = A;
	break;

case 0x48:
	Tstates += 4;
	C = B;
	break;

case 0x49:
	Tstates += 4;
	break;

case 0x4A:
	Tstates += 4;
	C = D;
	break;

case 0x4B:
	Tstates += 4;
	C = E;
	break;

case 0x4C:
	Tstates += 4;
	C = H;
	break;

case 0x4D:
	Tstates += 4;
	C = L;
	break;

case 0x4E:
	Tstates += 7;
	C = RD_BYTE(HL);
	break;

case 0x4F:
	Tstates += 4;
	C = A;
	break;

case 0x50:
	Tstates += 4;
	D = B;
	break;

case 0x51:
	Tstates += 4;
	D = C;
	break;

case 0x52:
	Tstates += 4;
	break;

case 0x53:
	Tstates += 4;
	D = E;
	break;

case 0x54:
	Tstates += 4;
	D = H;
	break;

case 0x55:
	Tstates += 4;
	D = L;
	break;

case 0x56:
	Tstates += 7;
	D = RD_BYTE(HL);
	break;

case 0x57:
	Tstates += 4;
	D = A;
	break;

case 0x58:
	Tstates += 4;
	E = B;
	break;

case 0x59:
	Tstates += 4;
	E = C;
	break;

case 0x5A:
	Tstates += 4;
	E = D;
	break;

case 0x5B:
	Tstates += 4;
	break;

case 0x5C:
	Tstates += 4;
	E = H;
	break;

case 0x5D:
	Tstates += 4;
	E = L;
	break;

case 0x5E:
	Tstates += 7;
	E = RD_BYTE(HL);
	break;

case 0x5F:
	Tstates += 4;
	E = A;
	break;

case 0x60:
	Tstates += 4;
	H = B;
	break;

case 0x61:
	Tstates += 4;
	H = C;
	break;

case 0x62:
	Tstates += 4;
	H = D;
	break;

case 0x63:
	Tstates += 4;
	H = E;
	break;

case 0x64:
	Tstates += 4;
	break;

case 0x65:
	Tstates += 4;
	H = L;
	break;

case 0x66:
	Tstates += 7;
	H = RD_BYTE(HL);
	break;

case 0x67:
	Tstates += 4;
	H = A;
	break;

case 0x68:
	Tstates += 4;
	L = B;
	break;

case 0x69:
	Tstates += 4;
	L = C;
	break;

case 0x6A:
	Tstates += 4;
	L = D;
	break;

case 0x6B:
	Tstates += 4;
	L = E;
	break;

case 0x6C:
	Tstates += 4;
	L = H;
	break;

case 0x6D:
	Tstates += 4;
	break;

case 0x6E:
	Tstates += 7;
	L = RD_BYTE(HL);
	break;

case 0x6F:
	Tstates += 4;
	L = A;
	break;

case 0x70:
	Tstates += 7;
	WR_BYTE(HL, B);
	break;

case 0x71:
	Tstates += 7;
	WR_BYTE(HL, C);
	break;

case 0x72:
	Tstates += 7;
	WR_BYTE(HL, D);
	break;

case 0x73:
	Tstates += 7;
	WR_BYTE(HL, E);
	break;

case 0x74:
	Tstates += 7;
	WR_BYTE(HL, H);
	break;

case 0x75:
	Tstates += 7;
	WR_BYTE(HL, L);
	break;

case 0x76:
	Tstates += 4;
	PC--;
	break;

case 0x77:
	Tstates += 7;
	WR_BYTE(HL, A);
	break;

case 0x78:
	Tstates += 4;
	A = B;
	break;

case 0x79:
	Tstates += 4;
	A = C;
	break;

case 0x7A:
	Tstates += 4;
	A = D;
	break;

case 0x7B:
	Tstates += 4;
	A = E;
	break;

case 0x7C:
	Tstates += 4;
	A = H;
	break;

case 0x7D:
	Tstates += 4;
	A = L;
	break;

case 0x7E:
	Tstates += 7;
	A = RD_BYTE(HL);
	break;

case 0x7F:
	Tstates += 4;
	break;

case 0x80:
	Tstates += 4;
	ADD(B);
	break;

case 0x81:
	Tstates += 4;
	ADD(C);
	break;

case 0x82:
	Tstates += 4;
	ADD(D);
	break;

case 0x83:
	Tstates += 4;
	ADD(E);
	break;

case 0x84:
	Tstates += 4;
	ADD(H);
	break;

case 0x85:
	Tstates += 4;
	ADD(L);
	break;

case 0x86:
	Tstates += 7;
	work8 = RD_BYTE(HL);
	ADD(work8);
	break;

case 0x87:
	Tstates += 4;
	ADD(A);
	break;

case 0x88:
	Tstates += 4;
	ADC(B);
	break;

case 0x89:
	Tstates += 4;
	ADC(C);
	break;

case 0x8A:
	Tstates += 4;
	ADC(D);
	break;

case 0x8B:
	Tstates += 4;
	ADC(E);
	break;

case 0x8C:
	Tstates += 4;
	ADC(H);
	break;

case 0x8D:
	Tstates += 4;
	ADC(L);
	break;

case 0x8E:
	Tstates += 7;
	work8 = RD_BYTE(HL);
	ADC(work8);
	break;

case 0x8F:
	Tstates += 4;
	ADC(A);
	break;

case 0x90:
	Tstates += 4;
	SUB(B);
	break;

case 0x91:
	Tstates += 4;
	SUB(C);
	break;

case 0x92:
	Tstates += 4;
	SUB(D);
	break;

case 0x93:
	Tstates += 4;
	SUB(E);
	break;

case 0x94:
	Tstates += 4;
	SUB(H);
	break;

case 0x95:
	Tstates += 4;
	SUB(L);
	break;

case 0x96:
	Tstates += 7;
	work8 = RD_BYTE(HL);
	SUB(work8);
	break;

case 0x97:
	Tstates += 7;
	SUB(A);
	break;

case 0x98:
	Tstates += 4;
	SBC(B);
	break;

case 0x99:
	Tstates += 4;
	SBC(C);
	break;

case 0x9A:
	Tstates += 4;
	SBC(D);
	break;

case 0x9B:
	Tstates += 4;
	SBC(E);
	break;

case 0x9C:
	Tstates += 4;
	SBC(H);
	break;

case 0x9D:
	Tstates += 4;
	SBC(L);
	break;

case 0x9E:
	Tstates += 7;
	work8 = RD_BYTE(HL);
	SBC(work8);
	break;

case 0x9F:
	Tstates += 4;
	SBC(A);
	break;

case 0xA0:
	Tstates += 4;
	AND(B);
	break;

case 0xA1:
	Tstates += 4;
	AND(C);
	break;

case 0xA2:
	Tstates += 4;
	AND(D);
	break;

case 0xA3:
	Tstates += 4;
	AND(E);
	break;

case 0xA4:
	Tstates += 4;
	AND(H);
	break;

case 0xA5:
	Tstates += 4;
	AND(L);
	break;

case 0xA6:
	Tstates += 7;
	work8 = RD_BYTE(HL);
	AND(work8);
	break;

case 0xA7:
	Tstates += 4;
	AND(A);
	break;

case 0xA8:
	Tstates += 4;
	XOR(B);
	break;

case 0xA9:
	Tstates += 4;
	XOR(C);
	break;

case 0xAA:
	Tstates += 4;
	XOR(D);
	break;

case 0xAB:
	Tstates += 4;
	XOR(E);
	break;

case 0xAC:
	Tstates += 4;
	XOR(H);
	break;

case 0xAD:
	Tstates += 4;
	XOR(L);
	break;

case 0xAE:
	Tstates += 7;
	work8 = RD_BYTE(HL);
	XOR(work8);
	break;

case 0xAF:
	Tstates += 4;
	XOR(A);
	break;

case 0xB0:
	Tstates += 4;
	OR(B);
	break;

case 0xB1:
	Tstates += 4;
	OR(C);
	break;

case 0xB2:
	Tstates += 4;
	OR(D);
	break;

case 0xB3:
	Tstates += 4;
	OR(E);
	break;

case 0xB4:
	Tstates += 4;
	OR(H);
	break;

case 0xB5:
	Tstates += 4;
	OR(L);
	break;

case 0xB6:
	Tstates += 7;
	work8 = RD_BYTE(HL);
	OR(work8);
	break;

case 0xB7:
	Tstates += 4;
	OR(A);
	break;

case 0xB8:
	Tstates += 4;
	CMP(B);
	break;

case 0xB9:
	Tstates += 4;
	CMP(C);
	break;

case 0xBA:
	Tstates += 4;
	CMP(D);
	break;

case 0xBB:
	Tstates += 4;
	CMP(E);
	break;

case 0xBC:
	Tstates += 4;
	CMP(H);
	break;

case 0xBD:
	Tstates += 4;
	CMP(L);
	break;

case 0xBE:
	Tstates += 7;
	work8 = RD_BYTE(HL);
	CMP(work8);
	break;

case 0xBF:
	Tstates += 4;
	CMP(A);
	break;

case 0xC0:
	Tstates += 5;
	if (!(F & Z_FLAG))
	{
		Tstates += 6;
		RET;
	}
	break;

case 0xC1:
	Tstates += 10;
	POP(BC);
	break;

case 0xC2:
	Tstates += 10;
	if (!(F & Z_FLAG))
	{
		JP;
	}
	else
	{
		PC += 2;
	}
	break;

case 0xC3:
	Tstates += 10;
	PC = RD_WORD(PC);
	break;

case 0xC4:
	if (!(F & Z_FLAG))
	{
		Tstates += 17;
		CALL;
	}
	else
	{
		Tstates += 10;
		PC += 2;
	}
	break;

case 0xC5:
	Tstates += 11;
	PUSH(BC);
	break;

case 0xC6:
	Tstates += 7;
	work8 = RD_BYTE(PC++);
	ADD(work8);
	break;

case 0xC7:
	Tstates += 11;
	RST(0x0000);
	break;

case 0xC8:
	Tstates += 5;
	if (F & Z_FLAG)
	{
		Tstates += 6;
		RET;
	}
	break;

case 0xC9:
	Tstates += 10;
	POP(PC);
	break;

case 0xCA:
	Tstates += 10;
	if (F & Z_FLAG)
	{
		JP;
	}
	else
	{
		PC += 2;
	}
	break;

case 0xCB:
	Z80_M1(op);
#ifndef HAVE_ENOUGH_SWAP
	z80_DecodeCB(op);
#else
	switch (op)
	{
#		include "z80_cbops.c"
	}
#endif
	break;

case 0xCC:
	if (F & Z_FLAG)
	{
		Tstates += 17;
		CALL;
	}
	else
	{
		Tstates += 10;
		PC += 2;
	}
	break;

case 0xCD:
	Tstates += 17;
	CALL;
	break;

case 0xCE:
	Tstates += 7;
	work8 = RD_BYTE(PC++);
	ADC(work8);
	break;

case 0xCF:
	Tstates += 11;
	RST(0x0008);
	break;

case 0xD0:
	Tstates += 5;
	if (!(F & C_FLAG))
	{
		Tstates += 6;
		RET;
	}
	break;

case 0xD1:
	Tstates += 10;
	POP(DE);
	break;

case 0xD2:
	Tstates += 10;
	if (!(F & C_FLAG))
	{
		JP;
	}
	else
	{
		PC += 2;
	}
	break;

case 0xD3:
	Tstates += 11;
	OutByte((A << 8) | RD_BYTE(PC++), A);
	break;

case 0xD4:
	if (!(F & C_FLAG))
	{
		Tstates += 17;
		CALL;
	}
	else
	{
		Tstates += 10;
		PC += 2;
	}
	break;

case 0xD5:
	Tstates += 11;
	PUSH(DE);
	break;

case 0xD6:
	Tstates += 7;
	work8 = RD_BYTE(PC++);
	SUB(work8);
	break;

case 0xD7:
	Tstates += 11;
	RST(0x0010);
	break;

case 0xD8:
	Tstates += 5;
	if (F & C_FLAG)
	{
		Tstates += 6;
		RET;
	}
	break;

case 0xD9:
	Tstates += 4;
	work16 = BC; BC = BC1; BC1 = work16;
	work16 = DE; DE = DE1; DE1 = work16;
	work16 = HL; HL = HL1; HL1 = work16;
	break;

case 0xDA:
	Tstates += 10;
	if (F & C_FLAG)
	{
		JP;
	}
	else
	{
		PC += 2;
	}
	break;

case 0xDB:
	Tstates += 11;
	A = InByte((A << 8) | RD_BYTE(PC++));
	break;

case 0xDC:
	if (F & C_FLAG)
	{
		Tstates += 17;
		CALL;
	}
	else
	{
		Tstates += 10;
		PC += 2;
	}
	break;

case 0xDD:
	Z80_M1(op);
#ifndef HAVE_ENOUGH_SWAP
	z80_DecodeDD(op);
#else
	switch (op)
	{
#		define XX  IX
#		define LXX LIX
#		define HXX HIX
#		include "z80_xxops.c"
#		undef XX
#		undef LXX
#		undef HXX
	}
#endif
	break;

case 0xDE:
	Tstates += 7;
	work8 = RD_BYTE(PC++);
	SBC(work8);
	break;

case 0xDF:
	Tstates += 11;
	RST(0x0018);
	break;

case 0xE0:
	Tstates += 5;
	if (!(F & P_FLAG))
	{
		Tstates += 6;
		RET;
	}
	break;

case 0xE1:
	Tstates += 10;
	POP(HL);
	break;

case 0xE2:
	Tstates += 10;
	if (!(F & P_FLAG))
	{
		JP;
	}
	else
	{
		PC += 2;
	}
	break;

case 0xE3:
	Tstates += 19;
	work16 = RD_WORD(SP);
	WR_WORD(SP, HL);
	HL = work16;
	break;

case 0xE4:
	if (!(P_FLAG))
	{
		Tstates += 17;
		CALL;
	}
	else
	{
		Tstates += 10;
		PC += 2;
	}
	break;

case 0xE5:
	Tstates += 11;
	PUSH(HL);
	break;

case 0xE6:
	Tstates += 7;
	work8 = RD_BYTE(PC++);
	AND(work8);
	break;

case 0xE7:
	Tstates += 11;
	RST(0x0020);
	break;

case 0xE8:
	Tstates += 5;
	if (F & P_FLAG)
	{
		Tstates += 6;
		RET;
	}
	break;

case 0xE9:
	Tstates += 4;
	PC = HL;
	break;

case 0xEA:
	Tstates += 10;
	if (F & P_FLAG)
	{
		JP;
	}
	else
	{
		PC += 2;
	}
	break;

case 0xEB:
	Tstates += 4;
	work16 = DE, DE = HL, HL = work16;
	break;

case 0xEC:
	if (F & P_FLAG)
	{
		Tstates += 17;
		CALL;
	}
	else
	{
		Tstates += 10;
		PC += 2;
	}
	break;

case 0xED:
	Z80_M1(op);
#ifndef HAVE_ENOUGH_SWAP
	z80_DecodeED(op);
#else
	switch (op)
	{
#		include "z80_edops.c"
	}
#endif
	break;

case 0xEE:
	Tstates += 7;
	work8 = RD_BYTE(PC++);
	XOR(work8);
	break;

case 0xEF:
	Tstates += 11;
	RST(0x0028);
	break;

case 0xF0:
	Tstates += 5;
	if (!(F & S_FLAG))
	{
		Tstates += 6;
		RET;
	}
	break;

case 0xF1:
	Tstates += 10;
	POP(AF);
	break;

case 0xF2:
	Tstates += 10;
	if (!(F & S_FLAG))
	{
		JP;
	}
	else
	{
		PC += 2;
	}
	break;

case 0xF3:
	Tstates += 4;
	IFF1 = 0;
	IFF2 = 0;
	break;

case 0xF4:
	if (!(F & S_FLAG))
	{
		Tstates += 17;
		CALL;
	}
	else
	{
		Tstates += 10;
		PC += 2;
	}
	break;

case 0xF5:
	Tstates += 11;
	PUSH(AF);
	break;

case 0xF6:
	Tstates += 7;
	work8 = RD_BYTE(PC++);
	OR(work8);
	break;

case 0xF7:
	Tstates += 11;
	RST(0x0030);
	break;

case 0xF8:
	Tstates += 5;
	if (F & S_FLAG)
	{
		Tstates += 6;
		RET;
	}
	break;

case 0xF9:
	Tstates += 6;
	SP = HL;
	break;

case 0xFA:
	Tstates += 10;
	if (F & S_FLAG)
	{
		JP;
	}
	else
	{
		PC += 2;
	}
	break;

case 0xFB:
	Tstates += 4;
	IFF1 = 1;
	IFF2 = 1;
	break;

case 0xFC:
	if (F & S_FLAG)
	{
		Tstates += 17;
		CALL;
	}
	else
	{
		Tstates += 10;
		PC += 2;
	}
	break;

case 0xFD:
	Z80_M1(op);
#ifndef HAVE_ENOUGH_SWAP
	z80_DecodeFD(op);
#else
	switch (op)
	{
#		define NO_RCSID
#		define XX  IY
#		define LXX LIY
#		define HXX HIY
#		include "z80_xxops.c"
#		undef XX
#		undef LXX
#		undef HXX
#		undef NO_RCSID
	}
#endif
	break;

case 0xFE:
	Tstates += 7;
	work8  = RD_BYTE(PC++);
	CMP(work8);
	break;

case 0xFF:
	Tstates += 11;
	RST(0x0038);
	break;

