#include <stdio.h>
#include <string.h>
#include <config.h>
#include <mpegsound.h>
#include "mp3info.h"
#include <signal.h>


static int canplay,lastsig;

void sighandler(int sig) {
   canplay=0;
   lastsig=sig;
   return;
}

bool Mpfile::play(int threads) {
   Soundplayer *player;
   Soundinputstream *loader;
   Mpegtoraw *server;
   struct sigaction sigstruc;
   
   player=new Rawplayer;
   if (!player || !player->initialize("/dev/dsp")) {
      fprintf(stderr,"Couldn't open sound device.\n");
      return(false);
   }

   loader=new Soundinputstreamfromfile;
   if (!loader || !loader->open(filename)) {
      fprintf(stderr,"Couldn't open file for playing.\n");
      return(false);
   }

   server=new Mpegtoraw(loader,player);
   if (!server) {
      fprintf(stderr,"Couldn't initialize MP3 player.\n");
      return(false);
   }
   server->initialize(NULL);   
   server->setforcetomono(0);

   sigstruc.sa_handler=sighandler;
   memset(&sigstruc.sa_mask,0,sizeof(sigstruc.sa_mask));
   sigstruc.sa_flags=SA_RESTART;

   sigaction(SIGHUP,&sigstruc,NULL);
   sigaction(SIGTERM,&sigstruc,NULL);

#ifdef PTHREADEDMPEG
   if (threads>20)
     server->makethreadedplayer(threads);
#endif

   if(!server->run(-1)) {
      fprintf(stderr,"Failed to init MP3 player.\n");
      return(false);
   }

   canplay=1;
   lastsig=0;

   while (canplay && server->run(40));

#ifdef PTHREADEDMPEG
   if (threads>20)
     server->freethreadedplayer();
#endif

   if(server->geterrorcode()>0) {
      fprintf(stderr,"Error during play.\n");
      delete loader;
      delete player;
      return(false);
   }
   
   delete server;
   delete player;
   delete loader;

   if (lastsig==SIGTERM) exit(0);
   return(true);
}
