/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                      Copyright (c) 1995,1996                          */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                    Author :  Simon King                               */
/*                    Date   :  January 1997                             */
/*-----------------------------------------------------------------------*/
/*              Hypothesis class for stack decoder                       */
/*                                                                       */
/*=======================================================================*/


#include "Hypothesis.h"
#include <string.h>
#include <stdlib.h>


Hypothesis::Hypothesis() : Heap_Item(0.0){}

Hypothesis::Hypothesis(float initial_eval_fn) : Heap_Item(initial_eval_fn)
{
    h_partial_log_prob = 0.0;
    h_estimated_remaining_log_prob = 0.0;
}

Hypothesis::Hypothesis(Hypothesis *h)
{

    // no - need to COPY model states .....

    cerr << "broken !" << endl;
    h_partial_log_prob = h->h_partial_log_prob;
    h_estimated_remaining_log_prob = h->h_estimated_remaining_log_prob;
    h_length = h->h_length;
    acoustic_model_state = h->acoustic_model_state;
    language_model_state = h->language_model_state;
}


Hypothesis::~Hypothesis(){

    // can't delete model states here - don't know their type

}

bool
Hypothesis::is_finished(){

    // not here - do in Decoder
    return false;

}

int operator > (Hypothesis& h1, Hypothesis& h2){

    // used for heap ordering only
    return (h1.h_eval_fn > h2.h_eval_fn);

}


ostream&
operator << (ostream& ost, Hypothesis &h)
{
    (void)h;
    ost << "Hypothesis";

    return ost;
}

