 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /************************************************************************/
 /*                 Author: Richard Caley (rjc@cstr.ed.ac.uk)            */
 /*                   Date: Fri Apr  4 1997                              */
 /************************************************************************/
 /*                                                                      */
 /* Hash table.                                                          */
 /*                                                                      */
 /************************************************************************/

#ifndef __EST_THASH_H__
#define __EST_THASH_H__

#include "iostream.h"
#include "EST_KV.h"
#include "EST_String.h"

class EST_HashFunctions {
public:
  static unsigned int DefaultHash(const void *data, size_t size, unsigned int n);
  static  unsigned int StringHash(const EST_String &key, unsigned int size);
};

template<class K, class V>
class EST_Hash_Pair {
public:
  K key;
  V value;
  EST_Hash_Pair<K,V> *next;
};

template<class K, class V>
class EST_THash : protected EST_HashFunctions {
private:
  static V Dummy_Value;
  unsigned int p_num_entries;
  unsigned int p_num_buckets;
  EST_Hash_Pair<K,V> **p_buckets;
  unsigned int (*p_hash_function)(const K &key, unsigned int size);

public:
  EST_THash(int size,  unsigned int (*hash_function)(const K &key, unsigned int size)= NULL);
  ~EST_THash(void);

  void clear(void);
  unsigned int num_entries(void) const { return p_num_entries; };

  int present(const K &key) const;

  V &val(const K &key, int &found) const;
  V &val(const K &key) const {int x; return val(key, x); };

  void map(void (*func)(K&, V&));		// apply function to each pair
    
  int add_item(const K &key, const V &value, int no_search = 0);

  void dump(ostream &stream, int all=0);
};

template<class V>
class EST_TStringHash : public EST_THash<EST_String, V> {
public:
  EST_TStringHash(int size) : EST_THash<EST_String, V>(size, StringHash) {};
};

inline static unsigned int DefaultHashFunction(const void *data, size_t size, unsigned int n)
{
  unsigned int x=0;
  const char *p = (const char *)data;
  for(; size>0 ; p++, size--)
      x = ((x+*p)*33) % n;
  return x;
}


#endif
