/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                      Copyright (c) 1995,1996                          */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                   Author :  Paul Taylor                               */
/*                   Date   :  April 1994                                */
/*************************************************************************/

//#include "cstrtools.h"
#include <stdlib.h>
#include <stdio.h>
#include "iostream.h"
#include "fstream.h"
#include "EST_Utterance.h"

static int lo = 1000;

void aslab(ostream *outf, float fx, float fy, EST_String lab)
{
    EST_String r;
    // approx. centring of text. 20 point text, 8 chars per inch.
    int off = - (int)(((float)lab.length() * 150.0) / 2.0) + lo;
    int x1 = int(fx * 6000.0);
    int y1 = int(fy * 6000.0);
    
    *outf << "4 0 -1 0 0 18 20 0.0000000 4 165 165 ";
    *outf << x1  + off<< " " << y1 << " " << lab << "\\001\n";
}

void aslink(ostream *outf, float fx1, float fx2, float fy1, float fy2, int col_num)
{
    EST_String r;
    int off = 0;
    float mod1 = -3.0;
    float mod2 = 1.0;
    int x1 = int(fx1 * 6000.0) + lo;
    int x2 = int(fx2 * 6000.0) + lo;
    int y1 = int(fy1 * 6000.0) + int(mod1 * 100.0);
    int y2 = int(fy2 * 6000.0) + int(mod2 * 100.0);
    
    *outf << "2 1 0 2 " << col_num << " 7 0 0 -1 0.000 0 0 -1 0 0 2\n";
    *outf << "\t" << x1 + 50 + off << " " << y1 << " ";
    *outf << x2 + 50 + off << " " << y2 << "\n";
}

void asbox(ostream *outf, float fx1, float fx2, float fy1)
{
    int x1 = int(fx1 * 6000.0) + lo;
    int x2 = int(fx2 * 6000.0) + lo;
    int y1 = int(fy1 * 6000.0);
    y1 += 100;
    int y2 = y1 - 400;
    *outf << "2 4 0 1 -1 7 0 0 -1 0.000 0 0 7 0 0 5\n";
    *outf << "\t" << x1 << " " << y1 << " " << x2 << " " << y1 << " " << x2 << " " << y2 << " " << x1 << " " << y2 << " " << x1 << " " << y1 << endl;
}

int display_links(EST_String filename, EST_Utterance &u)
{
    int i, j, n;
    float length;
    EST_Stream_Item *p_ev, *p_syl;
    EST_TBI *up, *lp;
    EST_TBI *rev;
    
    ostream *outf;
    if (filename == "-")
	outf = &cout;
    else
	outf = new ofstream(filename);
    
    if (outf == 0)  {
	cerr << "Can't open label output file " << filename << endl;
	return -1;
    }
    
    outf->precision(4);
    
    *outf << "#FIG 3.1\n";
    *outf << "Landscape\n";
    *outf << "Center\n";
    *outf << "Inches\n";
    *outf << "1200 2\n";
    
    float v_ref = 0.5;
    float v_step = 0.35;
    float v_pos1, v_pos2;
    
    up = u.s.head();
    length = u.s(up).tail()->end();
    n = int(length * 5.0);

    cout << "Testing phoneme 15\n";
    cout << u.stream("Phoneme");

    p_ev = u.item("Phoneme", 15);
    cout << *p_ev << endl;

    
    // draw time axis
/*    *outf << "2 1 0 1 -1 7 0 0 -1 0.000 0 0 -1 0 0 2\n";
    *outf << "\t " << off << " 5500 " <<(int(length) * 6000) + off + lo<< " 5500\n";
    for (i = 0; i < n; ++i)
    {
	npos = (i * 1200) + off;
	*outf << "2 1 0 1 -1 7 0 0 -1 0.000 0 0 -1 0 0 2\n";
	*outf << "\t " << npos << " 5500 " << npos << " 5200\n";
	*outf<<"4 0 -1 0 0 0 12 0.0000000 4 135 270 " << npos - 140 <<" 5700 " 
	    << i * 200 <<  "\\001\n";
    }
  */  
    // draw units
    EST_String i_sn, r_sn;
    int k, col;
    
    // draw links
    for (i = j = 0, up = u.s.head(); up != 0; up = next(up), ++i)
    {
	v_pos1 = v_ref + (float(u.s.index(up)) * v_step);
	i_sn = u.s(up).stream_name();
	
	for (p_syl = u.s(up).head(); p_syl != 0; p_syl = next(p_syl))
	    if (p_syl->feature("pos") == 1)
	    {
		for (j = 0, lp = next(up); lp != 0; lp = next(lp), ++j)
		{
		    v_pos2 = v_ref + (float(u.s.index(lp)) * v_step);
		    r_sn = u.s(lp).stream_name();
		    cout << "links for " << r_sn << endl;
		    cout << "from " << i_sn << endl;
		    if (r_sn == i_sn)
			continue;
		    for (k = 1, rev = p_syl->link(r_sn)->head(); rev != 0; 
			 rev = next(rev), ++k)
		    {
			cout<<"#linking " << i_sn << " with " << r_sn << endl;
			cout << "i " << i << " j " << j << " k " << k << endl;
			p_ev = u.item(r_sn, p_syl->link(r_sn)->item(rev));
			col = ((i * 2) + j) + 2;
			aslink(outf, p_ev->mid(), p_syl->mid(), v_pos2, v_pos1,
			       col);
			// 2 is arbitrary for words, streams and phonemes.
		    }
		    
		}
	    }
    }

    for (i = 0, up = u.s.head(); up != 0; up = next(up), ++i)
    {
	v_pos1 = v_ref + (float(i) * v_step);
	*outf << "#Stream " << u.s(up).stream_name() << endl;
	for (p_syl = u.s(up).head(); p_syl != 0; p_syl = next(p_syl))
	{
	    *outf << "#name " << p_syl->name() << endl;
	    if (p_syl->feature("pos") == 1)
	    {
		aslab(outf, p_syl->mid(), v_pos1, p_syl->name());
		asbox(outf, p_syl->start(), p_syl->end(), v_pos1);
	    }
	}
    }

    
    outf->flush();

    if (outf != &cout)
	delete outf;

    return 0;
}
