/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                      Copyright (c) 1995,1996                          */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                       Author: Paul Taylor                             */
/*                       Date  : March 1995                              */
/*-----------------------------------------------------------------------*/
/*                     General play back program                         */
/*                                                                       */
/*=======================================================================*/
#include "EST.h"
#include "EST_play_audio.h"
#include "EST_cmd_line_options.h"

int read_wave(EST_Wave &sig, const EST_String &in_file, EST_Option &al);

int main (int argc, char *argv[])
{
    EST_Wave sig;
    EST_String in_file("-"), out_file("-");
    EST_StrList files;
    EST_Option al;
    EST_TBI *p;

    parse_command_line2(argc,argv,
       EST_String("Usage:   ")+
       "na_play  <options> <file0> <file1> ... \n"+
       "Summary; play waveform files on audio device\n"+
       "use \"-\" to make input and output files stdin/out\n"+
       "-h               options help\n"+
       options_wave_input()+
       "\n"+
       "-p <string>      audio device protocol. Ths supported types are\n"+
       "                 "+options_supported_audio()+"\n"+
       "-command <string>\n"+
       "                 command to play wave when protocol\n"+
       "                 is audio_command\n"+
       "-quality <string>\n"+
       "                 either [ high | low ]\n"+
       "-server <string> play sound on machine (when protocol is\n"+
       "                 server-based)\n"+
       "-v               verbose. Print file names when playing\n",
			files,al);

    // by default, prase_cl_ops adds a stdout file called "-". This is
    // irrelevant for na_play and needs to be removed.
    if (al.present("-server"))
	al.add_item("-display", al.val("-server"));

    for (p = files.head(); p; p = next(p))
    {
	if (al.present("-v"))
	    cout << "playing " << files(p) << endl;

	if (read_wave(sig, files(p), al) != format_ok)
	    exit(-1);

	if (al.present("-c"))
	    wave_extract_channel(sig,sig,al.ival("-c"));
	else  if (sig.num_channels() > 1)
	    wave_combine_channels(sig, sig);

	play_wave(sig, al);
    }
    return 0;
}

void override_lib_ops(EST_Option &a_list, EST_Option &al)
{
    // Reorg -- can be deleted ?
    // general options
    a_list.override_val("sample_rate", al.val("-f", 0));
    
    // low pass filtering options.
    a_list.override_val("lpf_cutoff",al.val("-u", 0));
    a_list.override_val("lpf_order",al.val("-o", 0));
    
    if (al.val("-L", 0) == "true")
	a_list.override_val("do_low_pass", "true");
    if (al.val("-R", 0) == "true")
	a_list.override_val("do_low_pass", "false");
    a_list.override_val("color", al.val("-color", 0));    
    a_list.override_val("f0_file_type", al.val("-otype", 0));
    a_list.override_val("wave_file_type", al.val("-itype", 0));
}

