/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                    Copyright (c) 1994,1995,1996                       */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                       Author :  Paul Taylor                           */
/*                       Date   :  July 1994                             */
/*-----------------------------------------------------------------------*/
/*                     Energy and Power functions                        */
/*                                                                       */
/*=======================================================================*/
#include <math.h>
#include <iostream.h>
#include <fstream.h>
#include "EST_Wave.h"
#include "EST_Track.h"

EST_Track power(EST_Wave &sig, float shift, float length)
{ 
    int windowsize = 256;
    short *tmp_sig, *window_start;
    float tpow;
    int i, k, pos;
    
    int frame_length = (int) (length * (float) sig.sample_rate() );
    int frame_shift = (int) (shift * (float) sig.sample_rate() );
    
    int num_frames = (int)ceil((float)sig.num_samples() / frame_shift);
    int num_samples = ((num_frames - 1) * frame_shift) + frame_length;
    
    EST_Track power(num_frames, 1);
    
    tmp_sig = new short[num_samples];
    for (i = 0; i < sig.num_samples(); ++i)
	tmp_sig[i] = sig.a(i);
    for (; i < num_samples; ++i)
	tmp_sig[i] = 0;
    
    for (k = 0 ; k < num_frames; ++k){
	pos = frame_shift * k;
	window_start = tmp_sig + pos;
	
	tpow = 0;
	for(i = 0; i < windowsize; i++)
	    tpow += pow((float)window_start[i], 2.0);
	
	tpow /= windowsize;
	power.a(k) = tpow;
    }
    power.fill_time(shift);
    delete tmp_sig;
    power.set_contour_type(EST_ContourType::POWER);
    return power;
}

EST_Track rms_energy(EST_Wave &sig, float shift, float length)
{
    EST_Track pow = power(sig, shift, length);
    int i;
    
    for (i = 0; i < pow.num_frames(); ++i)
	pow.a(i) = sqrt(pow.a(i));
    
    pow.set_contour_type(EST_ContourType::ENERGY);
    
    return pow;
}

EST_Track rms_energy(EST_Track &pow)
{
    EST_Track energy = pow;
    int i;
    
    for (i = 0; i < pow.num_frames(); ++i)
	energy.a(i) = sqrt(pow.a(i));
    
    energy.set_contour_type(EST_ContourType::ENERGY);
    return energy;
}
