 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /************************************************************************/
 /*                 Author: Richard Caley (rjc@cstr.ed.ac.uk)            */
 /*                   Date: Tue Apr 29 1997                              */
 /************************************************************************/
 /*                                                                      */
 /* Example of hash table use.                                           */
 /*                                                                      */
 /************************************************************************/

#include <stdlib.h>
#include <iostream.h>
#include <math.h>
#include "EST_THash.h"
#include "EST_String.h"

// a very boring thing to do to a pair, see map below

static void look_at(EST_String &s, int &l)
{
  (void)s;
  (void)l;
  cout << ".";
}

int
main(void)
{
// Map from strings to numbers, hashed by default method.

EST_TStringHash<int> lengths(100);

lengths.add_item("fred", 4);
lengths.add_item("bill", 4);
lengths.add_item("harry", 5);

// Map from ints to floats. Note, the other way around is alomst
// certainly a mistake.

EST_THash<int,float> logs(100);

logs.add_item(12, log(12));
logs.add_item(34, log(34));

cout << "length of `fred' = " << lengths.val("fred") << "\n";
cout << "log of 34' = " << logs.val(34) << "\n";

// the second argument to val can be used to
// ask whether the result was actually found. Useful
// when the dummy value returned for an unknown key is
// actually a valid value for the application.

int found;
float val = logs.val(123, found);

cout << "log of 123";

if (found)
  cout << " = " << val;
else
  cout << " not found";

cout << "\n";

// dump puts out a human readable version of the table for debugging
lengths.dump(cout);

// map calls a function on each pair, in this case just prints one dot per
// pair (see definition of look_at earlier).

lengths.map(look_at);
cout << "\n";

 return 0;
}


// This is how to declare the tamplates for GCC
// GCC is too stupid to know that if it creates a StringHash
// it must create the parent Hash, so we have to list both explicitly.

// Also note we declare the dummy value returned by val when there is
// no such entry.

#if defined(INSTANTIATE_TEMPLATES)
#include "../base_class/EST_THash.cc"

template class EST_TStringHash<int>;
template class EST_THash<EST_String,int>;
template class EST_Hash_Pair<EST_String,int>;

template class EST_THash<int,float>;
#endif
int EST_THash<EST_String,int>::Dummy_Value = 0;
float EST_THash<int,float>::Dummy_Value = 0.0;
