(***********************************************************************)
(*                                                                     *)
(*                           Calves                                    *)
(*                                                                     *)
(*          Francois Rouaix, projet Cristal, INRIA Rocquencourt        *)
(*                                                                     *)
(*  Copyright 1996 Institut National de Recherche en Informatique et   *)
(*  Automatique.  Distributed only by permission.                      *)
(*                                                                     *)
(***********************************************************************)

(* The rights as stored *)
type right =
   FileR of string			(* read access to files *)
 | FileW of string			(* write acces to files *)
 | DocumentR of string			(* read access to URLs *)
    (* Document read access affects decoders, embedded viewers, as well as
       the general retrieval mechanism *)
 | HTMLDisplay
   (* HTML display machine access *)    

module Rights : Set.S with type elt = bool * right

type mode = Fixed | Extend | Temporary


type browser_private = Document.document_id (* browser specific *)

type t = {
  mutable mode : mode;
  mutable rights : Rights.t;
  who : string;
  browser_private : browser_private
  }

val local_default : Url.t -> browser_private -> t
val lenient_default : Url.t -> browser_private -> t
val strict_default : Url.t -> browser_private -> t
val lenient_default : Url.t -> browser_private -> t


val set : t -> unit
val reset : unit -> unit

val ask: t -> right -> bool
  (* [ask capa right] *)


exception Denied

val require: t -> right list -> bool
  (* get some specific capabilities, to avoid popping dialog boxes all
     over the place. Moreover, can make use of regexp
   *)

(* IMPORTANT: These functions may only be called at load-time *)

val get : unit -> t 
  (* get the default capabilities *)
val whoami : unit -> string
  (* get our url location. Can be used to set initial rights using
     paths computed from location, or also to prohibit (more or less)
     copying of an applet *)

