open Www
open Document
open Http_headers

type vparams = (string * string) list
(* list of additionnal parameters for the viewer, according to its
   activation point *)
  
(* The context given to a viewer *)
(* Standard hyper functions are: "goto", "save", "gotonew" *)
type context = {
  viewer_base : Document.document_id;
    (* the base document for embedded viewers *)
  viewer_hyper: (string * Hyper.func) list;
    (* my other name is Captain Hook *)
  viewer_log : string -> unit;
    (* logging *)
  viewer_params : vparams
    (* Parameters of viewer *)
  }

(* The object created/returned by a viewer *)
type display_info = {
  di_widget : Widget.widget;
  di_abort : unit -> unit;		(* stop display *)
  di_destroy : unit -> unit;		(* die *)
  di_fragment : string option -> unit;	(* for # URIs *)
  di_redisplay : unit -> unit;		(* redisplay *)
  di_title : unit -> string;		(* some visible title *)
  di_source : unit -> unit;	        (* source viewer *)
  di_load_images : unit -> unit;	(* load images *)
  mutable di_last_used : int
}

val di_compare : display_info -> display_info -> bool

val add_viewer : media_type ->
  (media_parameter list -> Widget.widget -> context -> handle -> display_info option) -> unit
    (* [add_viewer type viewer] *)

val rem_viewer : media_type -> unit

val view : Widget.widget -> context -> handle -> display_info option

